/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.OrientationObserver;
import bibliothek.gui.dock.station.OrientedDockStation;
import bibliothek.gui.dock.station.OrientingDockStationEvent;
import bibliothek.gui.dock.station.OrientingDockStationListener;
import bibliothek.gui.dock.station.StationBackgroundComponent;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.ToolbarTabDockStation;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItem;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemListener;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.SilentPropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public abstract class AbstractToolbarDockStation
extends AbstractDockableStation
implements OrientedDockStation,
ExpandableToolbarItem {
    public static final PropertyKey<Boolean> ON_CONFLICT_ENABLE = new PropertyKey<Boolean>("ExpandableToolbarGroupActions.on_conflict_enable", new ConstantPropertyFactory<Boolean>(Boolean.TRUE), true);
    protected DisplayerCollection displayers;
    protected DefaultDisplayerFactoryValue displayerFactory;
    protected DockTitleVersion title;
    protected DefaultStationPaintValue paint;
    protected Orientation orientation = Orientation.HORIZONTAL;
    private final List<OrientingDockStationListener> orientingListeners = new ArrayList<OrientingDockStationListener>();
    private final List<ExpandableToolbarItemListener> expandableListeners = new ArrayList<ExpandableToolbarItemListener>();
    private ExpandedState state = ExpandedState.SHRUNK;
    private ExpandableListener expandableListener = new ExpandableListener();
    private PropertyValue<ExpandableToolbarItemStrategy> expandableStategy = new PropertyValue<ExpandableToolbarItemStrategy>(ExpandableToolbarItemStrategy.STRATEGY){

        @Override
        protected void valueChanged(ExpandableToolbarItemStrategy expandableToolbarItemStrategy, ExpandableToolbarItemStrategy expandableToolbarItemStrategy2) {
            if (expandableToolbarItemStrategy != null) {
                expandableToolbarItemStrategy.removeExpandedListener(AbstractToolbarDockStation.this.expandableListener);
            }
            if (expandableToolbarItemStrategy2 != null) {
                expandableToolbarItemStrategy2.addExpandedListener(AbstractToolbarDockStation.this.expandableListener);
            }
            AbstractToolbarDockStation.this.fireEnablementChanged();
        }
    };
    private PropertyValue<Boolean> onConflictEnable = new PropertyValue<Boolean>(ON_CONFLICT_ENABLE){

        @Override
        protected void valueChanged(Boolean bl, Boolean bl2) {
            AbstractToolbarDockStation.this.fireEnablementChanged();
        }
    };
    private boolean[] expandedEnablementStateCache = new boolean[ExpandedState.values().length];
    private Dockable removal;
    private Background background;

    public AbstractToolbarDockStation() {
        new OrientationObserver(this){

            @Override
            protected void orientationChanged(Orientation orientation) {
                if (orientation != null) {
                    AbstractToolbarDockStation.this.setOrientation(orientation);
                }
            }
        };
        this.addDockStationListener(new DockStationAdapter(){

            @Override
            public void dockableAdded(DockStation dockStation, Dockable dockable) {
                AbstractToolbarDockStation.this.fireEnablementChanged();
            }

            @Override
            public void dockableRemoved(DockStation dockStation, Dockable dockable) {
                AbstractToolbarDockStation.this.fireEnablementChanged();
            }
        });
    }

    @Override
    public void setController(DockController dockController) {
        super.setController(dockController);
        this.expandableStategy.setProperties(dockController);
        this.onConflictEnable.setProperties(dockController);
        this.background.setController(dockController);
    }

    protected void init(String string) {
        this.background = new Background(string);
    }

    protected JPanel createBackgroundPanel() {
        ConfiguredBackgroundPanel configuredBackgroundPanel = new ConfiguredBackgroundPanel(Transparency.DEFAULT);
        configuredBackgroundPanel.setBackground(this.background);
        return configuredBackgroundPanel;
    }

    protected BackgroundAlgorithm getBackgroundAlgorithm() {
        return this.background;
    }

    @Override
    public Dockable getFrontDockable() {
        return null;
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    public int indexOf(Dockable dockable) {
        for (int i = 0; i < this.getDockableCount(); ++i) {
            if (this.getDockable(i) != dockable) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void addOrientingDockStationListener(OrientingDockStationListener orientingDockStationListener) {
        this.orientingListeners.add(orientingDockStationListener);
    }

    @Override
    public void removeOrientingDockStationListener(OrientingDockStationListener orientingDockStationListener) {
        this.orientingListeners.remove(orientingDockStationListener);
    }

    @Override
    public Orientation getOrientationOf(Dockable dockable) {
        return this.getOrientation();
    }

    protected void fireOrientingEvent() {
        OrientingDockStationEvent orientingDockStationEvent = new OrientingDockStationEvent(this);
        for (OrientingDockStationListener orientingDockStationListener : this.orientingListeners.toArray(new OrientingDockStationListener[this.orientingListeners.size()])) {
            orientingDockStationListener.changed(orientingDockStationEvent);
        }
    }

    @Override
    public ExpandedState getExpandedState() {
        return this.state;
    }

    public void setExpandedState(ExpandedState expandedState, boolean bl) {
        if (bl) {
            this.setExpandedState(expandedState);
        } else {
            this.state = expandedState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExpandedState(ExpandedState expandedState) {
        if (this.state != expandedState) {
            DockController dockController = this.getController();
            if (dockController != null) {
                dockController.freezeLayout();
            }
            try {
                ExpandedState expandedState2 = this.state;
                this.state = expandedState;
                if (expandedState2 != ExpandedState.SHRUNK) {
                    this.shrink(expandedState2);
                }
                if (expandedState == ExpandedState.EXPANDED) {
                    this.expand();
                } else if (expandedState == ExpandedState.STRETCHED) {
                    this.stretch();
                }
                for (ExpandableToolbarItemListener expandableToolbarItemListener : this.expandableListeners) {
                    expandableToolbarItemListener.changed(this, expandedState2, expandedState);
                }
            }
            finally {
                if (dockController != null) {
                    dockController.meltLayout();
                }
            }
        }
    }

    @Override
    public boolean isEnabled(ExpandedState expandedState) {
        ExpandableToolbarItemStrategy expandableToolbarItemStrategy = this.expandableStategy.getValue();
        if (expandableToolbarItemStrategy == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        DockStation dockStation = null;
        if (this.getExpandedState() == ExpandedState.EXPANDED && this.getDockableCount() == 1) {
            dockStation = this.getDockable(0).asDockStation();
        }
        if (dockStation == null) {
            dockStation = this;
        }
        int n = dockStation.getDockableCount();
        for (int i = 0; i < n; ++i) {
            if (expandableToolbarItemStrategy.isEnabled(dockStation.getDockable(i), expandedState)) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (bl && bl2) {
            this.onConflictEnable.getValue();
        }
        return bl;
    }

    private void expand() {
        int n;
        DockController dockController = this.getController();
        Dockable dockable = null;
        Dockable[] dockableArray = new Dockable[this.getDockableCount()];
        for (n = 0; n < dockableArray.length; ++n) {
            dockableArray[n] = this.getDockable(n);
            if (dockController == null || !dockController.isFocused(dockableArray[n])) continue;
            dockable = dockableArray[n];
        }
        for (n = dockableArray.length - 1; n >= 0; --n) {
            this.remove(this.getDockable(n));
        }
        ToolbarTabDockStation toolbarTabDockStation = new ToolbarTabDockStation();
        for (Dockable dockable2 : dockableArray) {
            toolbarTabDockStation.drop(dockable2);
        }
        this.drop(toolbarTabDockStation);
        if (dockable != null) {
            toolbarTabDockStation.setFrontDockable(dockable);
            dockController.setFocusedDockable(dockable, true);
        }
    }

    public void stretch() {
    }

    public void shrink(ExpandedState expandedState) {
        if (expandedState == ExpandedState.EXPANDED) {
            int n;
            DockController dockController = this.getController();
            DockStation dockStation = this.getDockable(0).asDockStation();
            Dockable dockable = dockStation.getFrontDockable();
            this.remove(this.getDockable(0));
            Dockable[] dockableArray = new Dockable[dockStation.getDockableCount()];
            for (n = 0; n < dockableArray.length; ++n) {
                dockableArray[n] = dockStation.getDockable(n);
            }
            for (n = dockableArray.length - 1; n >= 0; --n) {
                dockStation.drag(dockableArray[n]);
            }
            for (Dockable dockable2 : dockableArray) {
                this.drop(dockable2);
            }
            if (dockable != null && dockController != null) {
                dockController.setFocusedDockable(dockable, true);
            }
        }
    }

    @Override
    public void addExpandableListener(ExpandableToolbarItemListener expandableToolbarItemListener) {
        if (expandableToolbarItemListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.expandableListeners.add(expandableToolbarItemListener);
    }

    @Override
    public void removeExpandableListener(ExpandableToolbarItemListener expandableToolbarItemListener) {
        this.expandableListeners.remove(expandableToolbarItemListener);
    }

    protected ExpandableToolbarItemListener[] expandableListeners() {
        return this.expandableListeners.toArray(new ExpandableToolbarItemListener[this.expandableListeners.size()]);
    }

    private void fireEnablementChanged() {
        for (ExpandedState expandedState : ExpandedState.values()) {
            this.fireEnablementChanged(expandedState);
        }
    }

    private void fireEnablementChanged(ExpandedState expandedState) {
        boolean bl = this.isEnabled(expandedState);
        if (bl != this.expandedEnablementStateCache[expandedState.ordinal()]) {
            this.expandedEnablementStateCache[expandedState.ordinal()] = bl;
            for (ExpandableToolbarItemListener expandableToolbarItemListener : this.expandableListeners()) {
                expandableToolbarItemListener.enablementChanged(this, expandedState, bl);
            }
        }
    }

    public ToolbarStrategy getToolbarStrategy() {
        SilentPropertyValue<ToolbarStrategy> silentPropertyValue = new SilentPropertyValue<ToolbarStrategy>(ToolbarStrategy.STRATEGY, this.getController());
        ToolbarStrategy toolbarStrategy = (ToolbarStrategy)silentPropertyValue.getValue();
        silentPropertyValue.setProperties((DockController)null);
        return toolbarStrategy;
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        if (this.getExpandedState() == ExpandedState.EXPANDED) {
            DockStation dockStation = dockable.asDockStation();
            return dockStation != null && dockStation.getDockableCount() == 0;
        }
        return true;
    }

    protected abstract void remove(Dockable var1);

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return dockable.getClass() == dockable2.getClass();
    }

    @Override
    public void replace(DockStation dockStation, Dockable dockable) {
        this.replace(dockStation.asDockable(), dockable);
    }

    @Override
    public StationDragOperation prepareDrag(Dockable dockable) {
        this.removal = dockable;
        this.getComponent().repaint();
        return new StationDragOperation(){

            @Override
            public void succeeded() {
                AbstractToolbarDockStation.this.removal = null;
                AbstractToolbarDockStation.this.getComponent().repaint();
            }

            @Override
            public void canceled() {
                AbstractToolbarDockStation.this.removal = null;
                AbstractToolbarDockStation.this.getComponent().repaint();
            }
        };
    }

    protected Dockable getRemoval() {
        return this.removal;
    }

    protected abstract DefaultDisplayerFactoryValue createDisplayerFactory();

    public DefaultStationPaintValue getPaint() {
        return this.paint;
    }

    protected abstract DockTitleVersion registerTitle(DockController var1);

    protected abstract void discard(DockableDisplayer var1);

    private class ExpandableListener
    implements ExpandableToolbarItemStrategyListener {
        private ExpandableListener() {
        }

        @Override
        public void expanded(Dockable dockable) {
        }

        @Override
        public void stretched(Dockable dockable) {
        }

        @Override
        public void shrunk(Dockable dockable) {
        }

        @Override
        public void enablementChanged(Dockable dockable, ExpandedState expandedState, boolean bl) {
            if (dockable.getDockParent() == AbstractToolbarDockStation.this) {
                AbstractToolbarDockStation.this.fireEnablementChanged(expandedState);
            }
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements StationBackgroundComponent {
        public Background(String string) {
            super(StationBackgroundComponent.KIND, string);
        }

        @Override
        public Component getComponent() {
            return AbstractToolbarDockStation.this.getComponent();
        }

        @Override
        public DockStation getStation() {
            return AbstractToolbarDockStation.this;
        }
    }
}

