/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.toolbar.expand;

public enum ExpandedState {
    EXPANDED,
    STRETCHED,
    SHRUNK;


    public static ExpandedState getOrdered(int n) {
        switch (n) {
            case 0: {
                return SHRUNK;
            }
            case 1: {
                return STRETCHED;
            }
            case 2: {
                return EXPANDED;
            }
        }
        throw new IllegalArgumentException("size out of bounds: " + n);
    }

    public int getOrder() {
        switch (this) {
            case SHRUNK: {
                return 0;
            }
            case STRETCHED: {
                return 1;
            }
            case EXPANDED: {
                return 2;
            }
        }
        throw new IllegalStateException("never happens");
    }

    public ExpandedState smaller() {
        int n = this.getOrder() - 1;
        if (n < 0) {
            return this;
        }
        return ExpandedState.getOrdered(n);
    }

    public ExpandedState larger() {
        int n = this.getOrder() + 1;
        if (n >= ExpandedState.values().length) {
            return this;
        }
        return ExpandedState.getOrdered(n);
    }
}

