
    // OpenCL Kernel Function for element by element vector addition
    kernel void VectorAdd(global float3* center, global float* r, global const float* a, global const float* listPoints, global float* arePointsInside, int numPoints) {

        // get index into global data array
        int iGID = get_global_id(0);

        // bound check (equivalent to the limit on a 'for' loop for standard/serial C code
        if (iGID >= numPoints)  {
            return;
        }

        // add the vector elements
        c[iGID] = a[iGID] + b[iGID];
    }