/*
 * Decompiled with CFR 0.152.
 */
package com.cryptlex.lexactivator;

import com.cryptlex.lexactivator.ActivationMode;
import com.cryptlex.lexactivator.LexActivatorException;
import com.cryptlex.lexactivator.LexActivatorNative;
import com.cryptlex.lexactivator.LicenseCallbackEvent;
import com.cryptlex.lexactivator.LicenseMeterAttribute;
import com.cryptlex.lexactivator.OrganizationAddress;
import com.cryptlex.lexactivator.ProductVersionFeatureFlag;
import com.cryptlex.lexactivator.Release;
import com.cryptlex.lexactivator.ReleaseCallbackEvent;
import com.cryptlex.lexactivator.ReleaseUpdateCallbackEvent;
import com.cryptlex.lexactivator.UserLicense;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class LexActivator {
    private static LexActivatorNative.CallbackType privateLicenseCallback = null;
    private static LexActivatorNative.CallbackType privateReleaseCallback = null;
    private static LexActivatorNative.ReleaseUpdateCallbackType privateReleaseUpdateCallback = null;
    private static LexActivatorNative.ReleaseUpdateCallbackTypeA privateReleaseUpdateCallbackA = null;
    private static List<LicenseCallbackEvent> licenseCallbackEventListeners = null;
    private static List<ReleaseCallbackEvent> releaseCallbackEventListeners = null;
    private static List<ReleaseUpdateCallbackEvent> releaseUpdateCallbackEventListeners = null;
    public static final int LA_USER = 1;
    public static final int LA_SYSTEM = 2;
    public static final int LA_IN_MEMORY = 4;
    public static final int LA_RELEASES_ALL = 1;
    public static final int LA_RELEASES_ALLOWED = 2;
    public static final int LA_OK = 0;
    public static final int LA_FAIL = 1;
    public static final int LA_EXPIRED = 20;
    public static final int LA_SUSPENDED = 21;
    public static final int LA_GRACE_PERIOD_OVER = 22;
    public static final int LA_TRIAL_EXPIRED = 25;
    public static final int LA_LOCAL_TRIAL_EXPIRED = 26;
    public static final int LA_RELEASE_UPDATE_AVAILABLE = 30;
    public static final int LA_RELEASE_NO_UPDATE_AVAILABLE = 31;
    public static final int LA_RELEASE_UPDATE_NOT_AVAILABLE = 31;
    public static final int LA_RELEASE_UPDATE_AVAILABLE_NOT_ALLOWED = 32;

    public static void SetProductFile(String filePath) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetProductFile(new WString(filePath)) : LexActivatorNative.SetProductFile(filePath);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetProductData(String productData) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetProductData(new WString(productData)) : LexActivatorNative.SetProductData(productData);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetProductId(String productId, int flags) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetProductId(new WString(productId), flags) : LexActivatorNative.SetProductId(productId, flags);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetDataDirectory(String directoryPath) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetDataDirectory(new WString(directoryPath)) : LexActivatorNative.SetDataDirectory(directoryPath);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetCustomDeviceFingerprint(String fingerprint) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetCustomDeviceFingerprint(new WString(fingerprint)) : LexActivatorNative.SetCustomDeviceFingerprint(fingerprint);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetLicenseKey(String licenseKey) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetLicenseKey(new WString(licenseKey)) : LexActivatorNative.SetLicenseKey(licenseKey);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetLicenseUserCredential(String email, String password) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetLicenseUserCredential(new WString(email), new WString(password)) : LexActivatorNative.SetLicenseUserCredential(email, password);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetLicenseCallbackListener(LicenseCallbackEvent listener) throws LexActivatorException {
        int status;
        if (licenseCallbackEventListeners == null) {
            licenseCallbackEventListeners = new ArrayList<LicenseCallbackEvent>();
            licenseCallbackEventListeners.add(listener);
        }
        if (privateLicenseCallback == null && 0 != (status = LexActivatorNative.SetLicenseCallback(privateLicenseCallback = new LexActivatorNative.CallbackType(){

            @Override
            public void invoke(int status) {
                for (LicenseCallbackEvent event : licenseCallbackEventListeners) {
                    event.LicenseCallback(status);
                }
            }
        }))) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetActivationMetadata(String key, String value) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetActivationMetadata(new WString(key), new WString(value)) : LexActivatorNative.SetActivationMetadata(key, value);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetTrialActivationMetadata(String key, String value) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetTrialActivationMetadata(new WString(key), new WString(value)) : LexActivatorNative.SetTrialActivationMetadata(key, value);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetAppVersion(String appVersion) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetAppVersion(new WString(appVersion)) : LexActivatorNative.SetAppVersion(appVersion);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetReleaseVersion(String releaseVersion) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetReleaseVersion(new WString(releaseVersion)) : LexActivatorNative.SetReleaseVersion(releaseVersion);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetReleasePublishedDate(int releasePublishedDate) throws LexActivatorException {
        int status = LexActivatorNative.SetReleasePublishedDate(releasePublishedDate);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetReleasePlatform(String releasePlatform) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetReleasePlatform(new WString(releasePlatform)) : LexActivatorNative.SetReleasePlatform(releasePlatform);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetReleaseChannel(String releaseChannel) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetReleaseChannel(new WString(releaseChannel)) : LexActivatorNative.SetReleaseChannel(releaseChannel);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetActivationLeaseDuration(int leaseDuration) throws LexActivatorException {
        int status = LexActivatorNative.SetActivationLeaseDuration(leaseDuration);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetOfflineActivationRequestMeterAttributeUses(String name, int uses) throws LexActivatorException, UnsupportedEncodingException {
        if (Platform.isWindows()) {
            int status = LexActivatorNative.SetOfflineActivationRequestMeterAttributeUses(new WString(name), uses);
            if (0 != status) {
                throw new LexActivatorException(status);
            }
        } else {
            int status = LexActivatorNative.SetOfflineActivationRequestMeterAttributeUses(name, uses);
            if (0 != status) {
                throw new LexActivatorException(status);
            }
        }
    }

    public static void SetNetworkProxy(String proxy) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetNetworkProxy(new WString(proxy)) : LexActivatorNative.SetNetworkProxy(proxy);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetCryptlexHost(String host) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetCryptlexHost(new WString(host)) : LexActivatorNative.SetCryptlexHost(host);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static void SetTwoFactorAuthenticationCode(String twoFactorAuthenticationCode) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.SetTwoFactorAuthenticationCode(new WString(twoFactorAuthenticationCode)) : LexActivatorNative.SetTwoFactorAuthenticationCode(twoFactorAuthenticationCode);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static String GetProductMetadata(String key) throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetProductMetadata(new WString(key), buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetProductMetadata(key, buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetProductVersionName() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetProductVersionName(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetProductVersionName(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetProductVersionDisplayName() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetProductVersionDisplayName(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetProductVersionDisplayName(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static ProductVersionFeatureFlag GetProductVersionFeatureFlag(String name) throws LexActivatorException, UnsupportedEncodingException {
        int status;
        IntByReference enabled = new IntByReference(0);
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetProductVersionFeatureFlag(new WString(name), enabled, buffer, 256);
            if (0 == status) {
                return new ProductVersionFeatureFlag(name, enabled.getValue() > 0, buffer.toString().trim());
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetProductVersionFeatureFlag(name, enabled, buffer, 256);
            if (0 == status) {
                return new ProductVersionFeatureFlag(name, enabled.getValue() > 0, new String(buffer.array(), "UTF-8").trim());
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetLicenseMetadata(String key) throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseMetadata(new WString(key), buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseMetadata(key, buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static LicenseMeterAttribute GetLicenseMeterAttribute(String name) throws LexActivatorException, UnsupportedEncodingException {
        int status;
        IntByReference allowedUses = new IntByReference(0);
        IntByReference totalUses = new IntByReference(0);
        IntByReference grossUses = new IntByReference(0);
        if (Platform.isWindows() ? 0 == (status = LexActivatorNative.GetLicenseMeterAttribute(new WString(name), allowedUses, totalUses, grossUses)) : 0 == (status = LexActivatorNative.GetLicenseMeterAttribute(name, allowedUses, totalUses, grossUses))) {
            return new LicenseMeterAttribute(name, allowedUses.getValue(), totalUses.getValue(), grossUses.getValue());
        }
        throw new LexActivatorException(status);
    }

    public static String GetLicenseKey() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseKey(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseKey(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static int GetLicenseAllowedActivations() throws LexActivatorException {
        IntByReference allowedActivations = new IntByReference(0);
        int status = LexActivatorNative.GetLicenseAllowedActivations(allowedActivations);
        switch (status) {
            case 0: {
                return allowedActivations.getValue();
            }
            case 1: {
                return 0;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int GetLicenseTotalActivations() throws LexActivatorException {
        IntByReference totalActivations = new IntByReference(0);
        int status = LexActivatorNative.GetLicenseTotalActivations(totalActivations);
        switch (status) {
            case 0: {
                return totalActivations.getValue();
            }
            case 1: {
                return 0;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int GetLicenseCreationDate() throws LexActivatorException {
        IntByReference creationDate = new IntByReference(0);
        int status = LexActivatorNative.GetLicenseCreationDate(creationDate);
        switch (status) {
            case 0: {
                return creationDate.getValue();
            }
            case 1: {
                return 0;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int GetLicenseActivationDate() throws LexActivatorException {
        IntByReference activationDate = new IntByReference(0);
        int status = LexActivatorNative.GetLicenseActivationDate(activationDate);
        switch (status) {
            case 0: {
                return activationDate.getValue();
            }
            case 1: {
                return 0;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int GetLicenseExpiryDate() throws LexActivatorException {
        IntByReference expiryDate = new IntByReference(0);
        int status = LexActivatorNative.GetLicenseExpiryDate(expiryDate);
        switch (status) {
            case 0: {
                return expiryDate.getValue();
            }
            case 1: {
                return 0;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int GetLicenseMaintenanceExpiryDate() throws LexActivatorException {
        IntByReference maintenanceExpiryDate = new IntByReference(0);
        int status = LexActivatorNative.GetLicenseMaintenanceExpiryDate(maintenanceExpiryDate);
        switch (status) {
            case 0: {
                return maintenanceExpiryDate.getValue();
            }
            case 1: {
                return 0;
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetLicenseUserEmail() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseUserEmail(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseUserEmail(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetLicenseUserName() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseUserName(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseUserName(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetLicenseUserCompany() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseUserCompany(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseUserCompany(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetLicenseUserMetadata(String key) throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseUserMetadata(new WString(key), buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseUserMetadata(key, buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetLicenseOrganizationName() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseOrganizationName(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseOrganizationName(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<UserLicense> GetUserLicenses() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        int bufferSize = 4096;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(bufferSize);
            status = LexActivatorNative.GetUserLicensesInternal(buffer, bufferSize);
            if (0 != status) throw new LexActivatorException(status);
            String userLicensesJson = buffer.toString().trim();
            if (userLicensesJson.isEmpty()) return new ArrayList<UserLicense>();
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (List)objectMapper.readValue(userLicensesJson, (TypeReference)new TypeReference<List<UserLicense>>(){});
            }
            catch (JsonProcessingException userLicenses) {
                throw new LexActivatorException(status);
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        status = LexActivatorNative.GetUserLicensesInternal(buffer, bufferSize);
        if (0 != status) throw new LexActivatorException(status);
        String userLicensesJson = new String(buffer.array(), "UTF-8").trim();
        if (userLicensesJson.isEmpty()) return new ArrayList<UserLicense>();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (List)objectMapper.readValue(userLicensesJson, (TypeReference)new TypeReference<List<UserLicense>>(){});
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new LexActivatorException(status);
        }
    }

    public static OrganizationAddress GetLicenseOrganizationAddress() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        int bufferSize = 1024;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(bufferSize);
            status = LexActivatorNative.GetLicenseOrganizationAddressInternal(buffer, bufferSize);
            if (0 == status) {
                String jsonAddress = buffer.toString().trim();
                if (!jsonAddress.isEmpty()) {
                    OrganizationAddress organizationAddress = null;
                    ObjectMapper objectMapper = new ObjectMapper();
                    try {
                        organizationAddress = (OrganizationAddress)objectMapper.readValue(jsonAddress, OrganizationAddress.class);
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        // empty catch block
                    }
                    return organizationAddress;
                }
                return null;
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
            status = LexActivatorNative.GetLicenseOrganizationAddressInternal(buffer, bufferSize);
            if (0 == status) {
                String jsonAddress = new String(buffer.array(), "UTF-8").trim();
                if (!jsonAddress.isEmpty()) {
                    OrganizationAddress organizationAddress = null;
                    ObjectMapper objectMapper = new ObjectMapper();
                    try {
                        organizationAddress = (OrganizationAddress)objectMapper.readValue(jsonAddress, OrganizationAddress.class);
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        // empty catch block
                    }
                    return organizationAddress;
                }
                return null;
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetLicenseType() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseType(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetLicenseType(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetActivationMetadata(String key) throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetActivationMetadata(new WString(key), buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetActivationMetadata(key, buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static ActivationMode GetActivationMode() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer currentModeBuffer;
            CharBuffer initialModeBuffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetActivationMode(initialModeBuffer, 256, currentModeBuffer = CharBuffer.allocate(256), 256);
            if (0 == status) {
                return new ActivationMode(initialModeBuffer.toString().trim(), currentModeBuffer.toString().trim());
            }
        } else {
            ByteBuffer currentModeBuffer;
            ByteBuffer initialModeBuffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetActivationMode(initialModeBuffer, 256, currentModeBuffer = ByteBuffer.allocate(256), 256);
            if (0 == status) {
                return new ActivationMode(new String(initialModeBuffer.array(), "UTF-8").trim(), new String(currentModeBuffer.array(), "UTF-8").trim());
            }
        }
        throw new LexActivatorException(status);
    }

    public static int GetActivationMeterAttributeUses(String name) throws LexActivatorException, UnsupportedEncodingException {
        int status;
        IntByReference uses = new IntByReference(0);
        if (Platform.isWindows() ? 0 == (status = LexActivatorNative.GetActivationMeterAttributeUses(new WString(name), uses)) : 0 == (status = LexActivatorNative.GetActivationMeterAttributeUses(name, uses))) {
            return uses.getValue();
        }
        throw new LexActivatorException(status);
    }

    public static int GetServerSyncGracePeriodExpiryDate() throws LexActivatorException {
        IntByReference expiryDate = new IntByReference(0);
        int status = LexActivatorNative.GetServerSyncGracePeriodExpiryDate(expiryDate);
        switch (status) {
            case 0: {
                return expiryDate.getValue();
            }
            case 1: {
                return 0;
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetTrialActivationMetadata(String key) throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetTrialActivationMetadata(new WString(key), buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetTrialActivationMetadata(key, buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static int GetTrialExpiryDate() throws LexActivatorException {
        IntByReference trialExpiryDate = new IntByReference(0);
        int status = LexActivatorNative.GetTrialExpiryDate(trialExpiryDate);
        switch (status) {
            case 0: {
                return trialExpiryDate.getValue();
            }
            case 1: {
                return 0;
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetTrialId() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetTrialId(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetTrialId(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static int GetLocalTrialExpiryDate() throws LexActivatorException {
        IntByReference trialExpiryDate = new IntByReference(0);
        int status = LexActivatorNative.GetLocalTrialExpiryDate(trialExpiryDate);
        switch (status) {
            case 0: {
                return trialExpiryDate.getValue();
            }
            case 1: {
                return 0;
            }
        }
        throw new LexActivatorException(status);
    }

    public static String GetLibraryVersion() throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexActivatorNative.GetLibraryVersion(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexActivatorNative.GetLibraryVersion(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexActivatorException(status);
    }

    public static void CheckForReleaseUpdate(String platform, String version, String channel, ReleaseCallbackEvent listener) throws LexActivatorException {
        if (releaseCallbackEventListeners == null) {
            releaseCallbackEventListeners = new ArrayList<ReleaseCallbackEvent>();
            releaseCallbackEventListeners.add(listener);
        }
        if (privateReleaseCallback == null) {
            int status;
            privateReleaseCallback = new LexActivatorNative.CallbackType(){

                @Override
                public void invoke(int status) {
                    for (ReleaseCallbackEvent event : releaseCallbackEventListeners) {
                        event.ReleaseCallback(status);
                    }
                }
            };
            int n = status = Platform.isWindows() ? LexActivatorNative.CheckForReleaseUpdate(new WString(platform), new WString(version), new WString(channel), privateReleaseCallback) : LexActivatorNative.CheckForReleaseUpdate(platform, version, channel, privateReleaseCallback);
            if (0 != status) {
                throw new LexActivatorException(status);
            }
        }
    }

    public static void CheckReleaseUpdate(ReleaseUpdateCallbackEvent listener, int releaseFlags, final Object userData) throws LexActivatorException, UnsupportedEncodingException {
        int status;
        if (releaseUpdateCallbackEventListeners == null) {
            releaseUpdateCallbackEventListeners = new ArrayList<ReleaseUpdateCallbackEvent>();
            releaseUpdateCallbackEventListeners.add(listener);
        }
        if (Platform.isWindows()) {
            if (privateReleaseUpdateCallback == null) {
                privateReleaseUpdateCallback = new LexActivatorNative.ReleaseUpdateCallbackType(){

                    @Override
                    public void invoke(int status, WString releaseJson, Pointer unused) {
                        byte[] releaseJsonArray = releaseJson.toString().getBytes(StandardCharsets.UTF_8);
                        String releaseJsonStr = new String(releaseJsonArray, StandardCharsets.UTF_8);
                        Release release = null;
                        if (!releaseJsonStr.isEmpty()) {
                            ObjectMapper mapper = new ObjectMapper();
                            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                            try {
                                release = (Release)mapper.readValue(releaseJsonStr, Release.class);
                            }
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        for (ReleaseUpdateCallbackEvent event : releaseUpdateCallbackEventListeners) {
                            event.ReleaseUpdateCallback(status, release, userData);
                        }
                    }
                };
            }
        } else if (privateReleaseUpdateCallbackA == null) {
            privateReleaseUpdateCallbackA = new LexActivatorNative.ReleaseUpdateCallbackTypeA(){

                @Override
                public void invoke(int status, String releaseJson, Pointer unused) {
                    Release release = null;
                    if (!releaseJson.isEmpty()) {
                        ObjectMapper mapper = new ObjectMapper();
                        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                        try {
                            release = (Release)mapper.readValue(releaseJson, Release.class);
                        }
                        catch (JsonProcessingException jsonProcessingException) {
                            // empty catch block
                        }
                    }
                    for (ReleaseUpdateCallbackEvent event : releaseUpdateCallbackEventListeners) {
                        event.ReleaseUpdateCallback(status, release, userData);
                    }
                }
            };
        }
        int n = status = Platform.isWindows() ? LexActivatorNative.CheckReleaseUpdateInternal(privateReleaseUpdateCallback, releaseFlags, Pointer.NULL) : LexActivatorNative.CheckReleaseUpdateInternal(privateReleaseUpdateCallbackA, releaseFlags, Pointer.NULL);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static int AuthenticateUser(String email, String password) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.AuthenticateUser(new WString(email), new WString(password)) : LexActivatorNative.AuthenticateUser(email, password);
        if (0 == status) {
            return 0;
        }
        throw new LexActivatorException(status);
    }

    public static int ActivateLicense() throws LexActivatorException {
        int status = LexActivatorNative.ActivateLicense();
        switch (status) {
            case 0: {
                return 0;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int ActivateLicenseOffline(String filePath) throws LexActivatorException {
        int status = Platform.isWindows() ? LexActivatorNative.ActivateLicenseOffline(new WString(filePath)) : LexActivatorNative.ActivateLicenseOffline(filePath);
        switch (status) {
            case 0: {
                return 0;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static void GenerateOfflineActivationRequest(String filePath) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.GenerateOfflineActivationRequest(new WString(filePath)) : LexActivatorNative.GenerateOfflineActivationRequest(filePath);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static int DeactivateLicense() throws LexActivatorException {
        int status = LexActivatorNative.DeactivateLicense();
        switch (status) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int GenerateOfflineDeactivationRequest(String filePath) throws LexActivatorException {
        int status = Platform.isWindows() ? LexActivatorNative.GenerateOfflineDeactivationRequest(new WString(filePath)) : LexActivatorNative.GenerateOfflineDeactivationRequest(filePath);
        switch (status) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int IsLicenseGenuine() throws LexActivatorException {
        int status = LexActivatorNative.IsLicenseGenuine();
        switch (status) {
            case 0: {
                return 0;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int IsLicenseValid() throws LexActivatorException {
        int status = LexActivatorNative.IsLicenseValid();
        switch (status) {
            case 0: {
                return 0;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int ActivateTrial() throws LexActivatorException {
        int status = LexActivatorNative.ActivateTrial();
        switch (status) {
            case 0: {
                return 0;
            }
            case 25: {
                return 25;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int ActivateTrialOffline(String filePath) throws LexActivatorException {
        int status = Platform.isWindows() ? LexActivatorNative.ActivateTrialOffline(new WString(filePath)) : LexActivatorNative.ActivateTrialOffline(filePath);
        switch (status) {
            case 0: {
                return 0;
            }
            case 25: {
                return 25;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static void GenerateOfflineTrialActivationRequest(String filePath) throws LexActivatorException {
        int status;
        int n = status = Platform.isWindows() ? LexActivatorNative.GenerateOfflineTrialActivationRequest(new WString(filePath)) : LexActivatorNative.GenerateOfflineTrialActivationRequest(filePath);
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }

    public static int IsTrialGenuine() throws LexActivatorException {
        int status = LexActivatorNative.IsTrialGenuine();
        switch (status) {
            case 0: {
                return 0;
            }
            case 25: {
                return 25;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int ActivateLocalTrial(int trialLength) throws LexActivatorException {
        int status = LexActivatorNative.ActivateLocalTrial(trialLength);
        switch (status) {
            case 0: {
                return 0;
            }
            case 26: {
                return 26;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int IsLocalTrialGenuine() throws LexActivatorException {
        int status = LexActivatorNative.IsLocalTrialGenuine();
        switch (status) {
            case 0: {
                return 0;
            }
            case 26: {
                return 26;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static int ExtendLocalTrial(int trialExtensionLength) throws LexActivatorException {
        int status = LexActivatorNative.ExtendLocalTrial(trialExtensionLength);
        switch (status) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        throw new LexActivatorException(status);
    }

    public static void IncrementActivationMeterAttributeUses(String name, int increment) throws LexActivatorException, UnsupportedEncodingException {
        if (Platform.isWindows()) {
            int status = LexActivatorNative.IncrementActivationMeterAttributeUses(new WString(name), increment);
            if (0 != status) {
                throw new LexActivatorException(status);
            }
        } else {
            int status = LexActivatorNative.IncrementActivationMeterAttributeUses(name, increment);
            if (0 != status) {
                throw new LexActivatorException(status);
            }
        }
    }

    public static void DecrementActivationMeterAttributeUses(String name, int decrement) throws LexActivatorException, UnsupportedEncodingException {
        if (Platform.isWindows()) {
            int status = LexActivatorNative.DecrementActivationMeterAttributeUses(new WString(name), decrement);
            if (0 != status) {
                throw new LexActivatorException(status);
            }
        } else {
            int status = LexActivatorNative.DecrementActivationMeterAttributeUses(name, decrement);
            if (0 != status) {
                throw new LexActivatorException(status);
            }
        }
    }

    public static void ResetActivationMeterAttributeUses(String name) throws LexActivatorException, UnsupportedEncodingException {
        if (Platform.isWindows()) {
            int status = LexActivatorNative.ResetActivationMeterAttributeUses(new WString(name));
            if (0 != status) {
                throw new LexActivatorException(status);
            }
        } else {
            int status = LexActivatorNative.ResetActivationMeterAttributeUses(name);
            if (0 != status) {
                throw new LexActivatorException(status);
            }
        }
    }

    public static void Reset() throws LexActivatorException {
        int status = LexActivatorNative.Reset();
        if (0 != status) {
            throw new LexActivatorException(status);
        }
    }
}

