#version 130
// simple fragment shader
uniform sampler2D imageTex;
uniform sampler2D depthTex;

uniform float doDepth;
uniform float maxRangeOffset_in_meters;
uniform float Z_MIN_in_meters;


out vec4 FragColor;

float getSignedDepth (sampler2D texture, vec2 texCoord){
	ivec2 size = textureSize(texture, 0);
	vec2 depthCoord = texCoord * vec2(size);
	ivec2 idepthCoord = ivec2( floor(depthCoord) ); // integer texel position
	vec4 depthPick = texelFetch(texture, idepthCoord.xy, 0).rgba;
	
	int red   = int(255*depthPick.r);
	int green = int(255*depthPick.g);
	int blue  = int(255*depthPick.b);
	int dMilli = int(red/100)*256*256 + green*256 + blue;
	float signedDepth = float(dMilli)/1000.0 + Z_MIN_in_meters;
	return signedDepth;
}

void main()
{
	vec4 texColor;
	vec4 depthColor = vec4(0, 0, 0, 1.0);
	vec2  tcColor;
	vec2  tcDepth;
	vec4 colorPick;

	tcColor = gl_TexCoord[0].xy;
	tcDepth = gl_TexCoord[1].xy;
	
	colorPick = texture2D(imageTex, tcColor).rgba; // pick color
	float signedDepth = getSignedDepth(depthTex, tcDepth);
	
	float offsetNormalized = clamp(signedDepth/maxRangeOffset_in_meters, -1.0, 1.0);
	float offsetNormalized_between0and1 = 0.5*(offsetNormalized+1.0);

	depthColor.r = 1.0-offsetNormalized_between0and1;
	depthColor.b = offsetNormalized_between0and1;

	FragColor = mix(colorPick, depthColor, doDepth);

//debug
	FragColor = mix(vec4(0.0,0.0,0.0,1.0), FragColor, 0.001);
}