 typedef struct
{
	float valFloat;
	int valInt;
} Particle;


__constant float4 ZERO_F4 = (float4){ 0.0f, 0.0f, 0.0f, 0.0f };
__constant int myIntVal = 80;

__constant float3 myVectorFloat = (float3)(1.0, 2.0, 3.0);
__constant int3 myVectorInt = (int3)(81, 85, 90);
__constant float2 foo[2] = 
{
(float2)(1.0f,0.0f), 
(float2)(0.0f,1.0f)
};


__constant int nbVertices = 4;
__constant float3 polygonPerfect[4] = 
{
(float3)(-1.0f, -1.0f, 0.0f), 
(float3)( 1.0f, -1.0f, 0.0f), 
(float3)( 1.0f,  1.0f, 0.0f), 
(float3)(-1.0f,  1.0f, 0.0f)
};
__constant float3 aretesNormaliseesPerfect[4] = 
{
(float3)( 1.0f,  0.0f, 0.0f), 
(float3)( 0.0f,  1.0f, 0.0f), 
(float3)(-1.0f,  0.0f, 0.0f), 
(float3)( 0.0f, -1.0f, 0.0f)
};
__constant float longueursAretesPerfect[4] = 
{
2.0f, 
2.0f, 
2.0f, 
2.0f
};
__constant float3 O = (float3)(0.0f, 0.0f, 0.0f);
__constant float3 U = (float3)(1.0f, 0.0f, 0.0f);
__constant float3 V = (float3)(0.0f, 1.0f, 0.0f);
__constant float3 N = (float3)(0.0f, 0.0f, 1.0f);
 
__constant float2 BBmin = (float2)(-1.0f, -1.0f);
__constant float2 BBmax = (float2)( 1.0f,  1.0f);

__constant float epsilon = 0.0001f;
__constant float tolerance = 0.0001f;

kernel void belongsToPolygon(__global const float3* listPoints, __global float* results, const int resultRecordSize, const int numPoints) 
{
	// get index into global data array
	int iGID = get_global_id(0);
	int trueR = 1;
	int falseR = 0;

	// bound check (equivalent to the limit on a 'for' loop for standard/serial C code
	if (iGID >= numPoints)  
	{
		return;
	}
	//float3 lePoint = listPoints[iGID].xyz;
	float3 lePoint = listPoints[iGID];

		
	float3 areteNormalisee;
	float3 P1;
	float longueurArete;
	
	float uMin = BBmin.x;
	float vMin = BBmin.y;
	float uMax = BBmax.x;
	float vMax = BBmax.y;

	float3 OP = lePoint-O;

	float scalU = dot(OP, U);
	float scalV = dot(OP, V);
	float scalN = dot(OP, N);

	results[resultRecordSize*iGID + 1] = scalU;
	results[resultRecordSize*iGID + 2] = scalV;
	results[resultRecordSize*iGID + 3] = scalN;

/*
	int k=0;
	results[resultRecordSize*iGID + 4 + k] = O.x; k++;
	results[resultRecordSize*iGID + 4 + k] = O.y; k++;
	results[resultRecordSize*iGID + 4 + k] = O.z; k++;
	results[resultRecordSize*iGID + 4 + k] = U.x; k++;
	results[resultRecordSize*iGID + 4 + k] = U.y; k++;
	results[resultRecordSize*iGID + 4 + k] = U.z; k++;
	results[resultRecordSize*iGID + 4 + k] = V.x; k++;
	results[resultRecordSize*iGID + 4 + k] = V.y; k++;
	results[resultRecordSize*iGID + 4 + k] = V.z; k++;
	results[resultRecordSize*iGID + 4 + k] = N.x; k++;
	results[resultRecordSize*iGID + 4 + k] = N.y; k++;
	results[resultRecordSize*iGID + 4 + k] = N.z; k++;
	results[resultRecordSize*iGID + 4 + k] = uMin; k++;
	results[resultRecordSize*iGID + 4 + k] = vMin; k++;
	results[resultRecordSize*iGID + 4 + k] = uMax; k++;
	results[resultRecordSize*iGID + 4 + k] = vMax; k++;

	int startInd = resultRecordSize*iGID + 4 + 16;

	if ((scalU<uMin)||(scalU>uMax)||(scalV<vMin)||(scalV>vMax)||(fabs(scalN)>tolerance))
	{
		results[resultRecordSize*iGID] = 0;
    }
    else
    {
    	int nbIntersections = 0;
		for (int i=0; i<nbVertices; i++)
		{
			//-----------------------------------------------------------
			//CALCUL POUR UNE ARETE
			//-----------------------------------------------------------
			areteNormalisee = aretesNormaliseesPerfect[i];
			longueurArete = longueursAretesPerfect[i];
			P1 = polygonPerfect[i];
			
			if (longueurArete>epsilon)
			{
				//-----------------------------------------------------------
				//TEST D'INTERSECTION AVEC UN SEGMENT
				//-----------------------------------------------------------
				float scal = dot(U, areteNormalisee);
				results[startInd + 5*i+0] = scal;

				if (fabs(fabs(scal)-1)<epsilon)
				{
				}
				else
				{
					//Cas général
					float3 crossProd = cross(U, areteNormalisee);
					float norm = length(crossProd);
					crossProd /= norm;

					float3 w = cross(U, crossProd);
					float3 PP1 = P1 - lePoint;
					
					float dist = dot(PP1, crossProd);					
					results[startInd + 5*i+1] = dist;
					
					if (fabs(dist)<tolerance)
					{
						float dotWithW = dot(areteNormalisee, w);						
						results[resultRecordSize*iGID + 4 + 5*i+2] = dotWithW;
						
						float lambda = -dot(PP1, w)/dotWithW;
						results[startInd + 5*i+3] = lambda;
						
						if ((lambda>=0.0)&&(lambda<=longueurArete)) 
						{
							float dotWithU = dot(areteNormalisee, U);
							float mu = dot(PP1, U) + lambda*dotWithU;
							results[startInd + 5*i+4] = mu;
							
							if (mu>=0.0)
							{
								nbIntersections = nbIntersections+1;
							}						
						}
					}
				}
			}
		}
			
		//-----------------------------------------------------------
		//LE POINT APPARTIENT AU POLYGONE SI LE NOMBRE D'INTERSECTIONS EST IMPAIR
		//-----------------------------------------------------------
		if (nbIntersections%2 != 0)
		{
			results[resultRecordSize*iGID] = 1;
		}
		else
		{
			//results[iGID] = 0;
		}
		
		//results[iGID] = (int)((nbIntersections % 2!=0));
    }
    */
    results[iGID] = 0;
    }
}


 kernel void testFunction(	__global const float3* listPoints, __global float* results, __global int* polygonInnerFields, const int resultRecordSize, const int numPoints, 
    						__global const float3* polygonPerfect, const int nbVertices, 
    						__global const float* longueursAretesPerfect, __global const float3* aretesNormaliseesPerfect,
    						const float ox, const float oy, const float oz,
    						const float ux, const float uy, const float uz,
    						const float vx, const float vy, const float vz,
     						const float nx, const float ny, const float nz,
     						const float umin, const float vmin, 
     						const float umax, const float vmax
    						) 
{
        // get index into global data array
        int iGID = get_global_id(0);
        int trueR = 1;
        int falseR = 0;

        // bound check (equivalent to the limit on a 'for' loop for standard/serial C code
        if (iGID >= numPoints)  
        {
            return;
        }

		//float3 lePoint = listPoints[iGID].xyz;
		float3 lePoint = listPoints[iGID];

		const float epsilon = 0.0001f;
		const float tolerance = 0.0001f;
		
		float3 areteNormalisee;
		float3 P1;
		float longueurArete;

		/*
		float3 O = polygonInnerFields[0];
		float3 U = polygonInnerFields[1];
		float3 V = polygonInnerFields[2];
		float3 N = polygonInnerFields[3];
		float3 BBmin = polygonInnerFields[4];
		float3 BBmax = polygonInnerFields[5];
		
		float uMin = BBmin.x;
		float vMin = BBmin.y;
		float uMax = BBmax.x;
		float vMax = BBmax.y;
		*/
		
		float3 O = (float3)(ox, oy, oz);
		float3 U = (float3)(ux, uy, uz);
		float3 V = (float3)(vx, vy, vz);
		float3 N = (float3)(nx, ny, nz);
		float3 BBmin = (float3)(umin, vmin, 0);
		float3 BBmax = (float3)(umax, vmax, 0);
		
		float uMin = BBmin.x;
		float vMin = BBmin.y;
		float uMax = BBmax.x;
		float vMax = BBmax.y;
		

		float3 OP = lePoint-O;
		//float3 OP = (float3)(lePoint.x - O.x, lePoint.y - O.y, lePoint.z - O.z);

/*
		float scalU = dot(OP, U);
		float scalV = dot(OP, V);
		float scalN = dot(OP, N);
*/
		float scalU = OP.x*U.x+OP.y*U.y+OP.z*U.z;
		float scalV = OP.x*V.x+OP.y*V.y+OP.z*V.z;
		float scalN = OP.x*N.x+OP.y*N.y+OP.z*N.z;
		
		/*
		results[resultRecordSize*iGID + 1] = scalU;
		results[resultRecordSize*iGID + 2] = scalV;
		results[resultRecordSize*iGID + 3] = scalN;
		*/
		
		results[resultRecordSize*iGID + 1] = ux;
		results[resultRecordSize*iGID + 2] = (float)polygonInnerFields[4];
		results[resultRecordSize*iGID + 3] = uz;
		
		
		int k=0;
		results[resultRecordSize*iGID + 4 + k] = O.x; k++;
		results[resultRecordSize*iGID + 4 + k] = O.y; k++;
		results[resultRecordSize*iGID + 4 + k] = O.z; k++;
		results[resultRecordSize*iGID + 4 + k] = U.x; k++;
		results[resultRecordSize*iGID + 4 + k] = U.y; k++;
		results[resultRecordSize*iGID + 4 + k] = U.z; k++;
		results[resultRecordSize*iGID + 4 + k] = V.x; k++;
		results[resultRecordSize*iGID + 4 + k] = V.y; k++;
		results[resultRecordSize*iGID + 4 + k] = V.z; k++;
		results[resultRecordSize*iGID + 4 + k] = N.x; k++;
		results[resultRecordSize*iGID + 4 + k] = N.y; k++;
		results[resultRecordSize*iGID + 4 + k] = N.z; k++;
		results[resultRecordSize*iGID + 4 + k] = uMin; k++;
		results[resultRecordSize*iGID + 4 + k] = vMin; k++;
		results[resultRecordSize*iGID + 4 + k] = uMax; k++;
		results[resultRecordSize*iGID + 4 + k] = vMax; k++;

		int startInd = resultRecordSize*iGID + 4 + 16;
		
		
		

		if ((scalU<uMin)||(scalU>uMax)||(scalV<vMin)||(scalV>vMax))
		//if ((scalU<uMin)||(scalU>uMax)||(scalV<vMin)||(scalV>vMax)||(fabs(scalN)>tolerance))
		{
			results[resultRecordSize*iGID] = 0;
        }
        else
        {
        	int nbIntersections = 0;
		
			for (int i=0; i<nbVertices; i++)
			{
				//-----------------------------------------------------------
				//CALCUL POUR UNE ARETE
				//-----------------------------------------------------------
				areteNormalisee = aretesNormaliseesPerfect[i];
				longueurArete = longueursAretesPerfect[i];
				P1 = polygonPerfect[i];
				
				if (longueurArete>epsilon)
				{
					//-----------------------------------------------------------
					//TEST D'INTERSECTION AVEC UN SEGMENT
					//-----------------------------------------------------------
					//float scal = dot(U, areteNormalisee);
					float scal = U.x*areteNormalisee.x+U.y*areteNormalisee.y+U.z*areteNormalisee.z;
	
					results[startInd + 5*i+0] = scal;
					
					
					
					if (fabs(fabs(scal)-1)<epsilon)
					{
					}
					else
					{
						//Cas général
						float3 crossProd = cross(U, areteNormalisee);
						float norm = length(crossProd);
						crossProd /= norm;
	
						float3 w = cross(U, crossProd);
						float3 PP1 = P1 - lePoint;
						//float dist = dot(PP1, crossProd);
						float dist = PP1.x*crossProd.x+PP1.y*crossProd.y+PP1.z*crossProd.z;
						
						results[startInd + 5*i+1] = dist;
						
						if (fabs(dist)<tolerance)
						{
							//float dotWithW = dot(areteNormalisee, w);
							float dotWithW = areteNormalisee.x*w.x+areteNormalisee.y*w.y+areteNormalisee.z*w.z;
							
							results[resultRecordSize*iGID + 4 + 5*i+2] = dotWithW;
							
							//float lambda = -dot(PP1, w)/dotWithW;
							float lambda = -(PP1.x*w.x+PP1.y*w.y+PP1.z*w.z)/dotWithW;
							
							results[startInd + 5*i+3] = lambda;
							
							if ((lambda>=0.0)&&(lambda<=longueurArete)) 
							{
								//float dotWithU = dot(areteNormalisee, U);
								float dotWithU = areteNormalisee.x*U.x+areteNormalisee.y*U.y+areteNormalisee.z*U.z;

								//float mu = dot(PP1, U) + lambda*dotWithU;
								float mu = (PP1.x*U.x+PP1.y*U.y+PP1.z*U.z) + lambda*dotWithU;
								
								results[startInd + 5*i+4] = mu;
								
								if (mu>=0.0)
								{
									nbIntersections = nbIntersections+1;
								}						
							}
						}
					}
				}
			}
				
			//-----------------------------------------------------------
			//LE POINT APPARTIENT AU POLYGONE SI LE NOMBRE D'INTERSECTIONS EST IMPAIR
			//-----------------------------------------------------------
			if (nbIntersections%2 != 0)
			{
				results[resultRecordSize*iGID] = 1;
			}
			else
			{
				//results[iGID] = 0;
			}
			
			//results[iGID] = (int)((nbIntersections % 2!=0));
        }
}

kernel void testReadFloat(	global const float3* listPoints, global float* results, const int numPoints, 
 							const int resultRecordSize, global const float* tabFloat) 
{
        // get index into global data array
        int iGID = get_global_id(0);
        int trueR = 1;
        int falseR = 0;

        // bound check (equivalent to the limit on a 'for' loop for standard/serial C code
        if (iGID >= numPoints)  
        {
            return;
        }

		float3 lePoint = listPoints[iGID];

		float x = tabFloat[0];
		float y = tabFloat[1];
		float z = tabFloat[2];
		
		results[resultRecordSize*iGID + 0] = x;
		results[resultRecordSize*iGID + 1] = y;
		results[resultRecordSize*iGID + 2] = z;
}
kernel void testReadInt(	global const float3* listPoints, global int* results, const int numPoints, 
 							global const int* tabInt, int anIntValue, global int3* anIntVector) 
{
        // get index into global data array
        int iGID = get_global_id(0);
        int trueR = 1;
        int falseR = 0;

        // bound check (equivalent to the limit on a 'for' loop for standard/serial C code
        if (iGID >= numPoints)  
        {
            return;
        }

		float3 lePoint = listPoints[iGID];

		int x = tabInt[0];
		int y = tabInt[1];
		int z = tabInt[2];

		int resultVal = 0;
		if (x==100) resultVal = 100;
		
		results[iGID] = (int)foo[0].x;
}
 
