/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.OrientingDockStation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OrientingDockStationEvent {
    private final OrientingDockStation station;
    private final Set<Dockable> children = new HashSet<Dockable>();

    public OrientingDockStationEvent(OrientingDockStation orientingDockStation) {
        this(orientingDockStation, null);
    }

    public OrientingDockStationEvent(OrientingDockStation orientingDockStation, Dockable[] dockableArray) {
        this.station = orientingDockStation;
        if (dockableArray == null) {
            int n = orientingDockStation.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.children.add(orientingDockStation.getDockable(i));
            }
        } else {
            for (Dockable dockable : dockableArray) {
                this.children.add(dockable);
            }
        }
    }

    public OrientingDockStation getStation() {
        return this.station;
    }

    public boolean isAffected(Dockable dockable) {
        return this.children.contains(dockable);
    }

    public Collection<Dockable> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }
}

