/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.toolbar.layout.GridPlaceholderList;
import bibliothek.gui.dock.station.toolbar.layout.ModeledPlaceholderToolbarGrid;
import bibliothek.gui.dock.station.toolbar.layout.PerspectiveGridPlaceholderList;
import bibliothek.util.Path;
import java.util.HashSet;
import java.util.Set;

public class PerspectivePlaceholderToolbarGrid
extends ModeledPlaceholderToolbarGrid<PerspectiveDockable, PerspectiveStation, PerspectiveDockable> {
    public PerspectivePlaceholderToolbarGrid() {
        this.init();
    }

    @Override
    protected PlaceholderList<PerspectiveDockable, PerspectiveStation, PerspectiveDockable> createColumn() {
        return new PerspectivePlaceholderList<PerspectiveDockable>();
    }

    @Override
    protected GridPlaceholderList<PerspectiveDockable, PerspectiveStation, PerspectiveDockable> createGrid() {
        return new PerspectiveGridPlaceholderList();
    }

    @Override
    protected Set<Path> getPlaceholders(PerspectiveDockable perspectiveDockable) {
        HashSet<Path> hashSet = new HashSet<Path>();
        this.fill(hashSet, perspectiveDockable);
        return hashSet;
    }

    private void fill(Set<Path> set, PerspectiveDockable perspectiveDockable) {
        PerspectiveStation perspectiveStation;
        Path path = perspectiveDockable.getPlaceholder();
        if (path != null) {
            set.add(path);
        }
        if ((perspectiveStation = perspectiveDockable.asStation()) != null) {
            int n = perspectiveStation.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.fill(set, perspectiveStation.getDockable(i));
            }
        }
    }

    public void replace(PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        int n = this.getColumn(perspectiveDockable);
        if (n == -1) {
            throw new IllegalArgumentException("oldDockable is not known to this grid");
        }
        PlaceholderList placeholderList = this.getColumn(n);
        int n2 = placeholderList.dockables().indexOf(perspectiveDockable);
        placeholderList.remove(n2);
        placeholderList.dockables().add(n2, perspectiveDockable2);
    }

    @Override
    protected void fill(PerspectiveDockable perspectiveDockable, ConvertedPlaceholderListItem convertedPlaceholderListItem) {
        PerspectiveStation perspectiveStation;
        Path path = perspectiveDockable.getPlaceholder();
        if (path != null) {
            convertedPlaceholderListItem.putString("placeholder", path.toString());
            convertedPlaceholderListItem.setPlaceholder(path);
        }
        if ((perspectiveStation = perspectiveDockable.asStation()) != null) {
            convertedPlaceholderListItem.setPlaceholderMap(perspectiveStation.getPlaceholders());
        }
    }
}

