/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.ToolbarDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarDockPerspective;
import bibliothek.gui.dock.station.toolbar.ToolbarDockStationLayout;
import bibliothek.gui.dock.station.toolbar.ToolbarProperty;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class ToolbarDockStationFactory
implements DockFactory<ToolbarDockStation, ToolbarDockPerspective, ToolbarDockStationLayout> {
    public static final String ID = "ToolbarDockStationFactory";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public ToolbarDockStationLayout getLayout(ToolbarDockStation toolbarDockStation, Map<Dockable, Integer> map) {
        PlaceholderMap placeholderMap = toolbarDockStation.getPlaceholders(map);
        return new ToolbarDockStationLayout(placeholderMap, toolbarDockStation.getExpandedState());
    }

    @Override
    public ToolbarDockStationLayout getPerspectiveLayout(ToolbarDockPerspective toolbarDockPerspective, Map<PerspectiveDockable, Integer> map) {
        PlaceholderMap placeholderMap = toolbarDockPerspective.getPlaceholders(map);
        return new ToolbarDockStationLayout(placeholderMap, toolbarDockPerspective.getExpandedState());
    }

    @Override
    public void setLayout(ToolbarDockStation toolbarDockStation, ToolbarDockStationLayout toolbarDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        toolbarDockStation.setExpandedState(toolbarDockStationLayout.getState(), false);
        toolbarDockStation.setPlaceholders(toolbarDockStationLayout.getPlaceholders(), map);
    }

    @Override
    public void setLayout(ToolbarDockStation toolbarDockStation, ToolbarDockStationLayout toolbarDockStationLayout, PlaceholderStrategy placeholderStrategy) {
        toolbarDockStation.setExpandedState(toolbarDockStationLayout.getState(), false);
    }

    @Override
    public void write(ToolbarDockStationLayout toolbarDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_1_1);
        toolbarDockStationLayout.getPlaceholders().write(dataOutputStream);
        dataOutputStream.writeUTF(toolbarDockStationLayout.getState().name());
    }

    @Override
    public void write(ToolbarDockStationLayout toolbarDockStationLayout, XElement xElement) {
        XElement xElement2 = xElement.addElement("placeholders");
        toolbarDockStationLayout.getPlaceholders().write(xElement2);
        xElement.addElement("expanded").setString(toolbarDockStationLayout.getState().name());
    }

    @Override
    public ToolbarDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        PlaceholderMap placeholderMap = new PlaceholderMap(dataInputStream, placeholderStrategy);
        placeholderMap.setPlaceholderStrategy(null);
        ExpandedState expandedState = ExpandedState.valueOf(dataInputStream.readUTF());
        return new ToolbarDockStationLayout(placeholderMap, expandedState);
    }

    @Override
    public ToolbarDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        XElement xElement2 = xElement.getElement("placeholders");
        XElement xElement3 = xElement.getElement("expanded");
        PlaceholderMap placeholderMap = new PlaceholderMap(xElement2, placeholderStrategy);
        placeholderMap.setPlaceholderStrategy(null);
        ExpandedState expandedState = ExpandedState.SHRUNK;
        if (xElement3 != null) {
            expandedState = ExpandedState.valueOf(xElement3.getString());
        }
        return new ToolbarDockStationLayout(placeholderMap, expandedState);
    }

    @Override
    public void estimateLocations(ToolbarDockStationLayout toolbarDockStationLayout, final LocationEstimationMap locationEstimationMap) {
        DockablePlaceholderList.simulatedRead(toolbarDockStationLayout.getPlaceholders(), new PlaceholderListItemAdapter<Dockable, Dockable>(){

            @Override
            public Dockable convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                int n = convertedPlaceholderListItem.getInt("id");
                int n2 = convertedPlaceholderListItem.getInt("index");
                Path path = null;
                if (convertedPlaceholderListItem.contains("placeholder")) {
                    path = new Path(convertedPlaceholderListItem.getString("placeholder"));
                }
                locationEstimationMap.setLocation(n, new ToolbarProperty(n2, path));
                int n3 = locationEstimationMap.getSubChildCount(n);
                for (int i = 0; i < n3; ++i) {
                    DockLayoutInfo dockLayoutInfo = locationEstimationMap.getSubChild(n, i);
                    dockLayoutInfo.setLocation(new ToolbarProperty(n2, dockLayoutInfo.getPlaceholder()));
                }
                return null;
            }
        });
    }

    @Override
    public ToolbarDockStation layout(ToolbarDockStationLayout toolbarDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        ToolbarDockStation toolbarDockStation = this.createStation();
        this.setLayout(toolbarDockStation, toolbarDockStationLayout, map, placeholderStrategy);
        return toolbarDockStation;
    }

    @Override
    public ToolbarDockStation layout(ToolbarDockStationLayout toolbarDockStationLayout, PlaceholderStrategy placeholderStrategy) {
        ToolbarDockStation toolbarDockStation = this.createStation();
        this.setLayout(toolbarDockStation, toolbarDockStationLayout, placeholderStrategy);
        return toolbarDockStation;
    }

    @Override
    public ToolbarDockPerspective layoutPerspective(ToolbarDockStationLayout toolbarDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        return new ToolbarDockPerspective(toolbarDockStationLayout, map);
    }

    @Override
    public void layoutPerspective(ToolbarDockPerspective toolbarDockPerspective, ToolbarDockStationLayout toolbarDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        toolbarDockPerspective.read(toolbarDockStationLayout, map);
    }

    protected ToolbarDockStation createStation() {
        return new ToolbarDockStation();
    }
}

