/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BoundingPolytope;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CachedFrustum;
import org.jogamp.java3d.J3dHash;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point4d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector4d;

public class BoundingBox
extends Bounds {
    final Point3d lower;
    final Point3d upper;
    private static final double EPS = 1.0E-8;

    public BoundingBox(Point3d lower, Point3d upper) {
        this.boundId = 1;
        this.lower = new Point3d(lower);
        this.upper = new Point3d(upper);
        this.updateBoundsStates();
    }

    public BoundingBox() {
        this.boundId = 1;
        this.lower = new Point3d(-1.0, -1.0, -1.0);
        this.upper = new Point3d(1.0, 1.0, 1.0);
        this.boundsIsEmpty = false;
        this.boundsIsInfinite = false;
    }

    public BoundingBox(Bounds boundsObject) {
        this.boundId = 1;
        this.lower = new Point3d();
        this.upper = new Point3d();
        if (boundsObject == null || boundsObject.boundsIsEmpty) {
            this.setEmptyBounds();
            return;
        }
        if (boundsObject.boundsIsInfinite) {
            this.setInfiniteBounds();
            return;
        }
        if (boundsObject.boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObject;
            this.lower.set((Tuple3d)box.lower);
            this.upper.set((Tuple3d)box.upper);
        } else if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            this.lower.set(sphere.center.x - sphere.radius, sphere.center.y - sphere.radius, sphere.center.z - sphere.radius);
            this.upper.set(sphere.center.x + sphere.radius, sphere.center.y + sphere.radius, sphere.center.z + sphere.radius);
        } else if (boundsObject.boundId == 4) {
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            if (polytope.nVerts < 1) {
                this.lower.set(-1.0, -1.0, -1.0);
                this.upper.set(1.0, 1.0, 1.0);
            } else {
                this.lower.set((Tuple3d)polytope.verts[0]);
                this.upper.set((Tuple3d)polytope.verts[0]);
                for (int i = 1; i < polytope.nVerts; ++i) {
                    if (polytope.verts[i].x < this.lower.x) {
                        this.lower.x = polytope.verts[i].x;
                    }
                    if (polytope.verts[i].y < this.lower.y) {
                        this.lower.y = polytope.verts[i].y;
                    }
                    if (polytope.verts[i].z < this.lower.z) {
                        this.lower.z = polytope.verts[i].z;
                    }
                    if (polytope.verts[i].x > this.upper.x) {
                        this.upper.x = polytope.verts[i].x;
                    }
                    if (polytope.verts[i].y > this.upper.y) {
                        this.upper.y = polytope.verts[i].y;
                    }
                    if (!(polytope.verts[i].z > this.upper.z)) continue;
                    this.upper.z = polytope.verts[i].z;
                }
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox0"));
        }
        this.updateBoundsStates();
    }

    public BoundingBox(Bounds[] bounds) {
        int i;
        this.boundId = 1;
        this.upper = new Point3d();
        this.lower = new Point3d();
        if (bounds == null || bounds.length <= 0) {
            this.setEmptyBounds();
            return;
        }
        for (i = 0; i < bounds.length && (bounds[i] == null || bounds[i].boundsIsEmpty); ++i) {
        }
        if (i >= bounds.length) {
            this.setEmptyBounds();
            return;
        }
        this.set(bounds[i++]);
        if (this.boundsIsInfinite) {
            return;
        }
        while (i < bounds.length) {
            if (bounds[i] != null && !bounds[i].boundsIsEmpty) {
                if (bounds[i].boundsIsInfinite) {
                    this.setInfiniteBounds();
                    return;
                }
                if (bounds[i].boundId == 1) {
                    BoundingBox box = (BoundingBox)bounds[i];
                    if (this.lower.x > box.lower.x) {
                        this.lower.x = box.lower.x;
                    }
                    if (this.lower.y > box.lower.y) {
                        this.lower.y = box.lower.y;
                    }
                    if (this.lower.z > box.lower.z) {
                        this.lower.z = box.lower.z;
                    }
                    if (this.upper.x < box.upper.x) {
                        this.upper.x = box.upper.x;
                    }
                    if (this.upper.y < box.upper.y) {
                        this.upper.y = box.upper.y;
                    }
                    if (this.upper.z < box.upper.z) {
                        this.upper.z = box.upper.z;
                    }
                } else if (bounds[i].boundId == 2) {
                    BoundingSphere sphere = (BoundingSphere)bounds[i];
                    if (this.lower.x > sphere.center.x - sphere.radius) {
                        this.lower.x = sphere.center.x - sphere.radius;
                    }
                    if (this.lower.y > sphere.center.y - sphere.radius) {
                        this.lower.y = sphere.center.y - sphere.radius;
                    }
                    if (this.lower.z > sphere.center.z - sphere.radius) {
                        this.lower.z = sphere.center.z - sphere.radius;
                    }
                    if (this.upper.x < sphere.center.x + sphere.radius) {
                        this.upper.x = sphere.center.x + sphere.radius;
                    }
                    if (this.upper.y < sphere.center.y + sphere.radius) {
                        this.upper.y = sphere.center.y + sphere.radius;
                    }
                    if (this.upper.z < sphere.center.z + sphere.radius) {
                        this.upper.z = sphere.center.z + sphere.radius;
                    }
                } else if (bounds[i].boundId == 4) {
                    BoundingPolytope polytope = (BoundingPolytope)bounds[i];
                    for (i = 0; i < polytope.nVerts; ++i) {
                        if (polytope.verts[i].x < this.lower.x) {
                            this.lower.x = polytope.verts[i].x;
                        }
                        if (polytope.verts[i].y < this.lower.y) {
                            this.lower.y = polytope.verts[i].y;
                        }
                        if (polytope.verts[i].z < this.lower.z) {
                            this.lower.z = polytope.verts[i].z;
                        }
                        if (polytope.verts[i].x > this.upper.x) {
                            this.upper.x = polytope.verts[i].x;
                        }
                        if (polytope.verts[i].y > this.upper.y) {
                            this.upper.y = polytope.verts[i].y;
                        }
                        if (!(polytope.verts[i].z > this.upper.z)) continue;
                        this.upper.z = polytope.verts[i].z;
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingBox1"));
                }
            }
            ++i;
        }
        this.updateBoundsStates();
    }

    public void getLower(Point3d p1) {
        p1.set((Tuple3d)this.lower);
    }

    public void setLower(double xmin, double ymin, double zmin) {
        this.lower.set(xmin, ymin, zmin);
        this.updateBoundsStates();
    }

    public void setLower(Point3d p1) {
        this.lower.set((Tuple3d)p1);
        this.updateBoundsStates();
    }

    public void getUpper(Point3d p1) {
        p1.set((Tuple3d)this.upper);
    }

    public void setUpper(double xmax, double ymax, double zmax) {
        this.upper.set(xmax, ymax, zmax);
        this.updateBoundsStates();
    }

    public void setUpper(Point3d p1) {
        this.upper.set((Tuple3d)p1);
        this.updateBoundsStates();
    }

    @Override
    public void set(Bounds boundsObject) {
        if (boundsObject == null || boundsObject.boundsIsEmpty) {
            this.setEmptyBounds();
            return;
        }
        if (boundsObject.boundsIsInfinite) {
            this.setInfiniteBounds();
            return;
        }
        if (boundsObject.boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObject;
            this.lower.x = box.lower.x;
            this.lower.y = box.lower.y;
            this.lower.z = box.lower.z;
            this.upper.x = box.upper.x;
            this.upper.y = box.upper.y;
            this.upper.z = box.upper.z;
        } else if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            this.lower.x = sphere.center.x - sphere.radius;
            this.lower.y = sphere.center.y - sphere.radius;
            this.lower.z = sphere.center.z - sphere.radius;
            this.upper.x = sphere.center.x + sphere.radius;
            this.upper.y = sphere.center.y + sphere.radius;
            this.upper.z = sphere.center.z + sphere.radius;
        } else if (boundsObject.boundId == 4) {
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            this.lower.x = this.upper.x = polytope.verts[0].x;
            this.lower.y = this.upper.y = polytope.verts[0].y;
            this.lower.z = this.upper.z = polytope.verts[0].z;
            for (int i = 1; i < polytope.nVerts; ++i) {
                if (polytope.verts[i].x < this.lower.x) {
                    this.lower.x = polytope.verts[i].x;
                }
                if (polytope.verts[i].y < this.lower.y) {
                    this.lower.y = polytope.verts[i].y;
                }
                if (polytope.verts[i].z < this.lower.z) {
                    this.lower.z = polytope.verts[i].z;
                }
                if (polytope.verts[i].x > this.upper.x) {
                    this.upper.x = polytope.verts[i].x;
                }
                if (polytope.verts[i].y > this.upper.y) {
                    this.upper.y = polytope.verts[i].y;
                }
                if (!(polytope.verts[i].z > this.upper.z)) continue;
                this.upper.z = polytope.verts[i].z;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox0"));
        }
        this.updateBoundsStates();
    }

    @Override
    public Object clone() {
        return new BoundingBox(this.lower, this.upper);
    }

    @Override
    public boolean equals(Object bounds) {
        try {
            BoundingBox box = (BoundingBox)bounds;
            return this.lower.equals((Tuple3d)box.lower) && this.upper.equals((Tuple3d)box.upper);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        long bits = 1L;
        bits = J3dHash.mixDoubleBits(bits, this.lower.x);
        bits = J3dHash.mixDoubleBits(bits, this.lower.y);
        bits = J3dHash.mixDoubleBits(bits, this.lower.z);
        bits = J3dHash.mixDoubleBits(bits, this.upper.x);
        bits = J3dHash.mixDoubleBits(bits, this.upper.y);
        bits = J3dHash.mixDoubleBits(bits, this.upper.z);
        return J3dHash.finish(bits);
    }

    @Override
    public void combine(Bounds boundsObject) {
        if (boundsObject == null || boundsObject.boundsIsEmpty || this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty || boundsObject.boundsIsInfinite) {
            this.set(boundsObject);
            return;
        }
        if (boundsObject.boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObject;
            if (this.lower.x > box.lower.x) {
                this.lower.x = box.lower.x;
            }
            if (this.lower.y > box.lower.y) {
                this.lower.y = box.lower.y;
            }
            if (this.lower.z > box.lower.z) {
                this.lower.z = box.lower.z;
            }
            if (this.upper.x < box.upper.x) {
                this.upper.x = box.upper.x;
            }
            if (this.upper.y < box.upper.y) {
                this.upper.y = box.upper.y;
            }
            if (this.upper.z < box.upper.z) {
                this.upper.z = box.upper.z;
            }
        } else if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            if (this.lower.x > sphere.center.x - sphere.radius) {
                this.lower.x = sphere.center.x - sphere.radius;
            }
            if (this.lower.y > sphere.center.y - sphere.radius) {
                this.lower.y = sphere.center.y - sphere.radius;
            }
            if (this.lower.z > sphere.center.z - sphere.radius) {
                this.lower.z = sphere.center.z - sphere.radius;
            }
            if (this.upper.x < sphere.center.x + sphere.radius) {
                this.upper.x = sphere.center.x + sphere.radius;
            }
            if (this.upper.y < sphere.center.y + sphere.radius) {
                this.upper.y = sphere.center.y + sphere.radius;
            }
            if (this.upper.z < sphere.center.z + sphere.radius) {
                this.upper.z = sphere.center.z + sphere.radius;
            }
        } else if (boundsObject.boundId == 4) {
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            for (int i = 1; i < polytope.nVerts; ++i) {
                if (polytope.verts[i].x < this.lower.x) {
                    this.lower.x = polytope.verts[i].x;
                }
                if (polytope.verts[i].y < this.lower.y) {
                    this.lower.y = polytope.verts[i].y;
                }
                if (polytope.verts[i].z < this.lower.z) {
                    this.lower.z = polytope.verts[i].z;
                }
                if (polytope.verts[i].x > this.upper.x) {
                    this.upper.x = polytope.verts[i].x;
                }
                if (polytope.verts[i].y > this.upper.y) {
                    this.upper.y = polytope.verts[i].y;
                }
                if (!(polytope.verts[i].z > this.upper.z)) continue;
                this.upper.z = polytope.verts[i].z;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox3"));
        }
        this.updateBoundsStates();
    }

    @Override
    public void combine(Bounds[] bounds) {
        int i;
        if (bounds == null || bounds.length <= 0 || this.boundsIsInfinite) {
            return;
        }
        for (i = 0; i < bounds.length && (bounds[i] == null || bounds[i].boundsIsEmpty); ++i) {
        }
        if (i >= bounds.length) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(bounds[i++]);
        }
        if (this.boundsIsInfinite) {
            return;
        }
        while (i < bounds.length) {
            if (bounds[i] != null && !bounds[i].boundsIsEmpty) {
                if (bounds[i].boundsIsInfinite) {
                    this.lower.z = Double.NEGATIVE_INFINITY;
                    this.lower.y = Double.NEGATIVE_INFINITY;
                    this.lower.x = Double.NEGATIVE_INFINITY;
                    this.upper.z = Double.POSITIVE_INFINITY;
                    this.upper.y = Double.POSITIVE_INFINITY;
                    this.upper.x = Double.POSITIVE_INFINITY;
                    break;
                }
                if (bounds[i].boundId == 1) {
                    BoundingBox box = (BoundingBox)bounds[i];
                    if (this.lower.x > box.lower.x) {
                        this.lower.x = box.lower.x;
                    }
                    if (this.lower.y > box.lower.y) {
                        this.lower.y = box.lower.y;
                    }
                    if (this.lower.z > box.lower.z) {
                        this.lower.z = box.lower.z;
                    }
                    if (this.upper.x < box.upper.x) {
                        this.upper.x = box.upper.x;
                    }
                    if (this.upper.y < box.upper.y) {
                        this.upper.y = box.upper.y;
                    }
                    if (this.upper.z < box.upper.z) {
                        this.upper.z = box.upper.z;
                    }
                } else if (bounds[i].boundId == 2) {
                    BoundingSphere sphere = (BoundingSphere)bounds[i];
                    if (this.lower.x > sphere.center.x - sphere.radius) {
                        this.lower.x = sphere.center.x - sphere.radius;
                    }
                    if (this.lower.y > sphere.center.y - sphere.radius) {
                        this.lower.y = sphere.center.y - sphere.radius;
                    }
                    if (this.lower.z > sphere.center.z - sphere.radius) {
                        this.lower.z = sphere.center.z - sphere.radius;
                    }
                    if (this.upper.x < sphere.center.x + sphere.radius) {
                        this.upper.x = sphere.center.x + sphere.radius;
                    }
                    if (this.upper.y < sphere.center.y + sphere.radius) {
                        this.upper.y = sphere.center.y + sphere.radius;
                    }
                    if (this.upper.z < sphere.center.z + sphere.radius) {
                        this.upper.z = sphere.center.z + sphere.radius;
                    }
                } else if (bounds[i].boundId == 4) {
                    BoundingPolytope polytope = (BoundingPolytope)bounds[i];
                    for (i = 1; i < polytope.nVerts; ++i) {
                        if (polytope.verts[i].x < this.lower.x) {
                            this.lower.x = polytope.verts[i].x;
                        }
                        if (polytope.verts[i].y < this.lower.y) {
                            this.lower.y = polytope.verts[i].y;
                        }
                        if (polytope.verts[i].z < this.lower.z) {
                            this.lower.z = polytope.verts[i].z;
                        }
                        if (polytope.verts[i].x > this.upper.x) {
                            this.upper.x = polytope.verts[i].x;
                        }
                        if (polytope.verts[i].y > this.upper.y) {
                            this.upper.y = polytope.verts[i].y;
                        }
                        if (!(polytope.verts[i].z > this.upper.z)) continue;
                        this.upper.z = polytope.verts[i].z;
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingBox4"));
                }
            }
            ++i;
        }
        this.updateBoundsStates();
    }

    @Override
    public void combine(Point3d point) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.upper.x = this.lower.x = point.x;
            this.upper.y = this.lower.y = point.y;
            this.upper.z = this.lower.z = point.z;
        } else {
            if (point.x > this.upper.x) {
                this.upper.x = point.x;
            }
            if (point.y > this.upper.y) {
                this.upper.y = point.y;
            }
            if (point.z > this.upper.z) {
                this.upper.z = point.z;
            }
            if (point.x < this.lower.x) {
                this.lower.x = point.x;
            }
            if (point.y < this.lower.y) {
                this.lower.y = point.y;
            }
            if (point.z < this.lower.z) {
                this.lower.z = point.z;
            }
        }
        this.updateBoundsStates();
    }

    @Override
    public void combine(Point3d[] points) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.setUpper(points[0]);
            this.setLower(points[0]);
        }
        for (int i = 0; i < points.length; ++i) {
            if (points[i].x > this.upper.x) {
                this.upper.x = points[i].x;
            }
            if (points[i].y > this.upper.y) {
                this.upper.y = points[i].y;
            }
            if (points[i].z > this.upper.z) {
                this.upper.z = points[i].z;
            }
            if (points[i].x < this.lower.x) {
                this.lower.x = points[i].x;
            }
            if (points[i].y < this.lower.y) {
                this.lower.y = points[i].y;
            }
            if (!(points[i].z < this.lower.z)) continue;
            this.lower.z = points[i].z;
        }
        this.updateBoundsStates();
    }

    @Override
    public void transform(Bounds boundsObject, Transform3D matrix) {
        if (boundsObject == null || boundsObject.boundsIsEmpty) {
            this.setEmptyBounds();
            return;
        }
        if (boundsObject.boundsIsInfinite) {
            this.setInfiniteBounds();
            return;
        }
        if (boundsObject.boundId == 1) {
            this.set(boundsObject);
            this.transform(matrix);
        } else if (boundsObject.boundId == 2) {
            BoundingSphere tmpSphere = new BoundingSphere(boundsObject);
            tmpSphere.transform(matrix);
            this.set(tmpSphere);
        } else if (boundsObject.boundId == 4) {
            BoundingPolytope tmpPolytope = new BoundingPolytope(boundsObject);
            tmpPolytope.transform(matrix);
            this.set(tmpPolytope);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox5"));
        }
    }

    @Override
    public void transform(Transform3D matrix) {
        if (this.boundsIsInfinite) {
            return;
        }
        Point3d tmpP3d = new Point3d();
        double ux = this.upper.x;
        double uy = this.upper.y;
        double uz = this.upper.z;
        double lx = this.lower.x;
        double ly = this.lower.y;
        double lz = this.lower.z;
        tmpP3d.set(ux, uy, uz);
        matrix.transform(tmpP3d);
        this.upper.x = tmpP3d.x;
        this.upper.y = tmpP3d.y;
        this.upper.z = tmpP3d.z;
        this.lower.x = tmpP3d.x;
        this.lower.y = tmpP3d.y;
        this.lower.z = tmpP3d.z;
        tmpP3d.set(lx, uy, uz);
        matrix.transform(tmpP3d);
        if (tmpP3d.x > this.upper.x) {
            this.upper.x = tmpP3d.x;
        }
        if (tmpP3d.y > this.upper.y) {
            this.upper.y = tmpP3d.y;
        }
        if (tmpP3d.z > this.upper.z) {
            this.upper.z = tmpP3d.z;
        }
        if (tmpP3d.x < this.lower.x) {
            this.lower.x = tmpP3d.x;
        }
        if (tmpP3d.y < this.lower.y) {
            this.lower.y = tmpP3d.y;
        }
        if (tmpP3d.z < this.lower.z) {
            this.lower.z = tmpP3d.z;
        }
        tmpP3d.set(lx, ly, uz);
        matrix.transform(tmpP3d);
        if (tmpP3d.x > this.upper.x) {
            this.upper.x = tmpP3d.x;
        }
        if (tmpP3d.y > this.upper.y) {
            this.upper.y = tmpP3d.y;
        }
        if (tmpP3d.z > this.upper.z) {
            this.upper.z = tmpP3d.z;
        }
        if (tmpP3d.x < this.lower.x) {
            this.lower.x = tmpP3d.x;
        }
        if (tmpP3d.y < this.lower.y) {
            this.lower.y = tmpP3d.y;
        }
        if (tmpP3d.z < this.lower.z) {
            this.lower.z = tmpP3d.z;
        }
        tmpP3d.set(ux, ly, uz);
        matrix.transform(tmpP3d);
        if (tmpP3d.x > this.upper.x) {
            this.upper.x = tmpP3d.x;
        }
        if (tmpP3d.y > this.upper.y) {
            this.upper.y = tmpP3d.y;
        }
        if (tmpP3d.z > this.upper.z) {
            this.upper.z = tmpP3d.z;
        }
        if (tmpP3d.x < this.lower.x) {
            this.lower.x = tmpP3d.x;
        }
        if (tmpP3d.y < this.lower.y) {
            this.lower.y = tmpP3d.y;
        }
        if (tmpP3d.z < this.lower.z) {
            this.lower.z = tmpP3d.z;
        }
        tmpP3d.set(lx, uy, lz);
        matrix.transform(tmpP3d);
        if (tmpP3d.x > this.upper.x) {
            this.upper.x = tmpP3d.x;
        }
        if (tmpP3d.y > this.upper.y) {
            this.upper.y = tmpP3d.y;
        }
        if (tmpP3d.z > this.upper.z) {
            this.upper.z = tmpP3d.z;
        }
        if (tmpP3d.x < this.lower.x) {
            this.lower.x = tmpP3d.x;
        }
        if (tmpP3d.y < this.lower.y) {
            this.lower.y = tmpP3d.y;
        }
        if (tmpP3d.z < this.lower.z) {
            this.lower.z = tmpP3d.z;
        }
        tmpP3d.set(ux, uy, lz);
        matrix.transform(tmpP3d);
        if (tmpP3d.x > this.upper.x) {
            this.upper.x = tmpP3d.x;
        }
        if (tmpP3d.y > this.upper.y) {
            this.upper.y = tmpP3d.y;
        }
        if (tmpP3d.z > this.upper.z) {
            this.upper.z = tmpP3d.z;
        }
        if (tmpP3d.x < this.lower.x) {
            this.lower.x = tmpP3d.x;
        }
        if (tmpP3d.y < this.lower.y) {
            this.lower.y = tmpP3d.y;
        }
        if (tmpP3d.z < this.lower.z) {
            this.lower.z = tmpP3d.z;
        }
        tmpP3d.set(lx, ly, lz);
        matrix.transform(tmpP3d);
        if (tmpP3d.x > this.upper.x) {
            this.upper.x = tmpP3d.x;
        }
        if (tmpP3d.y > this.upper.y) {
            this.upper.y = tmpP3d.y;
        }
        if (tmpP3d.z > this.upper.z) {
            this.upper.z = tmpP3d.z;
        }
        if (tmpP3d.x < this.lower.x) {
            this.lower.x = tmpP3d.x;
        }
        if (tmpP3d.y < this.lower.y) {
            this.lower.y = tmpP3d.y;
        }
        if (tmpP3d.z < this.lower.z) {
            this.lower.z = tmpP3d.z;
        }
        tmpP3d.set(ux, ly, lz);
        matrix.transform(tmpP3d);
        if (tmpP3d.x > this.upper.x) {
            this.upper.x = tmpP3d.x;
        }
        if (tmpP3d.y > this.upper.y) {
            this.upper.y = tmpP3d.y;
        }
        if (tmpP3d.z > this.upper.z) {
            this.upper.z = tmpP3d.z;
        }
        if (tmpP3d.x < this.lower.x) {
            this.lower.x = tmpP3d.x;
        }
        if (tmpP3d.y < this.lower.y) {
            this.lower.y = tmpP3d.y;
        }
        if (tmpP3d.z < this.lower.z) {
            this.lower.z = tmpP3d.z;
        }
    }

    @Override
    boolean intersect(Point3d origin, Vector3d direction, Point4d position) {
        double tmp;
        double t2;
        double t1;
        double invDir;
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            position.x = origin.x;
            position.y = origin.y;
            position.z = origin.z;
            position.w = 0.0;
            return true;
        }
        double dirLen = direction.x * direction.x + direction.y * direction.y + direction.z * direction.z;
        if (dirLen == 0.0) {
            return this.intersect(origin, position);
        }
        double invMag = 1.0 / Math.sqrt(dirLen);
        double dirx = direction.x * invMag;
        double diry = direction.y * invMag;
        double dirz = direction.z * invMag;
        double tnear = -1.7976931348623157E308;
        double tfar = Double.MAX_VALUE;
        if (dirx == 0.0) {
            if (origin.x < this.lower.x || origin.x > this.upper.x) {
                return false;
            }
        } else {
            invDir = 1.0 / dirx;
            t1 = (this.lower.x - origin.x) * invDir;
            t2 = (this.upper.x - origin.x) * invDir;
            if (t1 > t2) {
                tnear = t2;
                tfar = t1;
            } else {
                tnear = t1;
                tfar = t2;
            }
            if (tfar < 0.0) {
                return false;
            }
        }
        if (diry == 0.0) {
            if (origin.y < this.lower.y || origin.y > this.upper.y) {
                return false;
            }
        } else {
            invDir = 1.0 / diry;
            t1 = (this.lower.y - origin.y) * invDir;
            t2 = (this.upper.y - origin.y) * invDir;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if (t1 > tnear) {
                tnear = t1;
            }
            if (t2 < tfar) {
                tfar = t2;
            }
            if (tfar < 0.0 || tnear > tfar) {
                return false;
            }
        }
        if (dirz == 0.0) {
            if (origin.z < this.lower.z || origin.z > this.upper.z) {
                return false;
            }
        } else {
            invDir = 1.0 / dirz;
            t1 = (this.lower.z - origin.z) * invDir;
            t2 = (this.upper.z - origin.z) * invDir;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if (t1 > tnear) {
                tnear = t1;
            }
            if (t2 < tfar) {
                tfar = t2;
            }
            if (tfar < 0.0 || tnear > tfar) {
                return false;
            }
        }
        if (tnear < 0.0 && tfar >= 0.0) {
            position.x = origin.x + dirx * tfar;
            position.y = origin.y + diry * tfar;
            position.z = origin.z + dirz * tfar;
            position.w = tfar;
        } else {
            position.x = origin.x + dirx * tnear;
            position.y = origin.y + diry * tnear;
            position.z = origin.z + dirz * tnear;
            position.w = tnear;
        }
        return true;
    }

    @Override
    boolean intersect(Point3d point, Point4d position) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            position.x = point.x;
            position.y = point.y;
            position.z = point.z;
            position.w = 0.0;
            return true;
        }
        if (point.x <= this.upper.x && point.x >= this.lower.x && point.y <= this.upper.y && point.y >= this.lower.y && point.z <= this.upper.z && point.z >= this.lower.z) {
            position.x = point.x;
            position.y = point.y;
            position.z = point.z;
            position.w = 0.0;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d start, Point3d end, Point4d position) {
        double tmp;
        double t2;
        double t1;
        double invDir;
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            position.x = start.x;
            position.y = start.y;
            position.z = start.z;
            position.w = 0.0;
            return true;
        }
        double dirx = end.x - start.x;
        double diry = end.y - start.y;
        double dirz = end.z - start.z;
        double dirLen = dirx * dirx + diry * diry + dirz * dirz;
        if (dirLen == 0.0) {
            return this.intersect(start, position);
        }
        dirLen = Math.sqrt(dirLen);
        double invMag = 1.0 / dirLen;
        diry *= invMag;
        dirz *= invMag;
        double tnear = -1.7976931348623157E308;
        double tfar = Double.MAX_VALUE;
        if ((dirx *= invMag) == 0.0) {
            if (start.x < this.lower.x || start.x > this.upper.x) {
                return false;
            }
        } else {
            invDir = 1.0 / dirx;
            t1 = (this.lower.x - start.x) * invDir;
            t2 = (this.upper.x - start.x) * invDir;
            if (t1 > t2) {
                tnear = t2;
                tfar = t1;
            } else {
                tnear = t1;
                tfar = t2;
            }
            if (tfar < 0.0) {
                return false;
            }
        }
        if (diry == 0.0) {
            if (start.y < this.lower.y || start.y > this.upper.y) {
                return false;
            }
        } else {
            invDir = 1.0 / diry;
            t1 = (this.lower.y - start.y) * invDir;
            t2 = (this.upper.y - start.y) * invDir;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if (t1 > tnear) {
                tnear = t1;
            }
            if (t2 < tfar) {
                tfar = t2;
            }
            if (tfar < 0.0 || tnear > tfar) {
                return false;
            }
        }
        if (dirz == 0.0) {
            if (start.z < this.lower.z || start.z > this.upper.z) {
                return false;
            }
        } else {
            invDir = 1.0 / dirz;
            t1 = (this.lower.z - start.z) * invDir;
            t2 = (this.upper.z - start.z) * invDir;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if (t1 > tnear) {
                tnear = t1;
            }
            if (t2 < tfar) {
                tfar = t2;
            }
            if (tfar < 0.0 || tnear > tfar) {
                return false;
            }
        }
        if (tnear < 0.0 && tfar >= 0.0) {
            position.x = start.x + dirx * tfar;
            position.y = start.y + diry * tfar;
            position.z = start.z + dirz * tfar;
            position.w = tfar;
        } else {
            if (tnear > dirLen) {
                return false;
            }
            position.x = start.x + dirx * tnear;
            position.y = start.y + diry * tnear;
            position.z = start.z + dirz * tnear;
            position.w = tnear;
        }
        return true;
    }

    @Override
    public boolean intersect(Point3d origin, Vector3d direction) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        Point3d p = new Point3d();
        return this.intersect(origin, direction, p);
    }

    boolean intersect(Point3d origin, Vector3d direction, Point3d intersect) {
        double theta = 0.0;
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            intersect.x = origin.x;
            intersect.y = origin.y;
            intersect.z = origin.z;
            return true;
        }
        if (direction.x > 0.0) {
            theta = Math.max(theta, (this.lower.x - origin.x) / direction.x);
        }
        if (direction.x < 0.0) {
            theta = Math.max(theta, (this.upper.x - origin.x) / direction.x);
        }
        if (direction.y > 0.0) {
            theta = Math.max(theta, (this.lower.y - origin.y) / direction.y);
        }
        if (direction.y < 0.0) {
            theta = Math.max(theta, (this.upper.y - origin.y) / direction.y);
        }
        if (direction.z > 0.0) {
            theta = Math.max(theta, (this.lower.z - origin.z) / direction.z);
        }
        if (direction.z < 0.0) {
            theta = Math.max(theta, (this.upper.z - origin.z) / direction.z);
        }
        intersect.x = origin.x + theta * direction.x;
        intersect.y = origin.y + theta * direction.y;
        intersect.z = origin.z + theta * direction.z;
        if (intersect.x < this.lower.x - 1.0E-8) {
            return false;
        }
        if (intersect.x > this.upper.x + 1.0E-8) {
            return false;
        }
        if (intersect.y < this.lower.y - 1.0E-8) {
            return false;
        }
        if (intersect.y > this.upper.y + 1.0E-8) {
            return false;
        }
        if (intersect.z < this.lower.z - 1.0E-8) {
            return false;
        }
        return !(intersect.z > this.upper.z + 1.0E-8);
    }

    @Override
    public boolean intersect(Point3d point) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        return point.x <= this.upper.x && point.x >= this.lower.x && point.y <= this.upper.y && point.y >= this.lower.y && point.z <= this.upper.z && point.z >= this.lower.z;
    }

    @Override
    public boolean isEmpty() {
        return this.boundsIsEmpty;
    }

    @Override
    boolean intersect(Bounds boundsObject, Point4d position) {
        return this.intersect(boundsObject);
    }

    @Override
    public boolean intersect(Bounds boundsObject) {
        if (boundsObject == null) {
            return false;
        }
        if (this.boundsIsEmpty || boundsObject.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite || boundsObject.boundsIsInfinite) {
            return true;
        }
        if (boundsObject.boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObject;
            return this.upper.x > box.lower.x && box.upper.x > this.lower.x && this.upper.y > box.lower.y && box.upper.y > this.lower.y && this.upper.z > box.lower.z && box.upper.z > this.lower.z;
        }
        if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            double rad_sq = sphere.radius * sphere.radius;
            double dis = 0.0;
            if (sphere.center.x < this.lower.x) {
                dis = (sphere.center.x - this.lower.x) * (sphere.center.x - this.lower.x);
            } else if (sphere.center.x > this.upper.x) {
                dis = (sphere.center.x - this.upper.x) * (sphere.center.x - this.upper.x);
            }
            if (sphere.center.y < this.lower.y) {
                dis += (sphere.center.y - this.lower.y) * (sphere.center.y - this.lower.y);
            } else if (sphere.center.y > this.upper.y) {
                dis += (sphere.center.y - this.upper.y) * (sphere.center.y - this.upper.y);
            }
            if (sphere.center.z < this.lower.z) {
                dis += (sphere.center.z - this.lower.z) * (sphere.center.z - this.lower.z);
            } else if (sphere.center.z > this.upper.z) {
                dis += (sphere.center.z - this.upper.z) * (sphere.center.z - this.upper.z);
            }
            return dis <= rad_sq;
        }
        if (boundsObject.boundId == 4) {
            return this.intersect_ptope_abox((BoundingPolytope)boundsObject, this);
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingBox6"));
    }

    @Override
    public boolean intersect(Bounds[] boundsObjects) {
        if (boundsObjects == null || boundsObjects.length <= 0) {
            return false;
        }
        if (this.boundsIsEmpty) {
            return false;
        }
        for (int i = 0; i < boundsObjects.length; ++i) {
            if (boundsObjects[i] == null || boundsObjects[i].boundsIsEmpty) continue;
            if (this.boundsIsInfinite || boundsObjects[i].boundsIsInfinite) {
                return true;
            }
            if (boundsObjects[i].boundId == 1) {
                BoundingBox box = (BoundingBox)boundsObjects[i];
                if (!(this.upper.x > box.lower.x) || !(box.upper.x > this.lower.x) || !(this.upper.y > box.lower.y) || !(box.upper.y > this.lower.y) || !(this.upper.z > box.lower.z) || !(box.upper.z > this.lower.z)) continue;
                return true;
            }
            if (boundsObjects[i].boundId == 2) {
                BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                double rad_sq = sphere.radius * sphere.radius;
                double dis = 0.0;
                if (sphere.center.x < this.lower.x) {
                    dis = (sphere.center.x - this.lower.x) * (sphere.center.x - this.lower.x);
                } else if (sphere.center.x > this.upper.x) {
                    dis = (sphere.center.x - this.upper.x) * (sphere.center.x - this.upper.x);
                }
                if (sphere.center.y < this.lower.y) {
                    dis += (sphere.center.y - this.lower.y) * (sphere.center.y - this.lower.y);
                } else if (sphere.center.y > this.upper.y) {
                    dis += (sphere.center.y - this.upper.y) * (sphere.center.y - this.upper.y);
                }
                if (sphere.center.z < this.lower.z) {
                    dis += (sphere.center.z - this.lower.z) * (sphere.center.z - this.lower.z);
                } else if (sphere.center.z > this.upper.z) {
                    dis += (sphere.center.z - this.upper.z) * (sphere.center.z - this.upper.z);
                }
                if (!(dis <= rad_sq)) continue;
                return true;
            }
            if (boundsObjects[i].boundId != 4 || !this.intersect_ptope_abox((BoundingPolytope)boundsObjects[i], this)) continue;
            return true;
        }
        return false;
    }

    public boolean intersect(Bounds boundsObject, BoundingBox newBoundBox) {
        if (boundsObject == null || this.boundsIsEmpty || boundsObject.boundsIsEmpty) {
            newBoundBox.set(null);
            return false;
        }
        if (this.boundsIsInfinite && !boundsObject.boundsIsInfinite) {
            newBoundBox.set(boundsObject);
            return true;
        }
        if (!this.boundsIsInfinite && boundsObject.boundsIsInfinite) {
            newBoundBox.set(this);
            return true;
        }
        if (this.boundsIsInfinite && boundsObject.boundsIsInfinite) {
            newBoundBox.set(this);
            return true;
        }
        if (boundsObject.boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObject;
            if (this.upper.x > box.lower.x && box.upper.x > this.lower.x && this.upper.y > box.lower.y && box.upper.y > this.lower.y && this.upper.z > box.lower.z && box.upper.z > this.lower.z) {
                newBoundBox.upper.x = this.upper.x > box.upper.x ? box.upper.x : this.upper.x;
                newBoundBox.upper.y = this.upper.y > box.upper.y ? box.upper.y : this.upper.y;
                newBoundBox.upper.z = this.upper.z > box.upper.z ? box.upper.z : this.upper.z;
                newBoundBox.lower.x = this.lower.x < box.lower.x ? box.lower.x : this.lower.x;
                newBoundBox.lower.y = this.lower.y < box.lower.y ? box.lower.y : this.lower.y;
                newBoundBox.lower.z = this.lower.z < box.lower.z ? box.lower.z : this.lower.z;
                newBoundBox.updateBoundsStates();
                return true;
            }
            newBoundBox.set(null);
            return false;
        }
        if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            if (this.intersect(sphere)) {
                BoundingBox sbox = new BoundingBox(sphere);
                this.intersect((Bounds)sbox, newBoundBox);
                return true;
            }
            newBoundBox.set(null);
            return false;
        }
        if (boundsObject.boundId == 4) {
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            if (this.intersect(polytope)) {
                BoundingBox pbox = new BoundingBox(polytope);
                this.intersect((Bounds)pbox, newBoundBox);
                return true;
            }
            newBoundBox.set(null);
            return false;
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingBox7"));
    }

    public boolean intersect(Bounds[] boundsObjects, BoundingBox newBoundBox) {
        int i;
        if (boundsObjects == null || boundsObjects.length <= 0 || this.boundsIsEmpty) {
            newBoundBox.set(null);
            return false;
        }
        for (i = 0; boundsObjects[i] == null && i < boundsObjects.length; ++i) {
        }
        if (i >= boundsObjects.length) {
            newBoundBox.set(null);
            return false;
        }
        boolean status = false;
        BoundingBox tbox = new BoundingBox();
        while (i < boundsObjects.length) {
            if (boundsObjects[i] != null && !boundsObjects[i].boundsIsEmpty) {
                if (boundsObjects[i].boundId == 1) {
                    BoundingBox box = (BoundingBox)boundsObjects[i];
                    if (this.upper.x > box.lower.x && box.upper.x > this.lower.x && this.upper.y > box.lower.y && box.upper.y > this.lower.y && this.upper.z > box.lower.z && box.upper.z > this.lower.z) {
                        newBoundBox.upper.x = this.upper.x > box.upper.x ? box.upper.x : this.upper.x;
                        newBoundBox.upper.y = this.upper.y > box.upper.y ? box.upper.y : this.upper.y;
                        newBoundBox.upper.z = this.upper.z > box.upper.z ? box.upper.z : this.upper.z;
                        newBoundBox.lower.x = this.lower.x < box.lower.x ? box.lower.x : this.lower.x;
                        newBoundBox.lower.y = this.lower.y < box.lower.y ? box.lower.y : this.lower.y;
                        newBoundBox.lower.z = this.lower.z < box.lower.z ? box.lower.z : this.lower.z;
                        status = true;
                        newBoundBox.updateBoundsStates();
                    }
                } else if (boundsObjects[i].boundId == 2) {
                    BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                    if (this.intersect(sphere)) {
                        BoundingBox sbox = new BoundingBox(sphere);
                        this.intersect((Bounds)sbox, tbox);
                        if (status) {
                            newBoundBox.combine(tbox);
                        } else {
                            newBoundBox.set(tbox);
                            status = true;
                        }
                    }
                } else if (boundsObjects[i].boundId == 4) {
                    BoundingPolytope polytope = (BoundingPolytope)boundsObjects[i];
                    if (this.intersect(polytope)) {
                        BoundingBox pbox = new BoundingBox(polytope);
                        this.intersect((Bounds)pbox, tbox);
                        if (status) {
                            newBoundBox.combine(tbox);
                        } else {
                            newBoundBox.set(tbox);
                            status = true;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingBox6"));
                }
            }
            if (newBoundBox.boundsIsInfinite) break;
            ++i;
        }
        if (!status) {
            newBoundBox.set(null);
        }
        return status;
    }

    @Override
    public Bounds closestIntersection(Bounds[] boundsObjects) {
        if (boundsObjects == null || boundsObjects.length <= 0) {
            return null;
        }
        if (this.boundsIsEmpty) {
            return null;
        }
        Point3d centroid = this.getCenter();
        double cenX = 0.0;
        double cenY = 0.0;
        double cenZ = 0.0;
        boolean contains = false;
        boolean intersect = false;
        double smallest_distance = Double.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < boundsObjects.length; ++i) {
            boolean inside;
            double dis;
            if (boundsObjects[i] == null || !this.intersect(boundsObjects[i])) continue;
            intersect = true;
            if (boundsObjects[i].boundId == 1) {
                BoundingBox box = (BoundingBox)boundsObjects[i];
                cenX = (box.upper.x + box.lower.x) / 2.0;
                cenY = (box.upper.y + box.lower.y) / 2.0;
                cenZ = (box.upper.z + box.lower.z) / 2.0;
                dis = Math.sqrt((centroid.x - cenX) * (centroid.x - cenX) + (centroid.y - cenY) * (centroid.y - cenY) + (centroid.z - cenZ) * (centroid.z - cenZ));
                inside = false;
                if (this.lower.x <= box.lower.x && this.lower.y <= box.lower.y && this.lower.z <= box.lower.z && this.upper.x >= box.upper.x && this.upper.y >= box.upper.y && this.upper.z >= box.upper.z) {
                    inside = true;
                }
                if (inside) {
                    if (!contains) {
                        index = i;
                        smallest_distance = dis;
                        contains = true;
                        continue;
                    }
                    if (!(dis < smallest_distance)) continue;
                    index = i;
                    smallest_distance = dis;
                    continue;
                }
                if (contains || !(dis < smallest_distance)) continue;
                index = i;
                smallest_distance = dis;
                continue;
            }
            if (boundsObjects[i].boundId == 2) {
                BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                dis = Math.sqrt((centroid.x - sphere.center.x) * (centroid.x - sphere.center.x) + (centroid.y - sphere.center.y) * (centroid.y - sphere.center.y) + (centroid.z - sphere.center.z) * (centroid.z - sphere.center.z));
                inside = false;
                if (sphere.center.x <= this.upper.x && sphere.center.x >= this.lower.x && sphere.center.y <= this.upper.y && sphere.center.y >= this.lower.y && sphere.center.z <= this.upper.z && sphere.center.z >= this.lower.z && sphere.center.x - this.lower.x >= sphere.radius && this.upper.x - sphere.center.x >= sphere.radius && sphere.center.y - this.lower.y >= sphere.radius && this.upper.y - sphere.center.y >= sphere.radius && sphere.center.z - this.lower.z >= sphere.radius && this.upper.z - sphere.center.z >= sphere.radius) {
                    inside = true;
                }
                if (inside) {
                    if (!contains) {
                        index = i;
                        smallest_distance = dis;
                        contains = true;
                        continue;
                    }
                    if (!(dis < smallest_distance)) continue;
                    index = i;
                    smallest_distance = dis;
                    continue;
                }
                if (contains || !(dis < smallest_distance)) continue;
                index = i;
                smallest_distance = dis;
                continue;
            }
            if (boundsObjects[i].boundId == 4) {
                BoundingPolytope polytope = (BoundingPolytope)boundsObjects[i];
                dis = Math.sqrt((centroid.x - polytope.centroid.x) * (centroid.x - polytope.centroid.x) + (centroid.y - polytope.centroid.y) * (centroid.y - polytope.centroid.y) + (centroid.z - polytope.centroid.z) * (centroid.z - polytope.centroid.z));
                inside = true;
                for (int j = 0; j < polytope.nVerts; ++j) {
                    if (!(polytope.verts[j].x < this.lower.x || polytope.verts[j].y < this.lower.y || polytope.verts[j].z < this.lower.z || polytope.verts[j].x > this.upper.x || polytope.verts[j].y > this.upper.y) && !(polytope.verts[j].z > this.upper.z)) continue;
                    inside = false;
                }
                if (inside) {
                    if (!contains) {
                        index = i;
                        smallest_distance = dis;
                        contains = true;
                        continue;
                    }
                    if (!(dis < smallest_distance)) continue;
                    index = i;
                    smallest_distance = dis;
                    continue;
                }
                if (contains || !(dis < smallest_distance)) continue;
                index = i;
                smallest_distance = dis;
                continue;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox9"));
        }
        if (intersect) {
            return boundsObjects[index];
        }
        return null;
    }

    boolean intersect(CachedFrustum frustum) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        if (this.upper.x < frustum.lower.x || this.lower.x > frustum.upper.x || this.upper.y < frustum.lower.y || this.lower.y > frustum.upper.y || this.upper.z < frustum.lower.z || this.lower.z > frustum.upper.z) {
            return false;
        }
        int i = 5;
        while (i >= 0) {
            Vector4d vc = frustum.clipPlanes[i--];
            double upxxvcx = this.upper.x * vc.x;
            double loxxvcx = this.lower.x * vc.x;
            double upyxvcy = this.upper.y * vc.y;
            double loyxvcy = this.lower.y * vc.y;
            double upzxvcz = this.upper.z * vc.z;
            double lozxvcz = this.lower.z * vc.z;
            if (!(upxxvcx + upyxvcy + upzxvcz + vc.w < 0.0) || !(upxxvcx + loyxvcy + upzxvcz + vc.w < 0.0) || !(upxxvcx + loyxvcy + lozxvcz + vc.w < 0.0) || !(upxxvcx + upyxvcy + lozxvcz + vc.w < 0.0) || !(loxxvcx + upyxvcy + upzxvcz + vc.w < 0.0) || !(loxxvcx + loyxvcy + upzxvcz + vc.w < 0.0) || !(loxxvcx + loyxvcy + lozxvcz + vc.w < 0.0) || !(loxxvcx + upyxvcy + lozxvcz + vc.w < 0.0)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new String("Bounding box: Lower=" + this.lower.x + " " + this.lower.y + " " + this.lower.z + " Upper=" + this.upper.x + " " + this.upper.y + " " + this.upper.z);
    }

    private void setEmptyBounds() {
        this.lower.set(1.0, 1.0, 1.0);
        this.upper.set(-1.0, -1.0, -1.0);
        this.boundsIsInfinite = false;
        this.boundsIsEmpty = true;
    }

    private void setInfiniteBounds() {
        this.lower.set(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.upper.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.boundsIsInfinite = true;
        this.boundsIsEmpty = false;
    }

    private void updateBoundsStates() {
        if (this.lower.x == Double.NEGATIVE_INFINITY && this.lower.y == Double.NEGATIVE_INFINITY && this.lower.z == Double.NEGATIVE_INFINITY && this.upper.x == Double.POSITIVE_INFINITY && this.upper.y == Double.POSITIVE_INFINITY && this.upper.z == Double.POSITIVE_INFINITY) {
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = true;
            return;
        }
        if (Double.isNaN(this.lower.x + this.lower.y + this.lower.z + this.upper.x + this.upper.y + this.upper.z)) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            return;
        }
        this.boundsIsInfinite = false;
        this.boundsIsEmpty = this.lower.x > this.upper.x || this.lower.y > this.upper.y || this.lower.z > this.upper.z;
    }

    @Override
    Point3d getCenter() {
        Point3d cent = new Point3d();
        cent.add((Tuple3d)this.upper, (Tuple3d)this.lower);
        cent.scale(0.5);
        return cent;
    }

    @Override
    public void getCenter(Point3d center) {
        center.add((Tuple3d)this.lower, (Tuple3d)this.upper);
        center.scale(0.5);
    }

    void translate(BoundingBox bbox, Vector3d value) {
        if (bbox == null || bbox.boundsIsEmpty) {
            this.setEmptyBounds();
            return;
        }
        if (bbox.boundsIsInfinite) {
            this.setInfiniteBounds();
            return;
        }
        this.lower.x = bbox.lower.x + value.x;
        this.lower.y = bbox.lower.y + value.y;
        this.lower.z = bbox.lower.z + value.z;
        this.upper.x = bbox.upper.x + value.x;
        this.upper.y = bbox.upper.y + value.y;
        this.upper.z = bbox.upper.z + value.z;
    }

    @Override
    Bounds copy(Bounds r) {
        if (r != null && this.boundId == r.boundId) {
            BoundingBox region = (BoundingBox)r;
            region.lower.x = this.lower.x;
            region.lower.y = this.lower.y;
            region.lower.z = this.lower.z;
            region.upper.x = this.upper.x;
            region.upper.y = this.upper.y;
            region.upper.z = this.upper.z;
            region.boundsIsEmpty = this.boundsIsEmpty;
            region.boundsIsInfinite = this.boundsIsInfinite;
            return region;
        }
        return (Bounds)this.clone();
    }

    @Override
    int getPickType() {
        return 6;
    }
}

