/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.J3dI18N;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple4d;
import org.jogamp.vecmath.Vector4d;

class CachedFrustum {
    static final double EPSILON = 1.0E-8;
    Vector4d[] clipPlanes;
    Point3d[] verts;
    Point3d upper;
    Point3d lower;
    Point3d center;

    CachedFrustum(Vector4d[] planes) {
        int i;
        if (planes.length < 6) {
            throw new IllegalArgumentException(J3dI18N.getString("CachedFrustum0"));
        }
        this.clipPlanes = new Vector4d[6];
        this.verts = new Point3d[8];
        this.upper = new Point3d();
        this.lower = new Point3d();
        this.center = new Point3d();
        for (i = 0; i < 8; ++i) {
            this.verts[i] = new Point3d();
        }
        for (i = 0; i < 6; ++i) {
            this.clipPlanes[i] = new Vector4d(planes[i]);
        }
        this.computeValues(this.clipPlanes);
    }

    CachedFrustum() {
        int i;
        this.clipPlanes = new Vector4d[6];
        this.upper = new Point3d();
        this.lower = new Point3d();
        this.verts = new Point3d[8];
        this.center = new Point3d();
        for (i = 0; i < 8; ++i) {
            this.verts[i] = new Point3d();
        }
        for (i = 0; i < 6; ++i) {
            this.clipPlanes[i] = new Vector4d();
        }
    }

    public String toString() {
        return this.clipPlanes[0].toString() + "\n" + this.clipPlanes[1].toString() + "\n" + this.clipPlanes[2].toString() + "\n" + this.clipPlanes[3].toString() + "\n" + this.clipPlanes[4].toString() + "\n" + this.clipPlanes[5].toString() + "\n" + "corners=" + "\n" + this.verts[0].toString() + "\n" + this.verts[1].toString() + "\n" + this.verts[2].toString() + "\n" + this.verts[3].toString() + "\n" + this.verts[4].toString() + "\n" + this.verts[5].toString() + "\n" + this.verts[6].toString() + "\n" + this.verts[7].toString();
    }

    void set(Vector4d[] planes) {
        if (planes.length != 6) {
            throw new IllegalArgumentException(J3dI18N.getString("CachedFrustum1"));
        }
        for (int i = 0; i < 6; ++i) {
            this.clipPlanes[i].set((Tuple4d)planes[i]);
        }
        this.computeValues(this.clipPlanes);
    }

    private void computeValues(Vector4d[] planes) {
        this.computeVertex(0, 3, 4, this.verts[0]);
        this.computeVertex(0, 2, 4, this.verts[1]);
        this.computeVertex(1, 2, 4, this.verts[2]);
        this.computeVertex(1, 3, 4, this.verts[3]);
        this.computeVertex(0, 3, 5, this.verts[4]);
        this.computeVertex(0, 2, 5, this.verts[5]);
        this.computeVertex(1, 2, 5, this.verts[6]);
        this.computeVertex(1, 3, 5, this.verts[7]);
        this.upper.x = this.verts[0].x;
        this.upper.y = this.verts[0].y;
        this.upper.z = this.verts[0].z;
        this.lower.x = this.verts[0].x;
        this.lower.y = this.verts[0].y;
        this.lower.z = this.verts[0].z;
        this.center.x = this.verts[0].x;
        this.center.y = this.verts[0].y;
        this.center.z = this.verts[0].z;
        for (int i = 1; i < 8; ++i) {
            if (this.verts[i].x > this.upper.x) {
                this.upper.x = this.verts[i].x;
            }
            if (this.verts[i].x < this.lower.x) {
                this.lower.x = this.verts[i].x;
            }
            if (this.verts[i].y > this.upper.y) {
                this.upper.y = this.verts[i].y;
            }
            if (this.verts[i].y < this.lower.y) {
                this.lower.y = this.verts[i].y;
            }
            if (this.verts[i].z > this.upper.z) {
                this.upper.z = this.verts[i].z;
            }
            if (this.verts[i].z < this.lower.z) {
                this.lower.z = this.verts[i].z;
            }
            this.center.x += this.verts[i].x;
            this.center.y += this.verts[i].y;
            this.center.z += this.verts[i].z;
        }
        this.center.x *= 0.125;
        this.center.y *= 0.125;
        this.center.z *= 0.125;
    }

    private void computeVertex(int a, int b, int c, Point3d vert) {
        double det = this.clipPlanes[a].x * this.clipPlanes[b].y * this.clipPlanes[c].z + this.clipPlanes[a].y * this.clipPlanes[b].z * this.clipPlanes[c].x + this.clipPlanes[a].z * this.clipPlanes[b].x * this.clipPlanes[c].y - this.clipPlanes[a].z * this.clipPlanes[b].y * this.clipPlanes[c].x - this.clipPlanes[a].y * this.clipPlanes[b].x * this.clipPlanes[c].z - this.clipPlanes[a].x * this.clipPlanes[b].z * this.clipPlanes[c].y;
        if (det * det < 1.0E-8) {
            return;
        }
        det = 1.0 / det;
        vert.x = (this.clipPlanes[b].y * this.clipPlanes[c].z - this.clipPlanes[b].z * this.clipPlanes[c].y) * -this.clipPlanes[a].w;
        vert.y = (this.clipPlanes[b].z * this.clipPlanes[c].x - this.clipPlanes[b].x * this.clipPlanes[c].z) * -this.clipPlanes[a].w;
        vert.z = (this.clipPlanes[b].x * this.clipPlanes[c].y - this.clipPlanes[b].y * this.clipPlanes[c].x) * -this.clipPlanes[a].w;
        vert.x += (this.clipPlanes[c].y * this.clipPlanes[a].z - this.clipPlanes[c].z * this.clipPlanes[a].y) * -this.clipPlanes[b].w;
        vert.y += (this.clipPlanes[c].z * this.clipPlanes[a].x - this.clipPlanes[c].x * this.clipPlanes[a].z) * -this.clipPlanes[b].w;
        vert.z += (this.clipPlanes[c].x * this.clipPlanes[a].y - this.clipPlanes[c].y * this.clipPlanes[a].x) * -this.clipPlanes[b].w;
        vert.x += (this.clipPlanes[a].y * this.clipPlanes[b].z - this.clipPlanes[a].z * this.clipPlanes[b].y) * -this.clipPlanes[c].w;
        vert.y += (this.clipPlanes[a].z * this.clipPlanes[b].x - this.clipPlanes[a].x * this.clipPlanes[b].z) * -this.clipPlanes[c].w;
        vert.z += (this.clipPlanes[a].x * this.clipPlanes[b].y - this.clipPlanes[a].y * this.clipPlanes[b].x) * -this.clipPlanes[c].w;
        vert.x *= det;
        vert.y *= det;
        vert.z *= det;
    }
}

