/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layer;

import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import bibliothek.gui.dock.station.toolbar.layer.ToolbarGroupInnerLayer;
import bibliothek.gui.dock.station.toolbar.layout.ToolbarGridLayoutManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class ToolbarGroupOuterLayer
extends ToolbarGroupInnerLayer {
    public ToolbarGroupOuterLayer(ToolbarGroupDockStation toolbarGroupDockStation, Component component) {
        super(toolbarGroupDockStation, component);
        this.setPriority(LayerPriority.OVERRIDE_PRECISE);
    }

    @Override
    public DockStationDropLayer modify(DockStationDropLayer dockStationDropLayer) {
        return dockStationDropLayer;
    }

    @Override
    public boolean contains(int n, int n2) {
        Rectangle rectangle;
        int n3;
        ToolbarGroupDockStation toolbarGroupDockStation = this.getStation();
        if (!toolbarGroupDockStation.isAllowSideSnap()) {
            return false;
        }
        if (this.isComponentContain(n, n2)) {
            return false;
        }
        int n4 = toolbarGroupDockStation.getBorderSideSnapSize();
        if (toolbarGroupDockStation.columnCount() == 0) {
            Point point = new Point(n, n2);
            SwingUtilities.convertPointFromScreen(point, this.getComponent());
            Rectangle rectangle2 = this.getComponent().getBounds();
            Rectangle rectangle3 = new Rectangle(rectangle2.x - n4, rectangle2.y - n4, rectangle2.width + n4 * 2, rectangle2.height + n4 * 2);
            return rectangle3.contains(point);
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.getComponent());
        ToolbarGridLayoutManager<StationChildHandle> toolbarGridLayoutManager = toolbarGroupDockStation.getLayoutManager();
        int n5 = toolbarGroupDockStation.columnCount();
        for (n3 = 0; n3 < n5; ++n3) {
            rectangle = toolbarGridLayoutManager.getBounds(n3);
            if (!this.isNear(rectangle, n4, point)) continue;
            return true;
        }
        for (n3 = 0; n3 <= n5; ++n3) {
            rectangle = toolbarGridLayoutManager.getGapBounds(n3, true);
            if (!this.isNear(rectangle, n4, point)) continue;
            return true;
        }
        return false;
    }

    private boolean isNear(Rectangle rectangle, int n, Point point) {
        if (rectangle.contains(point)) {
            return false;
        }
        int n2 = Math.min(Math.abs(rectangle.x - point.x), Math.abs(point.x - rectangle.x - rectangle.width));
        int n3 = Math.min(Math.abs(rectangle.y - point.y), Math.abs(point.y - rectangle.y - rectangle.height));
        if (n2 <= n) {
            return n3 <= n || rectangle.y <= point.y && rectangle.y + rectangle.height >= point.y;
        }
        if (n3 <= n) {
            return n2 <= n || rectangle.x <= point.x && rectangle.x + rectangle.width >= point.x;
        }
        return false;
    }

    private boolean isComponentContain(int n, int n2) {
        return super.contains(n, n2);
    }
}

