/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.split.DefaultSplitDividerStrategy;
import bibliothek.gui.dock.station.split.DefaultSplitLayoutManager;
import bibliothek.gui.dock.station.split.Divideable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.basic.NoSpanFactory;
import bibliothek.gui.dock.wizard.CellDivider;
import bibliothek.gui.dock.wizard.ColumnDividier;
import bibliothek.gui.dock.wizard.PersistentColumn;
import bibliothek.gui.dock.wizard.WizardColumnModel;
import bibliothek.gui.dock.wizard.WizardNodeMap;
import bibliothek.gui.dock.wizard.WizardSpanStrategy;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class WizardSplitDockStation
extends SplitDockStation
implements Scrollable {
    private WizardLayoutManager layoutManager;
    private WizardSpanStrategy wizardSpanStrategy;
    private Side side;
    private boolean onRevalidating = false;
    private int sideGap = 3;
    private boolean resizeOnRemove = false;
    private WizardNodeMap.Column columnToResize = null;
    private Dockable dockableCausingResize = null;
    private int maxColumnCount = -1;

    public WizardSplitDockStation(Side side) {
        this.side = side;
        this.layoutManager = new WizardLayoutManager();
        this.wizardSpanStrategy = new WizardSpanStrategy(this);
        this.setSplitLayoutManager(this.layoutManager);
        this.setDividerStrategy(new WizardDividerStrategy());
        this.setAllowSideSnap(true);
        this.getSpanStrategy().getFactory().setDelegate(new NoSpanFactory());
        this.addDockStationListener(new DockStationListener(){

            @Override
            public void dockablesRepositioned(DockStation dockStation, Dockable[] dockableArray) {
                WizardSplitDockStation.this.revalidateOutside();
            }

            @Override
            public void dockableShowingChanged(DockStation dockStation, Dockable dockable, boolean bl) {
                WizardSplitDockStation.this.revalidateOutside();
            }

            @Override
            public void dockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
            }

            @Override
            public void dockableRemoving(DockStation dockStation, Dockable dockable) {
                WizardSplitDockStation.this.storeColumnToResize(dockable);
            }

            @Override
            public void dockableRemoved(DockStation dockStation, Dockable dockable) {
                WizardSplitDockStation.this.resizeStoredColumn();
            }

            @Override
            public void dockableAdding(DockStation dockStation, Dockable dockable) {
            }

            @Override
            public void dockableAdded(DockStation dockStation, Dockable dockable) {
                WizardSplitDockStation.this.revalidateOutside();
            }
        });
    }

    public void revalidateOutside() {
        if (!this.onRevalidating) {
            this.revalidate();
            if (EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (WizardSplitDockStation.this.getParent() instanceof JViewport) {
                            Container container;
                            for (container = WizardSplitDockStation.this.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
                            }
                            if (container != null && (container = container.getParent()) instanceof JComponent) {
                                ((JComponent)container).revalidate();
                            }
                        }
                        try {
                            WizardSplitDockStation.this.onRevalidating = true;
                            WizardSplitDockStation.this.updateBounds();
                        }
                        finally {
                            WizardSplitDockStation.this.onRevalidating = false;
                        }
                    }
                });
            }
        }
    }

    @Override
    public String getFactoryID() {
        return "WizardSplitDockStationFactory";
    }

    public WizardLayoutManager getWizardSplitLayoutManager() {
        return this.layoutManager;
    }

    public WizardSpanStrategy getWizardSpanStrategy() {
        return this.wizardSpanStrategy;
    }

    @Override
    public void setDividerSize(int n) {
        super.setDividerSize(n);
        if (this.wizardSpanStrategy != null) {
            this.wizardSpanStrategy.reset();
        }
    }

    public void setResizeOnRemove(boolean bl) {
        this.resizeOnRemove = bl;
    }

    public boolean isResizeOnRemove() {
        return this.resizeOnRemove;
    }

    @Override
    public void setController(DockController dockController) {
        this.wizardSpanStrategy.setController(dockController);
        super.setController(dockController);
    }

    @Override
    protected void setPut(PutInfo putInfo) {
        this.wizardSpanStrategy.setPut(putInfo);
        if (putInfo != null) {
            this.storeColumnToResize(putInfo.getDockable());
        }
    }

    @Override
    protected void unsetPut() {
        this.wizardSpanStrategy.unsetPut();
    }

    @Override
    protected boolean dropAside(SplitNode splitNode, PutInfo.Put put, Dockable dockable, Leaf leaf, double d, DockHierarchyLock.Token token) {
        if (super.dropAside(splitNode, put, dockable, leaf, d, token)) {
            this.resizeStoredColumn();
            return true;
        }
        return false;
    }

    @Override
    protected boolean dropOver(Leaf leaf, Dockable dockable, DockableProperty dockableProperty, CombinerSource combinerSource, CombinerTarget combinerTarget) {
        if (super.dropOver(leaf, dockable, dockableProperty, combinerSource, combinerTarget)) {
            this.resizeStoredColumn();
            return true;
        }
        return false;
    }

    private void storeColumnToResize(Dockable dockable) {
        if (this.resizeOnRemove && dockable.getDockParent() == this) {
            this.columnToResize = this.layoutManager.getMap().getColumn(dockable);
            if (this.columnToResize != null && this.columnToResize.getCellCount() == 1) {
                this.columnToResize = null;
            } else {
                this.dockableCausingResize = dockable;
            }
        } else {
            this.columnToResize = null;
        }
    }

    private void resizeStoredColumn() {
        if (this.columnToResize != null) {
            WizardNodeMap wizardNodeMap = this.layoutManager.getMap();
            WizardNodeMap.Column column = wizardNodeMap.getColumn(this.dockableCausingResize);
            PersistentColumn persistentColumn = null;
            if (column == null || column.getIndex() > this.columnToResize.getIndex()) {
                persistentColumn = wizardNodeMap.getPersistentColumn(this.columnToResize.getIndex());
            } else if (column.getCellCount() == 1) {
                persistentColumn = wizardNodeMap.getPersistentColumn(this.columnToResize.getIndex() + 1);
            } else if (column.getIndex() != this.columnToResize.getIndex()) {
                persistentColumn = wizardNodeMap.getPersistentColumn(this.columnToResize.getIndex());
            }
            if (persistentColumn != null) {
                persistentColumn.setSize(persistentColumn.getPreferredSize());
            }
            this.columnToResize = null;
            this.dockableCausingResize = null;
        }
        this.revalidateOutside();
    }

    public int getSideGap() {
        return this.sideGap;
    }

    public void setSideGap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("sideGap must be at least 0: " + n);
        }
        this.sideGap = n;
        this.revalidate();
    }

    public Side getSide() {
        return this.side;
    }

    public void setSide(Side side) {
        if (side == null) {
            throw new IllegalArgumentException("side must not be null");
        }
        if (this.side != side) {
            boolean bl = this.side.getHeaderOrientation() != side.getHeaderOrientation();
            this.side = side;
            if (bl) {
                this.root().visit(new SplitNodeVisitor(){

                    @Override
                    public void handleRoot(Root root) {
                    }

                    @Override
                    public void handlePlaceholder(Placeholder placeholder) {
                    }

                    @Override
                    public void handleNode(Node node) {
                        switch (node.getOrientation()) {
                            case HORIZONTAL: {
                                node.setOrientation(SplitDockStation.Orientation.VERTICAL);
                                break;
                            }
                            case VERTICAL: {
                                node.setOrientation(SplitDockStation.Orientation.HORIZONTAL);
                            }
                        }
                    }

                    @Override
                    public void handleLeaf(Leaf leaf) {
                    }
                });
            }
            this.resetToPreferredSizes();
        }
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 20;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.side == Side.LEFT || this.side == Side.RIGHT) {
            return true;
        }
        return this.getParent() instanceof JViewport && this.getParent().getWidth() > this.getPreferredSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.side == Side.TOP || this.side == Side.BOTTOM) {
            return true;
        }
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.layoutManager == null) {
            return super.getPreferredSize();
        }
        return this.layoutManager.getPreferredSize();
    }

    @Override
    protected void paintOverlay(Graphics graphics) {
        PutInfo putInfo = this.getDropInfo();
        if (putInfo != null) {
            DefaultStationPaintValue defaultStationPaintValue = this.getPaint();
            if (putInfo.getNode() == null) {
                Insets insets = this.getInsets();
                Rectangle rectangle = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                defaultStationPaintValue.drawInsertion(graphics, rectangle, rectangle);
            } else {
                CombinerTarget combinerTarget = putInfo.getCombinerTarget();
                if (combinerTarget == null) {
                    Rectangle rectangle = putInfo.getNode().getBounds();
                    int n = this.getWizardSpanStrategy().getGap();
                    if (putInfo.getPut() == PutInfo.Put.LEFT) {
                        rectangle.x -= n;
                        rectangle.width = n;
                        rectangle.x = Math.max(0, rectangle.x);
                    } else if (putInfo.getPut() == PutInfo.Put.RIGHT) {
                        rectangle.x += rectangle.width;
                        rectangle.width = n;
                        rectangle.x = Math.min(rectangle.x, this.getWidth() - n - 1);
                    } else if (putInfo.getPut() == PutInfo.Put.TOP) {
                        rectangle.y -= n;
                        rectangle.height = n;
                        rectangle.y = Math.max(0, rectangle.y);
                    } else if (putInfo.getPut() == PutInfo.Put.BOTTOM) {
                        rectangle.y += rectangle.height;
                        rectangle.height = n;
                        rectangle.y = Math.min(rectangle.y, this.getHeight() - n - 1);
                    }
                    defaultStationPaintValue.drawInsertion(graphics, putInfo.getNode().getBounds(), rectangle);
                } else {
                    Rectangle rectangle = putInfo.getNode().getBounds();
                    StationPaint stationPaint = (StationPaint)defaultStationPaintValue.get();
                    if (stationPaint != null) {
                        combinerTarget.paint(graphics, this.getComponent(), stationPaint, rectangle, rectangle);
                    }
                }
            }
        }
        this.getDividerStrategy().paint(this, graphics);
    }

    private Leaf resizeableLeafAt(int n, int n2) {
        block3: {
            int n3;
            Leaf[] leafArray;
            block2: {
                leafArray = this.layoutManager.getLastLeafOfColumns();
                n3 = this.getDividerSize();
                if (this.side != Side.RIGHT && this.side != Side.LEFT) break block2;
                for (Leaf leaf : leafArray) {
                    Rectangle rectangle = leaf.getBounds();
                    if (rectangle.x > n || rectangle.x + rectangle.width < n || rectangle.y + rectangle.height > n2 || rectangle.y + rectangle.height + n3 < n2) continue;
                    return leaf;
                }
                break block3;
            }
            if (this.side != Side.BOTTOM && this.side != Side.TOP) break block3;
            for (Leaf leaf : leafArray) {
                Rectangle rectangle = leaf.getBounds();
                if (rectangle.y > n2 || rectangle.y + rectangle.height < n2 || rectangle.x + rectangle.width > n || rectangle.x + rectangle.width + n3 < n) continue;
                return leaf;
            }
        }
        return null;
    }

    public PersistentColumn[] getPersistentColumns() {
        return this.layoutManager.model.getPersistentColumns();
    }

    public void setPersistentColumns(Dockable[][] dockableArray, int[][] nArray, int[] nArray2) {
        this.layoutManager.model.setPersistentColumns(dockableArray, nArray, nArray2);
    }

    public int getMaxColumnCount() {
        return this.maxColumnCount;
    }

    public void setMaxColumnCount(int n) {
        if (n != -1 && n < 1) {
            throw new IllegalArgumentException("maxColumnCount is out of bounds");
        }
        this.maxColumnCount = n;
    }

    @Override
    public boolean drop(Dockable dockable, SplitDockPlaceholderProperty splitDockPlaceholderProperty) {
        SplitNode splitNode = this.getRoot().getPlaceholderNode(splitDockPlaceholderProperty.getPlaceholder());
        if (!(splitNode == null || splitNode instanceof Leaf || splitNode instanceof Root || !(splitNode instanceof Placeholder) && ((Node)splitNode).getOrientation() != this.side.getHeaderOrientation())) {
            this.pushIntoHeader(splitNode);
        }
        return super.drop(dockable, splitDockPlaceholderProperty);
    }

    private void pushIntoHeader(SplitNode splitNode) {
        SplitNode splitNode2;
        while ((splitNode2 = splitNode.getParent()) != null && !this.layoutManager.model.isHeaderLevel(splitNode2, false)) {
            if (!(splitNode2 instanceof Node)) continue;
            Node node = (Node)splitNode2;
            SplitNode splitNode3 = splitNode2.getParent();
            if (splitNode3 instanceof Root) {
                node.setOrientation(this.side.getHeaderOrientation());
                return;
            }
            if (splitNode3 instanceof Node) {
                SplitNode splitNode4;
                Node node2 = (Node)splitNode3;
                if (node.getLeft() == splitNode) {
                    if (node2.getLeft() == node) {
                        node2.setLeft(splitNode);
                        splitNode4 = node2.getRight();
                        node2.setRight(node);
                        node.setLeft(splitNode4);
                    } else {
                        node.setLeft(node2.getLeft());
                        node2.setLeft(splitNode);
                    }
                } else if (node2.getRight() == node) {
                    node2.setRight(splitNode);
                    splitNode4 = node2.getLeft();
                    node2.setLeft(node);
                    node.setRight(splitNode4);
                } else {
                    node.setRight(node2.getRight());
                    node2.setRight(splitNode);
                }
                node.setOrientation(this.side.getColumnOrientation());
                node2.setOrientation(this.side.getHeaderOrientation());
            }
            splitNode = splitNode.getParent();
        }
        return;
    }

    public void resetToPreferredSizes() {
        this.layoutManager.model.resetToPreferredSizes();
    }

    private class WizardDividerStrategy
    extends DefaultSplitDividerStrategy {
        private WizardDividerStrategy() {
        }

        @Override
        protected DefaultSplitDividerStrategy.Handler createHandlerFor(SplitDockStation splitDockStation) {
            return new CustomHandler(splitDockStation);
        }

        private class CustomHandler
        extends DefaultSplitDividerStrategy.Handler {
            public CustomHandler(SplitDockStation splitDockStation) {
                super(splitDockStation);
            }

            @Override
            protected void setDivider(Divideable divideable, double d) {
                WizardSplitDockStation.this.layoutManager.setDivider(divideable, d);
            }

            @Override
            protected Divideable getDividerNode(int n, int n2) {
                Divideable divideable = super.getDividerNode(n, n2);
                if (divideable == null) {
                    int n3 = WizardSplitDockStation.this.getDividerSize();
                    if (WizardSplitDockStation.this.side == Side.RIGHT && n <= n3) {
                        return new ColumnDividier(WizardSplitDockStation.this);
                    }
                    if (WizardSplitDockStation.this.side == Side.LEFT && n >= WizardSplitDockStation.this.getWidth() - n3 - 1) {
                        return new ColumnDividier(WizardSplitDockStation.this);
                    }
                    if (WizardSplitDockStation.this.side == Side.TOP && n2 >= WizardSplitDockStation.this.getHeight() - n3 - 1) {
                        return new ColumnDividier(WizardSplitDockStation.this);
                    }
                    if (WizardSplitDockStation.this.side == Side.BOTTOM && n2 <= n3) {
                        return new ColumnDividier(WizardSplitDockStation.this);
                    }
                    Leaf leaf = WizardSplitDockStation.this.resizeableLeafAt(n, n2);
                    if (leaf != null) {
                        return new CellDivider(WizardSplitDockStation.this, leaf);
                    }
                }
                return divideable;
            }
        }
    }

    public class WizardLayoutManager
    extends DefaultSplitLayoutManager {
        private WizardColumnModel model;

        public WizardLayoutManager() {
            this.model = new WizardColumnModel(WizardSplitDockStation.this);
        }

        @Override
        public PutInfo validatePutInfo(SplitDockStation splitDockStation, PutInfo putInfo) {
            if ((putInfo = this.ensureDropLocation(putInfo)) != null) {
                return super.validatePutInfo(splitDockStation, putInfo);
            }
            return null;
        }

        public Leaf[] getLastLeafOfColumns() {
            return this.model.getLastLeafOfColumns();
        }

        @Override
        protected PutInfo calculateSideSnap(SplitDockStation splitDockStation, int n, int n2, Leaf leaf, Dockable dockable) {
            int n3;
            WizardSpanStrategy wizardSpanStrategy = WizardSplitDockStation.this.getWizardSpanStrategy();
            WizardLayoutManager wizardLayoutManager = WizardSplitDockStation.this.getWizardSplitLayoutManager();
            WizardNodeMap wizardNodeMap = wizardLayoutManager.getMap();
            WizardNodeMap.Column[] columnArray = wizardNodeMap.getSortedColumns();
            int n4 = wizardNodeMap.getColumnCount();
            int n5 = 0;
            int n6 = 0;
            if (n4 > 0) {
                n6 = n5 = wizardSpanStrategy.getGap(0);
                for (n3 = 1; n3 < n4; ++n3) {
                    n6 += wizardSpanStrategy.getGap(n3);
                }
            }
            if (WizardSplitDockStation.this.side.getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                for (n3 = 0; n3 < n4; ++n3) {
                    Rectangle rectangle = columnArray[n3].getBounds();
                    if (n < rectangle.x || n > rectangle.x + rectangle.width) continue;
                    if (n2 < rectangle.y) {
                        return new PutInfo(columnArray[n3].getRoot(), PutInfo.Put.TOP, dockable, false);
                    }
                    if (n2 > rectangle.y + rectangle.height) {
                        return new PutInfo(columnArray[n3].getRoot(), PutInfo.Put.BOTTOM, dockable, false);
                    }
                    if (n < rectangle.x + rectangle.width / 2) {
                        return new PutInfo(columnArray[n3].getRoot(), PutInfo.Put.LEFT, dockable, false);
                    }
                    return new PutInfo(columnArray[n3].getRoot(), PutInfo.Put.RIGHT, dockable, false);
                }
                n3 = WizardSplitDockStation.this.getWidth() - n6;
                if ((n -= n5) < n3 / 2) {
                    return new PutInfo(this.leftMost(WizardSplitDockStation.this.getRoot()), PutInfo.Put.LEFT, dockable, false);
                }
                return new PutInfo(this.rightMost(WizardSplitDockStation.this.getRoot()), PutInfo.Put.RIGHT, dockable, false);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                Rectangle rectangle = columnArray[n3].getBounds();
                if (n2 < rectangle.y || n2 > rectangle.y + rectangle.height) continue;
                if (n < rectangle.x) {
                    return new PutInfo(columnArray[n3].getRoot(), PutInfo.Put.LEFT, dockable, false);
                }
                if (n > rectangle.x + rectangle.width) {
                    return new PutInfo(columnArray[n3].getRoot(), PutInfo.Put.RIGHT, dockable, false);
                }
                if (n2 < rectangle.y + rectangle.height / 2) {
                    return new PutInfo(columnArray[n3].getRoot(), PutInfo.Put.TOP, dockable, false);
                }
                return new PutInfo(columnArray[n3].getRoot(), PutInfo.Put.BOTTOM, dockable, false);
            }
            n3 = WizardSplitDockStation.this.getHeight() - n6;
            if ((n2 -= n5) < n3 / 2) {
                return new PutInfo(this.leftMost(WizardSplitDockStation.this.getRoot()), PutInfo.Put.TOP, dockable, false);
            }
            return new PutInfo(this.rightMost(WizardSplitDockStation.this.getRoot()), PutInfo.Put.BOTTOM, dockable, false);
        }

        private SplitNode leftMost(SplitNode splitNode) {
            while (splitNode.getMaxChildrenCount() > 0) {
                splitNode = splitNode.getChild(0);
            }
            return splitNode;
        }

        private SplitNode rightMost(SplitNode splitNode) {
            int n;
            while ((n = splitNode.getMaxChildrenCount()) > 0) {
                splitNode = splitNode.getChild(n - 1);
            }
            return splitNode;
        }

        private PutInfo ensureDropLocation(PutInfo putInfo) {
            if (putInfo != null) {
                boolean bl;
                if (WizardSplitDockStation.this.side.getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                    bl = putInfo.getPut() == PutInfo.Put.LEFT || putInfo.getPut() == PutInfo.Put.RIGHT;
                } else {
                    boolean bl2 = bl = putInfo.getPut() == PutInfo.Put.TOP || putInfo.getPut() == PutInfo.Put.BOTTOM;
                }
                if (bl) {
                    SplitNode splitNode;
                    boolean bl3;
                    int n = this.getMap().getColumnCount();
                    boolean bl4 = bl3 = WizardSplitDockStation.this.maxColumnCount == -1 || n < WizardSplitDockStation.this.maxColumnCount;
                    if (!bl3) {
                        return null;
                    }
                    for (splitNode = putInfo.getNode(); splitNode != null && !this.model.isHeaderLevel(splitNode); splitNode = splitNode.getParent()) {
                    }
                    putInfo.setNode(splitNode);
                }
            }
            return putInfo;
        }

        @Override
        public void updateBounds(Root root, double d, double d2, double d3, double d4) {
            this.model.setFactors(d3, d4);
            this.model.updateBounds(d, d2);
        }

        @Override
        public double validateDivider(SplitDockStation splitDockStation, double d, Node node) {
            return this.model.validateDivider(d, node);
        }

        public double validateDivider(double d, Leaf leaf) {
            return this.model.validateDivider(d, leaf);
        }

        public double validateColumnDivider(double d) {
            return this.model.validateColumnDivider(d);
        }

        public Dimension getPreferredSize() {
            return this.model.getPreferredSize();
        }

        public void setDivider(Divideable divideable, double d) {
            this.model.setDivider(divideable, d);
            WizardSplitDockStation.this.revalidate();
        }

        public WizardNodeMap getMap() {
            return this.model.getMap();
        }
    }

    public static enum Side {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;


        public SplitDockStation.Orientation getHeaderOrientation() {
            switch (this) {
                case LEFT: 
                case RIGHT: {
                    return SplitDockStation.Orientation.HORIZONTAL;
                }
                case TOP: 
                case BOTTOM: {
                    return SplitDockStation.Orientation.VERTICAL;
                }
            }
            throw new IllegalStateException("unknown: " + (Object)((Object)this));
        }

        public SplitDockStation.Orientation getColumnOrientation() {
            switch (this) {
                case LEFT: 
                case RIGHT: {
                    return SplitDockStation.Orientation.VERTICAL;
                }
                case TOP: 
                case BOTTOM: {
                    return SplitDockStation.Orientation.HORIZONTAL;
                }
            }
            throw new IllegalStateException("unknown: " + (Object)((Object)this));
        }
    }
}

