/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.SceneGraphIO;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SGIORuntimeException;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;

public abstract class SceneGraphObjectState {
    protected SceneGraphObject node;
    protected SymbolTableData symbol;
    protected Controller control;
    protected String nodeClassName;

    public SceneGraphObjectState(SymbolTableData symbol, Controller control) {
        this.symbol = symbol;
        this.control = control;
        if (symbol != null) {
            this.node = symbol.j3dNode;
        }
        if (this.node != null) {
            this.nodeClassName = this.node.getClass().getName();
            try {
                if (this.node instanceof SceneGraphIO) {
                    ((SceneGraphIO)this.node).createSceneGraphObjectReferences(control.getSymbolTable());
                }
            }
            catch (Exception e) {
                System.err.println("Exception in createSceneGraphObjectReferences");
                e.printStackTrace();
            }
        }
    }

    public void writeObject(DataOutput out) throws IOException {
        boolean sgIO = this.node instanceof SceneGraphIO;
        out.writeBoolean(sgIO);
        out.writeInt(this.symbol.nodeID);
        int nodeClassID = this.control.getNodeClassID(this.node);
        out.writeShort(nodeClassID);
        if (nodeClassID == -1) {
            out.writeUTF(this.nodeClassName);
        }
        this.writeConstructorParams(out);
        if (sgIO) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream tmpOut = new DataOutputStream(byteStream);
            ((SceneGraphIO)this.node).writeSceneGraphObject(tmpOut);
            tmpOut.close();
            out.writeInt(byteStream.size());
            out.write(byteStream.toByteArray());
        }
        this.writeUserData(out);
        this.writeString(this.node.getName(), out);
        this.writeCapabilities(out);
    }

    public void readObject(DataInput in) throws IOException {
        boolean sgIO = in.readBoolean();
        int nodeID = in.readInt();
        short nodeClassID = in.readShort();
        this.nodeClassName = null;
        if (nodeClassID == -1) {
            this.nodeClassName = in.readUTF();
        }
        this.readConstructorParams(in);
        if (nodeClassID != -1) {
            this.node = this.createNode();
            this.nodeClassName = this.node.getClass().getName();
        } else {
            this.node = this.createNode(this.nodeClassName);
        }
        if (sgIO) {
            if (this.control.getCurrentFileVersion() == 1) {
                ((SceneGraphIO)this.node).readSceneGraphObject(in);
            } else {
                int size = in.readInt();
                if (this.node instanceof SceneGraphIO) {
                    byte[] bytes = new byte[size];
                    in.readFully(bytes);
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
                    DataInputStream tmpIn = new DataInputStream(byteStream);
                    ((SceneGraphIO)this.node).readSceneGraphObject(tmpIn);
                    tmpIn.close();
                } else {
                    in.skipBytes(size);
                }
            }
        }
        this.symbol = this.control.getSymbolTable().createSymbol(this, this.node, nodeID);
        this.readUserData(in);
        if (this.control.getCurrentFileVersion() > 2) {
            this.node.setName(this.readString(in));
        }
        this.readCapabilities(in);
    }

    public SceneGraphObject getNode() {
        return this.node;
    }

    public int getNodeID() {
        return this.symbol.nodeID;
    }

    public SymbolTableData getSymbol() {
        return this.symbol;
    }

    private void readUserData(DataInput in) throws IOException {
        this.node.setUserData(this.control.readSerializedData(in));
    }

    private void writeUserData(DataOutput out) throws IOException {
        Object obj = this.node.getUserData();
        if (obj != null && !(obj instanceof Serializable)) {
            System.err.println("UserData is not Serializable and will not be saved");
            obj = null;
        }
        this.control.writeSerializedData(out, (Serializable)obj);
    }

    private void writeCapabilities(DataOutput out) throws IOException {
        long capabilities = 0L;
        long frequentCapabilities = 0L;
        int i = 0;
        while (i < 64) {
            if (this.node.getCapability(i)) {
                capabilities |= 1L << i;
            }
            if (!this.node.getCapabilityIsFrequent(i)) {
                frequentCapabilities |= 1L << i;
            }
            ++i;
        }
        out.writeLong(capabilities);
        out.writeLong(frequentCapabilities);
    }

    private void readCapabilities(DataInput in) throws IOException {
        long capabilities = in.readLong();
        long frequentCapabilities = in.readLong();
        int i = 0;
        while (i < 64) {
            if ((capabilities & 1L << i) != 0L) {
                this.node.setCapability(i);
            }
            if ((frequentCapabilities & 1L << i) != 0L) {
                this.node.clearCapabilityIsFrequent(i);
            }
            ++i;
        }
    }

    protected void writeConstructorParams(DataOutput out) throws IOException {
    }

    protected void readConstructorParams(DataInput in) throws IOException {
    }

    protected SceneGraphObject createNode() {
        throw new SGIORuntimeException("createNode() not implemented in class " + this.getClass().getName());
    }

    protected SceneGraphObject createNode(Class state) {
        SceneGraphObject ret;
        try {
            ret = (SceneGraphObject)state.newInstance();
        }
        catch (IllegalAccessException exce) {
            throw new SGIORuntimeException("Broken State class for " + state.getClass().getName() + " - IllegalAccess");
        }
        catch (InstantiationException excep) {
            throw new SGIORuntimeException("Broken State class for " + state.getClass().getName());
        }
        return ret;
    }

    protected SceneGraphObject createNode(String className) {
        SceneGraphObject ret;
        try {
            Class<?> state = Class.forName(className, true, this.control.getClassLoader());
            ret = this.createNode(state);
        }
        catch (ClassNotFoundException e) {
            if (this.control.useSuperClassIfNoChildClass()) {
                ret = this.createNodeFromSuper(className);
            }
            throw new SGIORuntimeException("No Such Class " + className);
        }
        return ret;
    }

    private SceneGraphObject createNodeFromSuper(String className) {
        SceneGraphObject ret;
        String tmp = this.getClass().getName();
        String superClass = tmp.substring(tmp.indexOf("state") + 6, tmp.length() - 5);
        System.err.println("Unable to create node " + className + " attempting Java3D superclass " + superClass);
        try {
            Class<?> state = Class.forName(superClass);
            ret = (SceneGraphObject)state.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SGIORuntimeException("No Such Class " + className);
        }
        catch (IllegalAccessException exce) {
            throw new SGIORuntimeException("Broken State class for " + className + " - IllegalAccess");
        }
        catch (InstantiationException excep) {
            throw new SGIORuntimeException("Unable to instantiate class " + className);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private SceneGraphObject createNode(String className, Class[] parameterTypes, Object[] parameters) {
        block8: {
            try {
                state = Class.forName(className);
                constructor = state.getConstructor(parameterTypes);
                ret = (SceneGraphObject)constructor.newInstance(parameters);
                break block8;
            }
            catch (ClassNotFoundException e1) {
                if (this.control.useSuperClassIfNoChildClass()) {
                    ret = this.createNodeFromSuper(className, parameterTypes, parameters);
                    break block8;
                }
                throw new SGIORuntimeException("No State class for " + className);
            }
            catch (IllegalAccessException e2) {
                throw new SGIORuntimeException("Broken State class for " + className + " - IllegalAccess");
            }
            catch (InstantiationException e3) {
                throw new SGIORuntimeException("Broken State class for " + className);
            }
            catch (InvocationTargetException e4) {
                throw new SGIORuntimeException("InvocationTargetException for " + className);
            }
            catch (NoSuchMethodException e5) {
                i = 0;
                ** while (i < parameterTypes.length)
            }
lbl-1000:
            // 1 sources

            {
                System.err.println(parameterTypes[i].getName());
                ++i;
                continue;
            }
lbl23:
            // 1 sources

            System.err.println("------");
            throw new SGIORuntimeException("Invalid constructor for " + className);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    protected SceneGraphObject createNode(Class j3dClass, Class[] parameterTypes, Object[] parameters) {
        block6: {
            try {
                constructor = j3dClass.getConstructor(parameterTypes);
                ret = (SceneGraphObject)constructor.newInstance(parameters);
                break block6;
            }
            catch (IllegalAccessException e2) {
                throw new SGIORuntimeException("Broken State class for " + j3dClass.getClass().getName() + " - IllegalAccess");
            }
            catch (InstantiationException e3) {
                throw new SGIORuntimeException("Broken State class for " + j3dClass.getClass().getName());
            }
            catch (InvocationTargetException e4) {
                throw new SGIORuntimeException("InvocationTargetException for " + j3dClass.getClass().getName());
            }
            catch (NoSuchMethodException e5) {
                i = 0;
                ** while (i < parameterTypes.length)
            }
lbl-1000:
            // 1 sources

            {
                System.err.println(parameterTypes[i].getName());
                ++i;
                continue;
            }
lbl17:
            // 1 sources

            System.err.println("------");
            throw new SGIORuntimeException("Invalid constructor for " + j3dClass.getClass().getName());
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private SceneGraphObject createNodeFromSuper(String className, Class[] parameterTypes, Object[] parameters) {
        block7: {
            tmp = this.getClass().getName();
            superClass = tmp.substring(tmp.indexOf("state") + 6, tmp.length() - 5);
            try {
                state = Class.forName(superClass);
                constructor = state.getConstructor(parameterTypes);
                ret = (SceneGraphObject)constructor.newInstance(parameters);
                break block7;
            }
            catch (ClassNotFoundException e1) {
                throw new SGIORuntimeException("No State class for " + superClass);
            }
            catch (IllegalAccessException e2) {
                throw new SGIORuntimeException("Broken State class for " + className + " - IllegalAccess");
            }
            catch (InstantiationException e3) {
                throw new SGIORuntimeException("Broken State class for " + className);
            }
            catch (InvocationTargetException e4) {
                throw new SGIORuntimeException("InvocationTargetException for " + className);
            }
            catch (NoSuchMethodException e5) {
                i = 0;
                ** while (i < parameterTypes.length)
            }
lbl-1000:
            // 1 sources

            {
                System.err.println(parameterTypes[i].getName());
                ++i;
                continue;
            }
lbl22:
            // 1 sources

            System.err.println("------");
            throw new SGIORuntimeException("Invalid constructor for " + className);
        }
        return ret;
    }

    protected SceneGraphObjectState createState(SceneGraphObject obj, Controller control) {
        return control.createState(obj);
    }

    private String getClassName(Class c) {
        return c.getName().substring(c.getName().lastIndexOf(46) + 1);
    }

    public void buildGraph() {
        if (this.node instanceof SceneGraphIO) {
            ((SceneGraphIO)this.node).restoreSceneGraphObjectReferences(this.control.getSymbolTable());
        }
    }

    public void cleanup() {
        this.control = null;
        this.node = null;
    }

    protected String readString(DataInput in) throws IOException {
        if (in.readBoolean()) {
            return in.readUTF();
        }
        return null;
    }

    protected void writeString(String str, DataOutput out) throws IOException {
        out.writeBoolean(str != null);
        if (str != null) {
            out.writeUTF(str);
        }
    }
}

