/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.toolbar.group.ColumnScrollBar;
import bibliothek.gui.dock.station.toolbar.group.ColumnScrollBarFactory;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SlimScrollbar
extends JComponent
implements ColumnScrollBar,
Adjustable {
    private BoundedRangeModel model;
    private Orientation orientation = Orientation.HORIZONTAL;
    private List<AdjustmentListener> listeners = new ArrayList<AdjustmentListener>();
    private boolean hover = false;
    private boolean mousePressed = false;
    private float mouseOffset = 0.0f;
    public static final ColumnScrollBarFactory FACTORY = new ColumnScrollBarFactory(){

        @Override
        public ColumnScrollBar create(ToolbarGroupDockStation toolbarGroupDockStation) {
            return new SlimScrollbar();
        }
    };

    public SlimScrollbar() {
        this.model = new DefaultBoundedRangeModel(0, 0, 0, 1);
        this.model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AdjustmentEvent adjustmentEvent = new AdjustmentEvent(SlimScrollbar.this, 0, 0, SlimScrollbar.this.getValue());
                for (AdjustmentListener adjustmentListener : SlimScrollbar.this.listeners) {
                    adjustmentListener.adjustmentValueChanged(adjustmentEvent);
                }
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SlimScrollbar.this.onMouseEvent(mouseEvent, true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                SlimScrollbar.this.mousePressed = (mouseEvent.getModifiersEx() & 0x1C00) != 0;
                SlimScrollbar.this.onMouseEvent(mouseEvent, false);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                SlimScrollbar.this.onMouseEvent(mouseEvent, true);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                SlimScrollbar.this.onMouseEvent(mouseEvent, false);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                SlimScrollbar.this.hover = false;
                SlimScrollbar.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                SlimScrollbar.this.onMouseEvent(mouseEvent, false);
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    private void onMouseEvent(MouseEvent mouseEvent, boolean bl) {
        int n = this.model.getValue();
        int n2 = this.getThumbSize();
        float f = this.getTrack();
        int n3 = this.orientation == Orientation.HORIZONTAL ? mouseEvent.getX() : mouseEvent.getY();
        if (f > 0.0f) {
            float f2 = this.model.getMaximum() - this.model.getMinimum();
            float f3 = f2 / f;
            if (bl && !this.mousePressed) {
                this.mouseOffset = n3 - this.getThumbStart();
                if (this.mouseOffset < 0.0f || this.mouseOffset >= (float)n2) {
                    this.mouseOffset = n2 / 2;
                }
                this.mousePressed = true;
            }
            if (bl && this.mousePressed) {
                this.setValue((int)(((float)n3 - this.mouseOffset) * f3));
            }
        }
        this.hover = bl ? true : (this.contains(mouseEvent.getPoint()) ? n <= n3 && n3 <= n + n2 : false);
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(6, 6);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(6, 6);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getThumbStart();
        int n2 = this.getThumbSize();
        Rectangle2D.Double double_ = null;
        if (this.hover) {
            if (this.orientation == Orientation.HORIZONTAL) {
                graphics2D.setPaint(new GradientPaint(new Point(n, 0), new Color(240, 240, 240), new Point(n, 6), new Color(160, 160, 160)));
                double_ = new Rectangle2D.Double(n, 0.0, n2, 6.0);
            } else {
                graphics2D.setPaint(new GradientPaint(new Point(0, n), new Color(240, 240, 240), new Point(6, n), new Color(160, 160, 160)));
                double_ = new Rectangle2D.Double(0.0, n, 6.0, n2);
            }
        } else if (this.orientation == Orientation.HORIZONTAL) {
            graphics2D.setPaint(new GradientPaint(new Point(n, 0), new Color(210, 210, 210), new Point(n, 6), new Color(120, 120, 120)));
            double_ = new Rectangle2D.Double(n, 0.0, n2, 6.0);
        } else {
            graphics2D.setPaint(new GradientPaint(new Point(0, n), new Color(210, 210, 210), new Point(6, n), new Color(120, 120, 120)));
            double_ = new Rectangle2D.Double(0.0, n, 6.0, n2);
        }
        graphics2D.fill(double_);
    }

    private int getThumbStart() {
        float f = this.model.getMaximum() - this.model.getMinimum();
        float f2 = this.getTrack();
        return (int)((float)this.model.getValue() * (f2 / f));
    }

    private int getThumbSize() {
        float f = this.model.getMaximum() - this.model.getMinimum();
        float f2 = this.model.getExtent();
        float f3 = this.getTrack();
        int n = (int)(f3 * (f2 / f));
        n = Math.max(n, 20);
        n = Math.min(n, (int)f3);
        return n;
    }

    private int getTrack() {
        if (this.orientation == Orientation.HORIZONTAL) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    @Override
    public void setValues(int n, int n2) {
        this.model.setMaximum(n);
        this.model.setExtent(n2);
    }

    @Override
    public int getValue() {
        return this.model.getValue();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.revalidate();
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listeners.add(adjustmentListener);
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listeners.remove(adjustmentListener);
    }

    @Override
    public int getOrientation() {
        if (this.orientation == Orientation.HORIZONTAL) {
            return 0;
        }
        return 1;
    }

    @Override
    public void setMinimum(int n) {
        this.model.setMinimum(n);
    }

    @Override
    public int getMinimum() {
        return this.model.getMinimum();
    }

    @Override
    public void setMaximum(int n) {
        this.model.setMaximum(n);
    }

    @Override
    public int getMaximum() {
        return this.model.getMaximum();
    }

    @Override
    public void setUnitIncrement(int n) {
    }

    @Override
    public int getUnitIncrement() {
        return 0;
    }

    @Override
    public void setBlockIncrement(int n) {
    }

    @Override
    public int getBlockIncrement() {
        return 0;
    }

    @Override
    public void setVisibleAmount(int n) {
    }

    @Override
    public int getVisibleAmount() {
        return 0;
    }

    @Override
    public void setValue(int n) {
        this.model.setValue(n);
    }
}

