/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.gui.dock.station.toolbar.layout.GridPlaceholderList;
import bibliothek.gui.dock.station.toolbar.layout.PlaceholderToolbarGridConverter;
import bibliothek.gui.dock.station.toolbar.layout.grid.Column;
import bibliothek.gui.dock.station.toolbar.layout.grid.ColumnItem;
import bibliothek.util.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class PlaceholderToolbarGrid<D, S, P extends PlaceholderListItem<D>> {
    private GridPlaceholderList<D, S, P> columns;
    private PlaceholderStrategy strategy;
    private final PlaceholderStrategyListener strategyListener = new PlaceholderStrategyListener(){

        @Override
        public void placeholderInvalidated(Set<Path> set) {
            PlaceholderToolbarGrid.this.purge();
        }
    };
    private boolean bound = false;

    protected void init() {
        this.columns = this.createGrid();
    }

    protected abstract PlaceholderList<D, S, P> createColumn();

    protected abstract GridPlaceholderList<D, S, P> createGrid();

    protected abstract Set<Path> getPlaceholders(D var1);

    protected abstract void onInserted(PlaceholderList<D, S, P> var1, int var2, P var3, int var4);

    protected abstract void onRemoved(PlaceholderList<D, S, P> var1, int var2, P var3, int var4);

    protected abstract void onInserted(PlaceholderList<D, S, P> var1, int var2);

    protected abstract void onRemoved(PlaceholderList<D, S, P> var1, int var2);

    protected abstract void onInserted();

    protected abstract void onRemoved();

    public void clear() {
        this.purge();
        for (Column column : this.columns.dockables()) {
            column.getList().unbind();
            column.getList().setStrategy(null);
        }
        this.columns.clear();
        this.onRemoved();
    }

    public void insert(int n, int n2, P p) {
        if (p == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        PlaceholderList<D, S, P> placeholderList = this.getColumn(n);
        if (placeholderList == null) {
            this.insert(n, p, true);
        } else {
            int n3 = Math.min(n2, placeholderList.dockables().size());
            placeholderList.dockables().add(n3, p);
            this.ensureRemoved(placeholderList, p);
            this.onInserted(placeholderList, n, p, n3);
        }
    }

    public void insert(int n, P p) {
        this.insert(n, p, true);
    }

    public void insert(int n, P p, boolean bl) {
        int n2;
        PlaceholderList<D, S, P> placeholderList = this.createColumn();
        Column<D, S, P> column = this.columns.createColumn(placeholderList);
        boolean bl2 = false;
        int n3 = -1;
        if (bl) {
            PlaceholderList.Item item;
            if (this.columns.dockables().size() > 0) {
                n2 = this.columns.levelToBase(Math.max(0, Math.min(this.columns.dockables().size() - 1, n)), PlaceholderList.Level.DOCKABLE);
                --n2;
            } else {
                n2 = 0;
            }
            if (n2 >= 0 && n2 < this.columns.list().size() && (item = this.columns.list().get(n2)).getDockable() == null) {
                PlaceholderMap placeholderMap = item.getPlaceholderMap();
                if (placeholderMap != null) {
                    placeholderList.read(placeholderMap, this.columns.getConverter());
                }
                item.setDockable(column);
                n3 = this.columns.dockables().indexOf(column);
                this.onInserted(column.getList(), n3);
                bl2 = true;
            }
        }
        placeholderList.dockables().add(p);
        if (bl2) {
            this.onInserted(placeholderList, n3, p, placeholderList.dockables().size() - 1);
        } else {
            n2 = Math.max(0, Math.min(n, this.columns.dockables().size()));
            this.columns.dockables().add(n2, column);
            this.onInserted(placeholderList, n2);
            this.onInserted(placeholderList, n2, p, placeholderList.dockables().size() - 1);
        }
        if (this.bound) {
            placeholderList.setStrategy(this.strategy);
        }
        this.ensureRemoved(placeholderList, p);
    }

    public void move(int n, int n2, int n3, int n4, PlaceholderList.Level level) {
        Object object;
        PlaceholderList<D, S, P> placeholderList;
        PlaceholderList placeholderList2 = ((Column)this.columns.dockables().get(n)).getList();
        PlaceholderList.Filter filter = placeholderList2.dockables();
        int n5 = -1;
        if (n3 == this.columns.size(level)) {
            n3 = this.columns.size(PlaceholderList.Level.BASE);
        } else if (n3 >= 0) {
            n3 = this.columns.levelToBase(n3, level);
        }
        if (n2 < 0 || n2 >= filter.size()) {
            throw new IllegalArgumentException("sourceLine out of bounds: " + n2);
        }
        if (n3 < -1 || n3 > this.columns.list().size()) {
            throw new IllegalArgumentException("destinationColumn out of bounds: " + n3);
        }
        PlaceholderListItem placeholderListItem = (PlaceholderListItem)filter.get(n2);
        if (n3 == -1 || n3 == this.columns.list().size()) {
            placeholderList = this.createColumn();
            if (n4 != 0) {
                throw new IllegalArgumentException("destinationLine is out of bounds: " + n4);
            }
            GridPlaceholderList<D, S, P> gridPlaceholderList = this.columns;
            gridPlaceholderList.getClass();
            object = new PlaceholderList.Item(gridPlaceholderList, this.columns.createColumn(placeholderList));
            if (n3 == -1) {
                this.columns.list().add(0, (PlaceholderList.Item)object);
            } else {
                this.columns.list().add((PlaceholderList.Item)object);
            }
            n5 = this.columns.dockables().indexOf(((PlaceholderList.Item)object).getDockable());
            this.onInserted(placeholderList, n5);
        } else {
            object = this.columns.list().get(n3);
            if (((PlaceholderList.Item)object).getDockable() == null) {
                placeholderList = this.createColumn();
                if (n4 != 0) {
                    throw new IllegalArgumentException("destinationLine is out of bounds: " + n4);
                }
                ((PlaceholderList.Item)object).setDockable(this.columns.createColumn(placeholderList));
                n5 = this.columns.dockables().indexOf(((PlaceholderList.Item)object).getDockable());
                this.onInserted(placeholderList, n5);
            } else {
                placeholderList = ((Column)((PlaceholderList.Item)object).getDockable()).getList();
                if (n4 < 0 || n4 > placeholderList.dockables().size()) {
                    throw new IllegalArgumentException("destinationLine out of bounds: " + n4);
                }
                n5 = this.columns.baseToLevel(n3, PlaceholderList.Level.DOCKABLE);
            }
        }
        object = (PlaceholderListItem)filter.get(n2);
        placeholderList.dockables().move(filter, n2, n4);
        this.ensureRemoved(placeholderList, placeholderListItem);
        this.onRemoved(placeholderList2, n, object, n2);
        this.onInserted(placeholderList, n5, object, n4);
        this.purge();
    }

    public boolean put(Path path, P p) {
        PlaceholderMap placeholderMap;
        int n = this.columns.getListIndex(path);
        if (n == -1) {
            return false;
        }
        PlaceholderList.Item item = this.columns.list().get(n);
        Column<D, S, P> column = (Column<D, S, P>)item.getDockable();
        if (column != null) {
            int n2 = this.columns.dockables().indexOf(column);
            int n3 = column.getList().getListIndex(path);
            if (n3 >= 0) {
                Object p2 = column.getList().list().get(n3).getDockable();
                int n4 = column.getList().dockables().size();
                int n5 = column.getList().put(path, p);
                if (p2 != null) {
                    this.onRemoved(column.getList(), n2, p2, n5);
                    if (n4 == 0 && p == null) {
                        this.onRemoved(column.getList(), n2);
                        item.setDockable(null);
                    }
                }
                if (p != null) {
                    if (n4 == 0) {
                        this.onInserted(column.getList(), n2);
                    }
                    this.onInserted(column.getList(), n2, p, column.getList().dockables().indexOf(p));
                }
                return true;
            }
        }
        if ((placeholderMap = item.getPlaceholderMap()) != null) {
            PlaceholderList<D, S, P> placeholderList = this.createColumn();
            placeholderList.read(placeholderMap, this.columns.getConverter());
            column = this.columns.createColumn(placeholderList);
            item.setDockable(column);
            int n6 = this.columns.dockables().indexOf(column);
            this.onInserted(placeholderList, n6);
            int n7 = column.getList().put(path, p);
            if (n7 == -1) {
                item.setDockable(null);
                this.onRemoved(placeholderList, n6);
                return false;
            }
            item.setPlaceholderMap(null);
            this.ensureRemoved(placeholderList, path);
            this.onInserted(placeholderList, n6, p, n7);
            return true;
        }
        return false;
    }

    public void addPlaceholder(int n, int n2, Path path) {
        this.columns.dockables().addPlaceholder(n, path);
        Column column = (Column)this.columns.dockables().get(n);
        column.getList().dockables().addPlaceholder(n2, path);
        this.ensureRemoved(column.getList(), path);
    }

    public void insertPlaceholder(int n, int n2, Path path) {
        PlaceholderList.Filter<PlaceholderList.Item> filter;
        if (n == this.columns.list().size()) {
            this.columns.list().insertPlaceholder(n, path);
        } else {
            this.columns.list().addPlaceholder(n, path);
        }
        PlaceholderList.Item item = this.columns.list().get(n);
        if (item.getDockable() == null) {
            item.setDockable(this.columns.createColumn(this.createColumn()));
        }
        if (n2 == (filter = ((Column)item.getDockable()).getList().list()).size()) {
            filter.insertPlaceholder(n2, path);
        } else {
            filter.addPlaceholder(n2, path);
        }
    }

    public boolean remove(P p) {
        boolean bl = false;
        int n = -1;
        for (Column column : this.columns.dockables()) {
            ++n;
            int n2 = column.getList().dockables().indexOf(p);
            if (n2 < 0) continue;
            column.getList().remove(p);
            this.onRemoved(column.getList(), n, p, n2);
            bl = true;
        }
        this.purge();
        return bl;
    }

    public void removePlaceholder(Path path) {
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        this.ensureRemoved((PlaceholderList<D, S, P>)null, (Set<Path>)hashSet);
    }

    private void ensureRemoved(PlaceholderList<D, S, P> placeholderList, P p) {
        Set<Path> set = this.getPlaceholders(p.asDockable());
        this.ensureRemoved(placeholderList, set);
    }

    private void ensureRemoved(PlaceholderList<D, S, P> placeholderList, Path path) {
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        this.ensureRemoved(placeholderList, (Set<Path>)hashSet);
    }

    private void ensureRemoved(PlaceholderList<D, S, P> placeholderList, Set<Path> set) {
        Iterator iterator = this.columns.list().iterator();
        while (iterator.hasNext()) {
            PlaceholderList.Item item = (PlaceholderList.Item)iterator.next();
            if (item.getDockable() != null && ((Column)item.getDockable()).getList() == placeholderList) continue;
            item.removeAll(set);
            if (item.getPlaceholderSet() != null || !item.isPlaceholder()) continue;
            iterator.remove();
        }
        for (Column column : this.columns.dockables()) {
            if (column.getList() == placeholderList) continue;
            column.getList().removeAll(set);
        }
        this.purge();
    }

    public int getColumn(D d) {
        int n = 0;
        Iterator<PlaceholderList<D, S, P>> iterator = this.columns();
        while (iterator.hasNext()) {
            for (PlaceholderListItem placeholderListItem : iterator.next().dockables()) {
                if (placeholderListItem.asDockable() != d) continue;
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getColumn(Path path) {
        int n = 0;
        for (PlaceholderList.Item item : this.columns.list()) {
            if (item.hasPlaceholder(path)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getLine(D d) {
        int n = this.getColumn(d);
        if (n == -1) {
            return -1;
        }
        return this.getLine(n, d);
    }

    public int getLine(int n, D d) {
        PlaceholderList<D, S, P> placeholderList = this.getColumn(n);
        int n2 = 0;
        for (PlaceholderListItem placeholderListItem : placeholderList.dockables()) {
            if (placeholderListItem.asDockable() == d) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getLine(Path path) {
        int n = this.getColumn(path);
        if (n == -1) {
            return -1;
        }
        return this.getLine(n, path);
    }

    public int getLine(int n, Path path) {
        PlaceholderList.Item item = this.columns.list().get(n);
        if (item.getDockable() == null) {
            if (item.hasPlaceholder(path)) {
                return 0;
            }
            return -1;
        }
        return ((Column)item.getDockable()).getList().list().indexOfPlaceholder(path);
    }

    public boolean hasPlaceholder(Path path) {
        int n = this.columns.getListIndex(path);
        if (n == -1) {
            return false;
        }
        PlaceholderList.Item item = this.columns.list().get(n);
        Column column = (Column)item.getDockable();
        if (column != null) {
            return column.getList().hasPlaceholder(path);
        }
        PlaceholderMap placeholderMap = item.getPlaceholderMap();
        if (placeholderMap != null) {
            for (PlaceholderMap.Key key : placeholderMap.getPlaceholders()) {
                if (!key.contains(path)) continue;
                return true;
            }
        }
        return false;
    }

    public int size() {
        int n = 0;
        Iterator<PlaceholderList<D, S, P>> iterator = this.columns();
        while (iterator.hasNext()) {
            n += iterator.next().dockables().size();
        }
        return n;
    }

    public P get(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index must not be < 0");
        }
        Iterator<PlaceholderList<D, S, P>> iterator = this.columns();
        while (iterator.hasNext()) {
            PlaceholderList.Filter<P> filter = iterator.next().dockables();
            int n2 = filter.size();
            if (n < n2) {
                return (P)((PlaceholderListItem)filter.get(n));
            }
            n -= n2;
        }
        throw new IllegalArgumentException("index must not be >= size");
    }

    public P get(D d) {
        Iterator<P> iterator = this.items();
        while (iterator.hasNext()) {
            PlaceholderListItem placeholderListItem = (PlaceholderListItem)iterator.next();
            if (placeholderListItem.asDockable() != d) continue;
            return (P)placeholderListItem;
        }
        return null;
    }

    public P get(Path path) {
        int n = this.columns.getListIndex(path);
        if (n == -1) {
            return null;
        }
        PlaceholderList.Item item = this.columns.list().get(n);
        Column column = (Column)item.getDockable();
        if (column == null) {
            return null;
        }
        return column.getList().getDockableAt(path);
    }

    protected Iterator<PlaceholderList<D, S, P>> allColumns() {
        return new Iterator<PlaceholderList<D, S, P>>(){
            private final Iterator<Column<D, S, P>> items;
            private PlaceholderList<D, S, P> current;
            private int currentIndex;
            {
                this.items = PlaceholderToolbarGrid.this.columns.dockables().iterator();
                this.currentIndex = -1;
            }

            @Override
            public boolean hasNext() {
                return this.items.hasNext();
            }

            @Override
            public PlaceholderList<D, S, P> next() {
                this.current = this.items.next().getList();
                ++this.currentIndex;
                return this.current;
            }

            @Override
            public void remove() {
                this.items.remove();
                PlaceholderToolbarGrid.this.onRemoved(this.current, this.currentIndex--);
            }
        };
    }

    protected Iterator<PlaceholderList<D, S, P>> columns() {
        return new Iterator<PlaceholderList<D, S, P>>(){
            private final Iterator<Column<D, S, P>> items;
            private PlaceholderList<D, S, P> next;
            {
                this.items = PlaceholderToolbarGrid.this.columns.dockables().iterator();
            }

            private void forward() {
                this.next = null;
                while (this.next == null && this.items.hasNext()) {
                    PlaceholderList placeholderList = this.items.next().getList();
                    if (placeholderList.dockables().size() <= 0) continue;
                    this.next = placeholderList;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null && this.items.hasNext()) {
                    this.forward();
                }
                return this.next != null;
            }

            @Override
            public PlaceholderList<D, S, P> next() {
                PlaceholderList placeholderList = this.next;
                this.forward();
                return placeholderList;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<P> items() {
        return new Iterator<P>(){
            private final Iterator<PlaceholderList<D, S, P>> columns;
            private Iterator<P> items;
            private PlaceholderList<D, S, P> currentList;
            private int currentListIndex;
            private P currentItem;
            private int currentItemIndex;
            private boolean requiresdPurge;
            {
                this.columns = PlaceholderToolbarGrid.this.columns();
                this.items = null;
                this.currentListIndex = -1;
                this.currentItemIndex = -1;
                this.requiresdPurge = false;
            }

            private void validate() {
                while ((this.items == null || !this.items.hasNext()) && this.columns.hasNext()) {
                    this.currentList = this.columns.next();
                    this.currentItemIndex = -1;
                    ++this.currentListIndex;
                    this.items = this.currentList.dockables().iterator();
                }
            }

            @Override
            public boolean hasNext() {
                boolean bl;
                this.validate();
                boolean bl2 = bl = this.items != null && this.items.hasNext();
                if (!bl && this.requiresdPurge) {
                    PlaceholderToolbarGrid.this.purge();
                    this.requiresdPurge = false;
                }
                return bl;
            }

            @Override
            public P next() {
                this.validate();
                this.currentItem = (PlaceholderListItem)this.items.next();
                return this.currentItem;
            }

            @Override
            public void remove() {
                if (this.items == null) {
                    throw new IllegalStateException("no item selected");
                }
                this.items.remove();
                PlaceholderToolbarGrid.this.onRemoved(this.currentList, this.currentListIndex, this.currentItem, this.currentItemIndex--);
                this.requiresdPurge = true;
            }
        };
    }

    public int getColumnCount() {
        return this.columns.dockables().size();
    }

    public int getLineCount(int n) {
        return ((Column)this.columns.dockables().get(n)).getList().dockables().size();
    }

    public int getTotalColumnCount() {
        return this.columns.list().size();
    }

    public Iterator<P> getColumnContent(final int n) {
        final PlaceholderList<D, S, P> placeholderList = this.getColumn(n);
        if (placeholderList == null) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        return new Iterator<P>(){
            private Iterator<P> delegate;
            private P current;
            private int currentIndex;
            private boolean requiresPurge;
            {
                this.delegate = placeholderList.dockables().iterator();
                this.currentIndex = -1;
                this.requiresPurge = false;
            }

            @Override
            public boolean hasNext() {
                boolean bl = this.delegate.hasNext();
                if (!bl && this.requiresPurge) {
                    PlaceholderToolbarGrid.this.purge();
                    this.requiresPurge = false;
                }
                return bl;
            }

            @Override
            public P next() {
                this.current = (PlaceholderListItem)this.delegate.next();
                ++this.currentIndex;
                return this.current;
            }

            @Override
            public void remove() {
                this.delegate.remove();
                PlaceholderToolbarGrid.this.onRemoved(placeholderList, n, this.current, this.currentIndex--);
            }
        };
    }

    protected PlaceholderList<D, S, P> getColumn(int n) {
        if (n < 0) {
            return null;
        }
        PlaceholderList.Filter filter = this.columns.dockables();
        if (n >= filter.size()) {
            return null;
        }
        return ((Column)filter.get(n)).getList();
    }

    public void bind() {
        this.columns.bind();
        Iterator<PlaceholderList<D, S, P>> iterator = this.allColumns();
        while (iterator.hasNext()) {
            iterator.next().bind();
        }
        if (!this.bound) {
            this.bound = true;
            if (this.strategy != null) {
                this.strategy.addListener(this.strategyListener);
                this.purge();
            }
        }
    }

    public void unbind() {
        this.columns.unbind();
        Iterator<PlaceholderList<D, S, P>> iterator = this.allColumns();
        while (iterator.hasNext()) {
            iterator.next().unbind();
        }
        if (this.bound) {
            this.bound = false;
            if (this.strategy != null) {
                this.strategy.removeListener(this.strategyListener);
            }
        }
    }

    public void setStrategy(PlaceholderStrategy placeholderStrategy) {
        if (this.strategy != null && this.bound) {
            this.strategy.removeListener(this.strategyListener);
        }
        this.strategy = placeholderStrategy;
        this.columns.setStrategy(placeholderStrategy);
        Iterator<PlaceholderList<D, S, P>> iterator = this.allColumns();
        while (iterator.hasNext()) {
            iterator.next().setStrategy(placeholderStrategy);
        }
        if (this.strategy != null && this.bound) {
            this.strategy.addListener(this.strategyListener);
            this.purge();
        }
    }

    public PlaceholderStrategy getStrategy() {
        return this.strategy;
    }

    private void purge() {
        this.purge(false);
    }

    private void purge(boolean bl) {
        int n = -1;
        for (PlaceholderList.Item item : this.columns.list()) {
            Column column = (Column)item.getDockable();
            if (column == null) continue;
            ++n;
            PlaceholderList placeholderList = column.getList();
            if (placeholderList.dockables().size() != 0) continue;
            item.setPlaceholderMap(placeholderList.toMap(new PlaceholderListItemAdapter<D, PlaceholderListItem<D>>(){

                @Override
                public ConvertedPlaceholderListItem convert(int n, PlaceholderListItem<D> placeholderListItem) {
                    throw new IllegalStateException("the list is supposed to have no children, so this conversion method must never be called");
                }
            }));
            item.setDockable(null);
            if (bl) continue;
            this.onRemoved(placeholderList, n--);
        }
    }

    protected abstract void fill(D var1, ConvertedPlaceholderListItem var2);

    public PlaceholderMap toMap(final Map<D, Integer> map) {
        this.columns.setConverter(new PlaceholderListItemAdapter<D, P>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, P p) {
                Integer n2 = (Integer)map.get(p.asDockable());
                if (n2 == null) {
                    return null;
                }
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                convertedPlaceholderListItem.putInt("index", n);
                convertedPlaceholderListItem.putInt("id", n2);
                PlaceholderToolbarGrid.this.fill(p.asDockable(), convertedPlaceholderListItem);
                return convertedPlaceholderListItem;
            }
        });
        try {
            PlaceholderMap placeholderMap = this.columns.toMap(new PlaceholderListItemAdapter<ColumnItem<D, S, P>, Column<D, S, P>>(){

                @Override
                public ConvertedPlaceholderListItem convert(int n, Column<D, S, P> column) {
                    ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                    convertedPlaceholderListItem.putInt("index", n);
                    convertedPlaceholderListItem.setPlaceholderMap(column.getPlaceholders());
                    return convertedPlaceholderListItem;
                }
            });
            return placeholderMap;
        }
        finally {
            this.columns.setConverter(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromMap(PlaceholderMap placeholderMap, final Map<Integer, D> map, final PlaceholderToolbarGridConverter<D, P> placeholderToolbarGridConverter) {
        this.clear();
        this.columns.setConverter(new PlaceholderListItemAdapter<D, P>(){

            @Override
            public P convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                Integer n = convertedPlaceholderListItem.getInt("id");
                Object v = map.get(n);
                if (v == null) {
                    return null;
                }
                return placeholderToolbarGridConverter.convert(v, convertedPlaceholderListItem);
            }
        });
        try {
            this.columns.read(placeholderMap, new PlaceholderListItemAdapter<ColumnItem<D, S, P>, Column<D, S, P>>(){

                @Override
                public Column<D, S, P> convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                    PlaceholderList placeholderList = PlaceholderToolbarGrid.this.createColumn();
                    PlaceholderMap placeholderMap = convertedPlaceholderListItem.getPlaceholderMap();
                    if (placeholderMap == null) {
                        return null;
                    }
                    placeholderList.read(placeholderMap, PlaceholderToolbarGrid.this.columns.getConverter());
                    return PlaceholderToolbarGrid.this.columns.createColumn(placeholderList);
                }

                @Override
                public void added(Column<D, S, P> column) {
                    for (PlaceholderListItem placeholderListItem : column.getList().dockables()) {
                        placeholderToolbarGridConverter.added(placeholderListItem);
                    }
                }
            });
            this.purge(true);
        }
        finally {
            this.columns.setConverter(null);
            this.onInserted();
        }
    }

    public PlaceholderMap toMap() {
        this.columns.setConverter(new PlaceholderListItemAdapter<D, P>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, P p) {
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                PlaceholderToolbarGrid.this.fill(p.asDockable(), convertedPlaceholderListItem);
                if (convertedPlaceholderListItem.getPlaceholder() == null && convertedPlaceholderListItem.getPlaceholderMap() == null) {
                    return null;
                }
                return convertedPlaceholderListItem;
            }
        });
        try {
            PlaceholderMap placeholderMap = this.columns.toMap(new PlaceholderListItemAdapter<ColumnItem<D, S, P>, Column<D, S, P>>(){

                @Override
                public ConvertedPlaceholderListItem convert(int n, Column<D, S, P> column) {
                    ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                    convertedPlaceholderListItem.putInt("index", n);
                    convertedPlaceholderListItem.setPlaceholderMap(column.getPlaceholders());
                    return convertedPlaceholderListItem;
                }
            });
            return placeholderMap;
        }
        finally {
            this.columns.setConverter(null);
        }
    }

    public void fromMap(PlaceholderMap placeholderMap) {
        this.clear();
        this.columns.read(placeholderMap, new PlaceholderListItemAdapter<ColumnItem<D, S, P>, Column<D, S, P>>(){

            @Override
            public Column<D, S, P> convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                PlaceholderMap placeholderMap = convertedPlaceholderListItem.getPlaceholderMap();
                if (placeholderMap == null) {
                    return null;
                }
                PlaceholderList placeholderList = PlaceholderToolbarGrid.this.createColumn();
                placeholderList.read(placeholderMap, PlaceholderToolbarGrid.this.columns.getConverter());
                return PlaceholderToolbarGrid.this.columns.createColumn(placeholderList);
            }
        });
        this.purge(true);
    }
}

