/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.gl;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.gl.CLGLContext;
import com.jogamp.opencl.gl.CLGLObject;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opengl.GLContext;
import java.nio.Buffer;

public final class CLGLBuffer<B extends Buffer>
extends CLBuffer<B>
implements CLGLObject {
    public final int GLID;

    private CLGLBuffer(CLContext cLContext, B b, long l, int n, long l2, int n2) {
        super(cLContext, b, l2, l, n2);
        this.GLID = n;
    }

    static <B extends Buffer> CLGLBuffer<B> create(CLContext cLContext, B b, long l, int n, int n2) {
        CLGLBuffer.checkBuffer(b, n);
        CL cL = CLGLBuffer.getCL(cLContext);
        int[] nArray = new int[1];
        long l2 = cL.clCreateFromGLBuffer(cLContext.ID, n, n2, nArray, 0);
        CLException.checkForError(nArray[0], "can not create CLGLObject from glBuffer #" + n2);
        return new CLGLBuffer<B>(cLContext, b, l2, n2, l, n);
    }

    static <B extends Buffer> void checkBuffer(B b, int n) throws IllegalArgumentException {
        if (b != null && !b.isDirect()) {
            throw new IllegalArgumentException("buffer is not a direct buffer");
        }
        if (CLGLBuffer.isHostPointerFlag(n)) {
            throw new IllegalArgumentException("CL_MEM_COPY_HOST_PTR or CL_MEM_USE_HOST_PTR can not be used with OpenGL Buffers.");
        }
    }

    public void updateSize() {
        this.size = CLGLBuffer.getSizeImpl(this.context, this.ID);
        this.initCLCapacity();
    }

    @Override
    public int getGLObjectID() {
        return this.GLID;
    }

    @Override
    public CLMemory.GLObjectType getGLObjectType() {
        return CLMemory.GLObjectType.GL_OBJECT_BUFFER;
    }

    @Override
    public CLGLContext getContext() {
        return (CLGLContext)super.getContext();
    }

    @Override
    public GLContext getGLContext() {
        return this.getContext().getGLContext();
    }

    @Override
    public <T extends Buffer> CLGLBuffer<T> cloneWith(T t) {
        return new CLGLBuffer<T>(this.context, t, this.ID, this.GLID, this.size, this.FLAGS);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [id: " + this.ID + " glID: " + this.GLID + "]";
    }
}

