/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry.compression;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jogamp.java3d.utils.geometry.compression.CompressedGeometryData;

public class CompressedGeometryFile {
    private static final boolean print = false;
    private static final boolean benchmark = false;
    static final int MAGIC_NUMBER = -1159857484;
    static final int MAGIC_NUMBER_OFFSET = 0;
    static final int MAJOR_VERSION_OFFSET = 4;
    static final int MINOR_VERSION_OFFSET = 8;
    static final int MINOR_MINOR_VERSION_OFFSET = 12;
    static final int OBJECT_COUNT_OFFSET = 16;
    static final int DIRECTORY_OFFSET_OFFSET = 24;
    static final int HEADER_SIZE = 32;
    static final int OBJECT_SIZE_OFFSET = 0;
    static final int GEOM_DATA_OFFSET = 4;
    static final int TYPE_MASK = 3;
    static final int NORMAL_PRESENT_MASK = 4;
    static final int COLOR_PRESENT_MASK = 8;
    static final int ALPHA_PRESENT_MASK = 16;
    static final int TYPE_POINT = 1;
    static final int TYPE_LINE = 2;
    static final int TYPE_TRIANGLE = 3;
    static final int BLOCK_HEADER_SIZE = 8;
    String fileName = null;
    int majorVersionNumber;
    int minorVersionNumber;
    int minorMinorVersionNumber;
    int objectCount;
    int objectIndex = 0;
    RandomAccessFile cgFile = null;
    int magicNumber;
    byte[] cgBuffer;
    int geomSize;
    int geomStart;
    int geomDataType;
    long[] directory;
    long directoryOffset;
    int[] objectSizes;
    int bufferObjectStart;
    int bufferObjectCount;
    int bufferNextObjectCount;
    int bufferNextObjectOffset;
    CompressedGeometryData.Header cgh;
    boolean fileUpdate = false;

    public CompressedGeometryFile(String file) throws IOException {
        this(file, false);
    }

    public CompressedGeometryFile(String file, boolean rw) throws IOException {
        this.open(file, rw);
        this.fileName = new String(file);
        this.initialize();
    }

    public CompressedGeometryFile(RandomAccessFile file) throws IOException {
        this.cgFile = file;
        this.initialize();
    }

    public void clear() throws IOException {
        this.cgFile.setLength(0L);
        this.initialize();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getMajorVersionNumber() {
        return this.majorVersionNumber;
    }

    public int getMinorVersionNumber() {
        return this.minorVersionNumber;
    }

    public int getMinorMinorVersionNumber() {
        return this.minorMinorVersionNumber;
    }

    public int getObjectCount() {
        return this.objectCount;
    }

    public int getCurrentIndex() {
        if (this.objectIndex == this.objectCount) {
            return -1;
        }
        return this.objectIndex;
    }

    public CompressedGeometryData readNext() throws IOException {
        return this.readNext(this.cgBuffer.length);
    }

    public CompressedGeometryData[] read() throws IOException {
        long startTime = 0L;
        CompressedGeometryData[] cg = new CompressedGeometryData[this.objectCount];
        this.objectIndex = 0;
        this.setFilePointer(this.directory[0]);
        this.bufferNextObjectCount = 0;
        int i = 0;
        while (i < this.objectCount) {
            cg[i] = this.readNext(this.cgBuffer.length);
            ++i;
        }
        return cg;
    }

    public CompressedGeometryData read(int index) throws IOException {
        this.objectIndex = index;
        if (this.objectIndex < 0) {
            throw new IndexOutOfBoundsException("\nobject index must be >= 0");
        }
        if (this.objectIndex >= this.objectCount) {
            throw new IndexOutOfBoundsException("\nobject index must be < " + this.objectCount);
        }
        if (this.objectIndex >= this.bufferObjectStart && this.objectIndex < this.bufferObjectStart + this.bufferObjectCount) {
            this.bufferNextObjectOffset = (int)(this.directory[this.objectIndex] - this.directory[this.bufferObjectStart]);
            this.bufferNextObjectCount = this.bufferObjectCount - (this.objectIndex - this.bufferObjectStart);
            return this.readNext();
        }
        this.setFilePointer(this.directory[this.objectIndex]);
        this.bufferNextObjectCount = 0;
        return this.readNext(this.objectSizes[this.objectIndex]);
    }

    public void write(CompressedGeometryData cg) throws IOException {
        CompressedGeometryData.Header cgh = new CompressedGeometryData.Header();
        cg.getCompressedGeometryHeader(cgh);
        if (cgh.size + 8 > this.cgBuffer.length) {
            this.cgBuffer = new byte[cgh.size + 8];
        }
        cg.getCompressedGeometry(this.cgBuffer);
        this.write(cgh, this.cgBuffer);
    }

    public void write(CompressedGeometryData.Header cgh, byte[] geometry) throws IOException {
        if (cgh.size + 8 > this.cgBuffer.length) {
            this.cgBuffer = new byte[cgh.size + 8];
        }
        if (cgh.majorVersionNumber > this.majorVersionNumber || cgh.majorVersionNumber == this.majorVersionNumber && cgh.minorVersionNumber > this.minorVersionNumber || cgh.majorVersionNumber == this.majorVersionNumber && cgh.minorVersionNumber == this.minorVersionNumber && cgh.minorMinorVersionNumber > this.minorMinorVersionNumber) {
            this.majorVersionNumber = cgh.majorVersionNumber;
            this.minorVersionNumber = cgh.minorVersionNumber;
            this.minorMinorVersionNumber = cgh.minorMinorVersionNumber;
            this.cgh.majorVersionNumber = cgh.majorVersionNumber;
            this.cgh.minorVersionNumber = cgh.minorVersionNumber;
            this.cgh.minorMinorVersionNumber = cgh.minorMinorVersionNumber;
        }
        int geomDataType = 0;
        switch (cgh.bufferType) {
            case 0: {
                geomDataType = 1;
                break;
            }
            case 1: {
                geomDataType = 2;
                break;
            }
            case 2: {
                geomDataType = 3;
            }
        }
        if ((cgh.bufferDataPresent & 1) != 0) {
            geomDataType |= 4;
        }
        if ((cgh.bufferDataPresent & 2) != 0) {
            geomDataType |= 8;
        }
        if ((cgh.bufferDataPresent & 4) != 0) {
            geomDataType |= 0x10;
        }
        if (this.objectCount == this.directory.length) {
            long[] newDirectory = new long[2 * this.objectCount];
            int[] newObjectSizes = new int[2 * this.objectCount];
            System.arraycopy(this.directory, 0, newDirectory, 0, this.objectCount);
            System.arraycopy(this.objectSizes, 0, newObjectSizes, 0, this.objectCount);
            this.directory = newDirectory;
            this.objectSizes = newObjectSizes;
        }
        this.directory[this.objectCount] = this.directoryOffset;
        this.objectSizes[this.objectCount] = cgh.size + 8;
        ++this.objectCount;
        this.setFilePointer(this.directoryOffset);
        this.cgFile.writeInt(cgh.size);
        this.cgFile.writeInt(geomDataType);
        this.cgFile.write(geometry, 0, cgh.size);
        this.directoryOffset += (long)(cgh.size + 8);
        this.objectIndex = this.objectCount;
        this.fileUpdate = true;
    }

    public void close() {
        if (this.cgFile != null) {
            try {
                if (this.fileUpdate) {
                    this.writeFileDirectory();
                    this.writeFileHeader();
                }
                this.cgFile.close();
            }
            catch (IOException e) {
                System.out.println("\nException: " + e.getMessage());
                System.out.println("failed to close " + this.fileName);
            }
        }
        this.cgFile = null;
        this.cgBuffer = null;
        this.directory = null;
        this.objectSizes = null;
    }

    void open(String fname, boolean rw) throws FileNotFoundException, IOException {
        this.cgFile = null;
        String mode = rw ? "rw" : "r";
        try {
            this.cgFile = new RandomAccessFile(fname, mode);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(String.valueOf(e.getMessage()) + "\n" + fname + ": open mode " + mode + " failed");
        }
    }

    void setFilePointer(long offset) throws IOException {
        this.cgFile.seek(offset);
        this.bufferNextObjectCount = 0;
    }

    void initialize() throws IOException {
        int maxSize = 0;
        if (this.cgFile.length() == 0L) {
            this.objectCount = 0;
            this.cgBuffer = new byte[32768];
            this.directory = new long[16];
            this.objectSizes = new int[this.directory.length];
            this.magicNumber = -1159857484;
            this.majorVersionNumber = 1;
            this.minorVersionNumber = 0;
            this.minorMinorVersionNumber = 0;
            this.directoryOffset = 32L;
            this.writeFileHeader();
        } else {
            this.readFileHeader();
            if (this.magicNumber != -1159857484) {
                this.close();
                throw new IllegalArgumentException("\n" + this.fileName + " is not a compressed geometry file");
            }
            this.directory = new long[this.objectCount];
            this.readDirectory(this.directoryOffset, this.directory);
            this.objectSizes = new int[this.objectCount];
            int i = 0;
            while (i < this.objectCount - 1) {
                this.objectSizes[i] = (int)(this.directory[i + 1] - this.directory[i]);
                if (this.objectSizes[i] > maxSize) {
                    maxSize = this.objectSizes[i];
                }
                ++i;
            }
            if (this.objectCount > 0) {
                this.objectSizes[this.objectCount - 1] = (int)(this.directoryOffset - this.directory[this.objectCount - 1]);
                if (this.objectSizes[this.objectCount - 1] > maxSize) {
                    maxSize = this.objectSizes[this.objectCount - 1];
                }
            }
            this.cgBuffer = new byte[maxSize];
            this.setFilePointer(32L);
        }
        this.cgh = new CompressedGeometryData.Header();
        this.cgh.majorVersionNumber = this.majorVersionNumber;
        this.cgh.minorVersionNumber = this.minorVersionNumber;
        this.cgh.minorMinorVersionNumber = this.minorMinorVersionNumber;
    }

    void readFileHeader() throws IOException {
        byte[] header = new byte[32];
        try {
            this.setFilePointer(0L);
            if (this.cgFile.read(header) != 32) {
                this.close();
                throw new IOException("failed header read");
            }
        }
        catch (IOException e) {
            if (this.cgFile != null) {
                this.close();
            }
            throw e;
        }
        this.magicNumber = (header[0] & 0xFF) << 24 | (header[1] & 0xFF) << 16 | (header[2] & 0xFF) << 8 | header[3] & 0xFF;
        this.majorVersionNumber = (header[4] & 0xFF) << 24 | (header[5] & 0xFF) << 16 | (header[6] & 0xFF) << 8 | header[7] & 0xFF;
        this.minorVersionNumber = (header[8] & 0xFF) << 24 | (header[9] & 0xFF) << 16 | (header[10] & 0xFF) << 8 | header[11] & 0xFF;
        this.minorMinorVersionNumber = (header[12] & 0xFF) << 24 | (header[13] & 0xFF) << 16 | (header[14] & 0xFF) << 8 | header[15] & 0xFF;
        this.objectCount = (header[16] & 0xFF) << 24 | (header[17] & 0xFF) << 16 | (header[18] & 0xFF) << 8 | header[19] & 0xFF;
        this.directoryOffset = (long)(header[24] & 0xFF) << 56 | (long)(header[25] & 0xFF) << 48 | (long)(header[26] & 0xFF) << 40 | (long)(header[27] & 0xFF) << 32 | (long)(header[28] & 0xFF) << 24 | (long)(header[29] & 0xFF) << 16 | (long)(header[30] & 0xFF) << 8 | (long)(header[31] & 0xFF);
    }

    void writeFileHeader() throws IOException {
        this.setFilePointer(0L);
        try {
            this.cgFile.writeInt(-1159857484);
            this.cgFile.writeInt(this.majorVersionNumber);
            this.cgFile.writeInt(this.minorVersionNumber);
            this.cgFile.writeInt(this.minorMinorVersionNumber);
            this.cgFile.writeInt(this.objectCount);
            this.cgFile.writeInt(0);
            this.cgFile.writeLong(this.directoryOffset);
        }
        catch (IOException e) {
            throw new IOException(String.valueOf(e.getMessage()) + "\ncould not write file header for " + this.fileName);
        }
    }

    void readDirectory(long offset, long[] directory) throws IOException {
        byte[] buff = new byte[directory.length * 8];
        this.setFilePointer(offset);
        try {
            this.cgFile.read(buff);
        }
        catch (IOException e) {
            throw new IOException(String.valueOf(e.getMessage()) + "\nfailed to read " + buff.length + " byte directory, offset " + offset + " in file " + this.fileName);
        }
        int i = 0;
        while (i < directory.length) {
            directory[i] = (long)(buff[i * 8 + 0] & 0xFF) << 56 | (long)(buff[i * 8 + 1] & 0xFF) << 48 | (long)(buff[i * 8 + 2] & 0xFF) << 40 | (long)(buff[i * 8 + 3] & 0xFF) << 32 | (long)(buff[i * 8 + 4] & 0xFF) << 24 | (long)(buff[i * 8 + 5] & 0xFF) << 16 | (long)(buff[i * 8 + 6] & 0xFF) << 8 | (long)(buff[i * 8 + 7] & 0xFF);
            ++i;
        }
    }

    void writeFileDirectory() throws IOException {
        this.setFilePointer(this.directoryOffset);
        int directoryAlign = (int)(this.directoryOffset % 8L);
        if (directoryAlign != 0) {
            byte[] bytes = new byte[8 - directoryAlign];
            try {
                this.cgFile.write(bytes);
            }
            catch (IOException e) {
                throw new IOException(String.valueOf(e.getMessage()) + "\ncould not write " + directoryAlign + " bytes to long word align directory for " + this.fileName);
            }
            this.directoryOffset += (long)(8 - directoryAlign);
        }
        try {
            int i = 0;
            while (i < this.objectCount) {
                this.cgFile.writeLong(this.directory[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new IOException(String.valueOf(e.getMessage()) + "\ncould not write directory for " + this.fileName);
        }
    }

    CompressedGeometryData readNext(int bufferReadLimit) throws IOException {
        if (this.objectIndex == this.objectCount) {
            return null;
        }
        if (this.bufferNextObjectCount == 0) {
            int curSize = 0;
            this.bufferObjectCount = 0;
            int i = this.objectIndex;
            while (i < this.objectCount) {
                if (curSize + this.objectSizes[i] > bufferReadLimit) break;
                curSize += this.objectSizes[i];
                ++this.bufferObjectCount;
                ++i;
            }
            try {
                i = this.cgFile.read(this.cgBuffer, 0, curSize);
            }
            catch (IOException e) {
                throw new IOException(String.valueOf(e.getMessage()) + "\nfailed to read " + curSize + " bytes, object " + this.objectIndex + " in file " + this.fileName);
            }
            this.bufferObjectStart = this.objectIndex;
            this.bufferNextObjectCount = this.bufferObjectCount;
            this.bufferNextObjectOffset = 0;
        }
        this.geomSize = (this.cgBuffer[this.bufferNextObjectOffset + 0 + 0] & 0xFF) << 24 | (this.cgBuffer[this.bufferNextObjectOffset + 0 + 1] & 0xFF) << 16 | (this.cgBuffer[this.bufferNextObjectOffset + 0 + 2] & 0xFF) << 8 | this.cgBuffer[this.bufferNextObjectOffset + 0 + 3] & 0xFF;
        this.geomDataType = (this.cgBuffer[this.bufferNextObjectOffset + 4 + 0] & 0xFF) << 24 | (this.cgBuffer[this.bufferNextObjectOffset + 4 + 1] & 0xFF) << 16 | (this.cgBuffer[this.bufferNextObjectOffset + 4 + 2] & 0xFF) << 8 | this.cgBuffer[this.bufferNextObjectOffset + 4 + 3] & 0xFF;
        this.geomStart = this.bufferNextObjectOffset + 8;
        this.bufferNextObjectOffset += this.objectSizes[this.objectIndex];
        --this.bufferNextObjectCount;
        ++this.objectIndex;
        return this.newCG(this.geomSize, this.geomStart, this.geomDataType);
    }

    CompressedGeometryData newCG(int geomSize, int geomStart, int geomDataType) {
        this.cgh.size = geomSize;
        this.cgh.start = geomStart;
        if ((geomDataType & 3) == 1) {
            this.cgh.bufferType = 0;
        } else if ((geomDataType & 3) == 2) {
            this.cgh.bufferType = 1;
        } else if ((geomDataType & 3) == 3) {
            this.cgh.bufferType = 2;
        }
        this.cgh.bufferDataPresent = 0;
        if ((geomDataType & 4) != 0) {
            this.cgh.bufferDataPresent |= 1;
        }
        if ((geomDataType & 8) != 0) {
            this.cgh.bufferDataPresent |= 2;
        }
        if ((geomDataType & 0x10) != 0) {
            this.cgh.bufferDataPresent |= 4;
        }
        return new CompressedGeometryData(this.cgh, this.cgBuffer);
    }

    protected void finalize() {
        this.close();
    }
}

