/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.AbstractToolbarDockStation;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.station.toolbar.group.AbstractToolbarGroupActions;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.toolbar.expand.SimpleExpandAction;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;

public abstract class ExpandToolbarGroupActions<P>
extends AbstractToolbarGroupActions<P, ExpandColumn> {
    private PropertyValue<ExpandableToolbarItemStrategy> strategy = new PropertyValue<ExpandableToolbarItemStrategy>(ExpandableToolbarItemStrategy.STRATEGY){

        @Override
        protected void valueChanged(ExpandableToolbarItemStrategy expandableToolbarItemStrategy, ExpandableToolbarItemStrategy expandableToolbarItemStrategy2) {
            if (expandableToolbarItemStrategy != null) {
                expandableToolbarItemStrategy.removeExpandedListener(ExpandToolbarGroupActions.this.listener);
            }
            if (expandableToolbarItemStrategy2 != null) {
                expandableToolbarItemStrategy2.addExpandedListener(ExpandToolbarGroupActions.this.listener);
            }
        }
    };
    private PropertyValue<Boolean> onConflictEnable = new PropertyValue<Boolean>(AbstractToolbarDockStation.ON_CONFLICT_ENABLE){

        @Override
        protected void valueChanged(Boolean bl, Boolean bl2) {
            int n = ExpandToolbarGroupActions.this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                ((ExpandColumn)ExpandToolbarGroupActions.this.getColumn(i)).source.update();
            }
        }
    };
    private ExpandableToolbarItemStrategyListener listener = new ExpandableToolbarItemStrategyListener(){

        @Override
        public void stretched(Dockable dockable) {
            ExpandToolbarGroupActions.this.update(dockable);
        }

        @Override
        public void shrunk(Dockable dockable) {
            ExpandToolbarGroupActions.this.update(dockable);
        }

        @Override
        public void expanded(Dockable dockable) {
            ExpandToolbarGroupActions.this.update(dockable);
        }

        @Override
        public void enablementChanged(Dockable dockable, ExpandedState expandedState, boolean bl) {
            ExpandToolbarGroupActions.this.update(dockable);
        }
    };
    private DockController controller;

    public ExpandToolbarGroupActions(DockController dockController, ToolbarGroupDockStation toolbarGroupDockStation) {
        super(toolbarGroupDockStation);
        this.controller = dockController;
        this.strategy.setProperties(dockController);
        this.onConflictEnable.setProperties(dockController);
    }

    public void destroy() {
        this.strategy.setProperties((DockController)null);
        this.onConflictEnable.setProperties((DockController)null);
    }

    @Override
    protected ExpandColumn createColumn(ToolbarColumn<Dockable, P> toolbarColumn) {
        return new ExpandColumn(toolbarColumn);
    }

    public ExpandableToolbarItemStrategy getStrategy() {
        return this.strategy.getValue();
    }

    public void update(Dockable dockable) {
        ExpandColumn expandColumn = (ExpandColumn)this.getColumn(dockable);
        if (expandColumn != null) {
            expandColumn.source.update();
        }
    }

    private class ExpandSource
    extends AbstractDockActionSource {
        private ExpandColumn column;
        private SimpleExpandAction[] actions;

        public ExpandSource(ExpandColumn expandColumn) {
            this.column = expandColumn;
        }

        private void onAction(int n) {
            this.column.performAction(this.actions[n].getBehavior());
        }

        @Override
        public void addDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
            if (!this.hasListeners()) {
                this.findEnabledActions();
            }
            super.addDockActionSourceListener(dockActionSourceListener);
        }

        private void findEnabledActions() {
            Object object;
            boolean[] blArray = this.column.getEnabledStates();
            int n2 = 0;
            for (boolean n3 : blArray) {
                if (!n3) continue;
                ++n2;
            }
            boolean bl = blArray[ExpandedState.EXPANDED.ordinal()];
            int n4 = blArray[ExpandedState.SHRUNK.ordinal()];
            int n5 = blArray[ExpandedState.STRETCHED.ordinal()];
            int n = Math.max(0, n2 - 1);
            if (this.actions == null || this.actions.length != n) {
                object = new SimpleExpandAction[n];
                if (this.actions != null) {
                    System.arraycopy(this.actions, 0, object, 0, Math.min(this.actions.length, ((SimpleExpandAction[])object).length));
                }
                for (int i = 0; i < ((SimpleExpandAction[])object).length; ++i) {
                    if (object[i] != null) continue;
                    object[i] = new SimpleExpandAction(ExpandToolbarGroupActions.this.controller, SimpleExpandAction.Action.LARGEST);
                    final int n3 = i;
                    ((SimpleButtonAction)object[i]).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ExpandSource.this.onAction(n3);
                        }
                    });
                }
                this.actions = object;
            }
            object = this.column.getState();
            if (bl && n4 != 0 && n5 != 0) {
                switch (4.$SwitchMap$bibliothek$gui$dock$toolbar$expand$ExpandedState[((Enum)object).ordinal()]) {
                    case 1: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.LARGER);
                        this.actions[1].setBehavior(SimpleExpandAction.Action.LARGEST);
                        break;
                    }
                    case 2: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.SMALLER);
                        this.actions[1].setBehavior(SimpleExpandAction.Action.LARGER);
                        break;
                    }
                    case 3: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.SMALLEST);
                        this.actions[1].setBehavior(SimpleExpandAction.Action.SMALLER);
                    }
                }
            } else if (n4 != 0 && (bl || n5 != 0)) {
                switch (4.$SwitchMap$bibliothek$gui$dock$toolbar$expand$ExpandedState[((Enum)object).ordinal()]) {
                    case 1: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.LARGER);
                        break;
                    }
                    default: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.SMALLER);
                        break;
                    }
                }
            } else if (n5 != 0 && bl) {
                switch (4.$SwitchMap$bibliothek$gui$dock$toolbar$expand$ExpandedState[((Enum)object).ordinal()]) {
                    case 3: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.SMALLER);
                        break;
                    }
                    default: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.LARGER);
                    }
                }
            }
        }

        public void update() {
            if (this.hasListeners()) {
                int n = this.getDockActionCount();
                this.findEnabledActions();
                int n2 = this.getDockActionCount();
                if (n != n2) {
                    if (n > 0) {
                        this.fireRemoved(0, n - 1);
                    }
                    this.findEnabledActions();
                    if (n2 > 0) {
                        this.fireAdded(0, n2 - 1);
                    }
                }
            }
        }

        @Override
        public Iterator<DockAction> iterator() {
            return new Iterator<DockAction>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < ExpandSource.this.getDockActionCount();
                }

                @Override
                public DockAction next() {
                    return ExpandSource.this.getDockAction(this.index++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public DockAction getDockAction(int n) {
            if (n < 0 || n >= this.getDockActionCount()) {
                throw new IllegalArgumentException("index out of bounds");
            }
            return this.actions[n];
        }

        @Override
        public int getDockActionCount() {
            if (!this.hasListeners()) {
                this.findEnabledActions();
            }
            return this.actions.length;
        }

        @Override
        public LocationHint getLocationHint() {
            return new LocationHint(LocationHint.INDIRECT_ACTION, LocationHint.RIGHT);
        }
    }

    protected class ExpandColumn
    extends AbstractToolbarGroupActions.Column {
        private ExpandSource source;

        public ExpandColumn(ToolbarColumn<Dockable, P> toolbarColumn) {
            super(null);
            this.source = new ExpandSource(this);
            this.init(toolbarColumn);
        }

        @Override
        protected DockActionSource createSource() {
            return this.source;
        }

        @Override
        protected void inserted(int n, P p) {
            this.source.update();
        }

        @Override
        protected void removed(int n, P p) {
            this.source.update();
        }

        @Override
        protected void removed() {
        }

        public void performAction(SimpleExpandAction.Action action) {
            ExpandedState expandedState;
            boolean[] blArray = this.getEnabledStates();
            ExpandedState expandedState2 = this.getState();
            switch (action) {
                case LARGER: {
                    expandedState = expandedState2.larger();
                    break;
                }
                case LARGEST: {
                    expandedState = ExpandedState.EXPANDED;
                    break;
                }
                case SMALLER: {
                    expandedState = expandedState2.smaller();
                    break;
                }
                case SMALLEST: {
                    expandedState = ExpandedState.SHRUNK;
                    break;
                }
                default: {
                    throw new IllegalStateException("never happens");
                }
            }
            int n = blArray.length;
            while (n > 0 && expandedState2 != expandedState && !blArray[expandedState.ordinal()]) {
                --n;
                switch (action) {
                    case LARGER: 
                    case SMALLEST: {
                        expandedState = expandedState.larger();
                        break;
                    }
                    case LARGEST: 
                    case SMALLER: {
                        expandedState = expandedState.smaller();
                    }
                }
            }
            if (expandedState2 != expandedState && blArray[expandedState.ordinal()]) {
                this.setState(expandedState);
            }
        }

        public void setState(ExpandedState expandedState) {
            ExpandableToolbarItemStrategy expandableToolbarItemStrategy = ExpandToolbarGroupActions.this.getStrategy();
            for (Dockable dockable : this.getDockables()) {
                expandableToolbarItemStrategy.setState(dockable, expandedState);
            }
            this.source.update();
        }

        public ExpandedState getState() {
            ExpandableToolbarItemStrategy expandableToolbarItemStrategy;
            ToolbarColumn toolbarColumn = this.getColumn();
            ExpandedState expandedState = null;
            if (toolbarColumn.getDockableCount() > 0 && (expandableToolbarItemStrategy = ExpandToolbarGroupActions.this.getStrategy()) != null) {
                int n = toolbarColumn.getDockableCount();
                for (int i = 0; i < n && expandedState == null; ++i) {
                    expandedState = expandableToolbarItemStrategy.getState(toolbarColumn.getDockable(i));
                }
            }
            if (expandedState == null) {
                expandedState = ExpandedState.SHRUNK;
            }
            return expandedState;
        }

        public boolean[] getEnabledStates() {
            boolean[] blArray = new boolean[ExpandedState.values().length];
            for (ExpandedState expandedState : ExpandedState.values()) {
                blArray[expandedState.ordinal()] = this.isEnabled(expandedState);
            }
            return blArray;
        }

        private boolean isEnabled(ExpandedState expandedState) {
            boolean bl = false;
            boolean bl2 = false;
            ExpandableToolbarItemStrategy expandableToolbarItemStrategy = ExpandToolbarGroupActions.this.getStrategy();
            if (expandableToolbarItemStrategy != null) {
                for (Dockable dockable : this.getDockables()) {
                    if (expandableToolbarItemStrategy.isEnabled(dockable, expandedState)) {
                        bl = true;
                        continue;
                    }
                    bl2 = true;
                }
            }
            if (bl && bl2) {
                return (Boolean)ExpandToolbarGroupActions.this.onConflictEnable.getValue();
            }
            return bl;
        }
    }
}

