/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupProperty;
import bibliothek.gui.dock.station.toolbar.layout.DockablePlaceholderToolbarGrid;
import bibliothek.util.Path;

public class ToolbarGroupPlaceholderMapping
implements PlaceholderMapping {
    private ToolbarGroupDockStation station;
    private DockablePlaceholderToolbarGrid<?> grid;

    public ToolbarGroupPlaceholderMapping(ToolbarGroupDockStation toolbarGroupDockStation, DockablePlaceholderToolbarGrid<?> dockablePlaceholderToolbarGrid) {
        this.station = toolbarGroupDockStation;
        this.grid = dockablePlaceholderToolbarGrid;
    }

    @Override
    public ToolbarGroupDockStation getStation() {
        return this.station;
    }

    @Override
    public void addPlaceholder(Dockable dockable, Path path) {
        if (path == null) {
            throw new IllegalArgumentException("placeholder must not be null");
        }
        int n = this.grid.getColumn(dockable);
        if (n == -1) {
            throw new IllegalArgumentException("unable to find column of dockable");
        }
        int n2 = this.grid.getLine(n, dockable);
        if (n2 == -1) {
            throw new IllegalArgumentException("unable to find line of dockable");
        }
        this.grid.addPlaceholder(n, n2, path);
    }

    @Override
    public boolean hasPlaceholder(Path path) {
        return this.grid.hasPlaceholder(path);
    }

    @Override
    public void removePlaceholder(Path path) {
        this.grid.removePlaceholder(path);
    }

    @Override
    public Dockable getDockableAt(Path path) {
        Object p = this.grid.get(path);
        if (p == null) {
            return null;
        }
        return (Dockable)p.asDockable();
    }

    @Override
    public DockableProperty getLocationAt(Path path) {
        int n = this.grid.getColumn(path);
        if (n == -1) {
            return null;
        }
        int n2 = this.grid.getLine(path);
        if (n2 == -1) {
            return null;
        }
        return new ToolbarGroupProperty(n, n2, path);
    }
}

