/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.egl.EGL;
import com.jogamp.opengl.egl.EGLExt;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.nio.IntBuffer;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.util.av.GLMediaPlayerImpl;

public abstract class EGLMediaPlayerImpl
extends GLMediaPlayerImpl {
    protected final TextureType texType;
    protected final boolean useKHRSync;

    protected EGLMediaPlayerImpl(TextureType textureType, boolean bl) {
        this.texType = textureType;
        this.useKHRSync = bl;
    }

    @Override
    protected TextureSequence.TextureFrame createTexImage(GL gL, int n) {
        long l;
        long l2;
        long l3;
        IntBuffer intBuffer;
        EGLDrawable eGLDrawable;
        EGLExt eGLExt;
        EGLContext eGLContext;
        boolean bl;
        Texture texture = super.createTexImageImpl(gL, n, this.getWidth(), this.getHeight());
        boolean bl2 = bl = TextureType.KHRImage == this.texType || this.useKHRSync;
        if (bl) {
            eGLContext = (EGLContext)gL.getContext();
            eGLExt = eGLContext.getEGLExt();
            eGLDrawable = (EGLDrawable)eGLContext.getGLDrawable();
        } else {
            eGLContext = null;
            eGLExt = null;
            eGLDrawable = null;
        }
        if (TextureType.KHRImage == this.texType) {
            intBuffer = Buffers.newDirectIntBuffer(1);
            l3 = 0L;
            intBuffer.put(0, 12344);
            l2 = eGLExt.eglCreateImageKHR(eGLDrawable.getNativeSurface().getDisplayHandle(), eGLContext.getHandle(), 12465, l3, intBuffer);
            if (0L == l2) {
                throw new RuntimeException("EGLImage creation failed: " + EGL.eglGetError() + ", ctx " + eGLContext + ", tex " + n + ", err " + EGLMediaPlayerImpl.toHexString(EGL.eglGetError()));
            }
        } else {
            l3 = 0L;
            l2 = 0L;
        }
        if (this.useKHRSync) {
            intBuffer = Buffers.newDirectIntBuffer(1);
            intBuffer.put(0, 12344);
            l = eGLExt.eglCreateSyncKHR(eGLDrawable.getNativeSurface().getDisplayHandle(), 12537, intBuffer);
            if (0L == l) {
                throw new RuntimeException("EGLSync creation failed: " + EGL.eglGetError() + ", ctx " + eGLContext + ", err " + EGLMediaPlayerImpl.toHexString(EGL.eglGetError()));
            }
        } else {
            l = 0L;
        }
        return new EGLTextureFrame(l3, texture, l2, l);
    }

    @Override
    protected void destroyTexFrame(GL gL, TextureSequence.TextureFrame textureFrame) {
        EGLDrawable eGLDrawable;
        EGLExt eGLExt;
        boolean bl;
        boolean bl2 = bl = TextureType.KHRImage == this.texType || this.useKHRSync;
        if (bl) {
            EGLContext eGLContext = (EGLContext)gL.getContext();
            eGLExt = eGLContext.getEGLExt();
            eGLDrawable = (EGLDrawable)eGLContext.getGLDrawable();
        } else {
            Object var4_5 = null;
            eGLExt = null;
            eGLDrawable = null;
        }
        EGLTextureFrame eGLTextureFrame = (EGLTextureFrame)textureFrame;
        if (0L != eGLTextureFrame.getImage()) {
            eGLExt.eglDestroyImageKHR(eGLDrawable.getNativeSurface().getDisplayHandle(), eGLTextureFrame.getImage());
        }
        if (0L != eGLTextureFrame.getSync()) {
            eGLExt.eglDestroySyncKHR(eGLDrawable.getNativeSurface().getDisplayHandle(), eGLTextureFrame.getSync());
        }
        super.destroyTexFrame(gL, textureFrame);
    }

    public static class EGLTextureFrame
    extends TextureSequence.TextureFrame {
        protected final long clientBuffer;
        protected final long image;
        protected final long sync;

        public EGLTextureFrame(long l, Texture texture, long l2, long l3) {
            super(texture);
            this.clientBuffer = l;
            this.image = l2;
            this.sync = l3;
        }

        public final long getClientBuffer() {
            return this.clientBuffer;
        }

        public final long getImage() {
            return this.image;
        }

        public final long getSync() {
            return this.sync;
        }

        @Override
        public String toString() {
            return "EGLTextureFrame[pts " + this.pts + " ms, l " + this.duration + " ms, texID " + this.texture.getTextureObject() + ", img " + this.image + ", sync " + this.sync + ", clientBuffer " + this.clientBuffer + "]";
        }
    }

    public static enum TextureType {
        GL(0),
        KHRImage(1);

        public final int id;

        private TextureType(int n2) {
            this.id = n2;
        }
    }
}

