/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.station.OrientingDockStation;
import bibliothek.gui.dock.station.OrientingDockStationEvent;
import bibliothek.gui.dock.station.OrientingDockStationListener;

public abstract class OrientationObserver
implements OrientingDockStationListener {
    private Dockable dockable;
    private OrientingDockStation station;
    private DockHierarchyListener listener = new DockHierarchyListener(){

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
            OrientationObserver.this.updateHierarchy();
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
        }
    };

    public OrientationObserver(Dockable dockable) {
        this.dockable = dockable;
        dockable.addDockHierarchyListener(this.listener);
        this.updateHierarchy();
    }

    public void destroy() {
        this.dockable.removeDockHierarchyListener(this.listener);
    }

    private void updateHierarchy() {
        Dockable dockable = this.dockable;
        DockStation dockStation = dockable.getDockParent();
        OrientingDockStation orientingDockStation = null;
        while (dockStation != null) {
            if (dockStation instanceof OrientingDockStation) {
                orientingDockStation = (OrientingDockStation)dockStation;
                break;
            }
            dockable = dockStation.asDockable();
            if (dockable == null) {
                dockStation = null;
                continue;
            }
            dockStation = dockable.getDockParent();
        }
        if (orientingDockStation != this.station) {
            if (this.station != null) {
                this.station.removeOrientingDockStationListener(this);
            }
            if (orientingDockStation != null) {
                orientingDockStation.addOrientingDockStationListener(this);
            }
            this.orientationChanged(this.getOrientation());
        }
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    protected abstract void orientationChanged(Orientation var1);

    public Orientation getOrientation() {
        Dockable dockable = this.dockable;
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            if (dockStation instanceof OrientingDockStation) {
                return ((OrientingDockStation)dockStation).getOrientationOf(dockable);
            }
            dockable = dockStation.asDockable();
            if (dockable == null) {
                dockStation = null;
                continue;
            }
            dockStation = dockable.getDockParent();
        }
        return null;
    }

    @Override
    public void changed(OrientingDockStationEvent orientingDockStationEvent) {
        if (orientingDockStationEvent.isAffected(this.dockable)) {
            this.orientationChanged(this.getOrientation());
        }
    }
}

