/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Divideable;
import bibliothek.gui.dock.wizard.WizardSplitDockStation;
import java.awt.Rectangle;

public class ColumnDividier
implements Divideable {
    private WizardSplitDockStation station;

    public ColumnDividier(WizardSplitDockStation wizardSplitDockStation) {
        this.station = wizardSplitDockStation;
    }

    @Override
    public double getDividerAt(int n, int n2) {
        double d = this.station.getWidth();
        double d2 = this.station.getHeight();
        switch (this.station.getSide()) {
            case RIGHT: 
            case LEFT: {
                return (double)n / d;
            }
            case BOTTOM: 
            case TOP: {
                return (double)n2 / d2;
            }
        }
        throw new IllegalStateException("unknown side: " + (Object)((Object)this.station.getSide()));
    }

    @Override
    public Rectangle getDividerBounds(double d, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        int n = this.station.getDividerSize();
        int n2 = this.station.getWidth() - n;
        int n3 = this.station.getHeight() - n;
        switch (this.station.getSide()) {
            case RIGHT: 
            case LEFT: {
                rectangle.x = (int)(d * (double)n2);
                rectangle.y = 0;
                rectangle.width = n;
                rectangle.height = n3 + n;
                break;
            }
            case BOTTOM: 
            case TOP: {
                rectangle.x = 0;
                rectangle.width = n2 + n;
                rectangle.y = (int)(d * (double)n3);
                rectangle.height = n;
            }
        }
        return rectangle;
    }

    @Override
    public SplitDockStation.Orientation getOrientation() {
        return this.station.getSide().getHeaderOrientation();
    }

    @Override
    public double getDivider() {
        switch (this.station.getSide()) {
            case RIGHT: 
            case BOTTOM: {
                return 0.0;
            }
            case LEFT: 
            case TOP: {
                return 1.0;
            }
        }
        throw new IllegalStateException("unknown side: " + (Object)((Object)this.station.getSide()));
    }

    @Override
    public double getActualDivider() {
        return this.getDivider();
    }

    @Override
    public void setDivider(double d) {
    }

    @Override
    public double validateDivider(double d) {
        return this.station.getWizardSplitLayoutManager().validateColumnDivider(d);
    }
}

