/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.TextureCubeMap;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.TextureState;

public class TextureCubeMapState
extends TextureState {
    private int[][] ic = new int[6][];

    public TextureCubeMapState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            TextureCubeMap tcm = (TextureCubeMap)this.node;
            int face = 0;
            while (face < 6) {
                ImageComponent[] images = tcm.getImages(face);
                this.ic[face] = new int[images.length];
                int i = 0;
                while (i < images.length) {
                    this.ic[face][i] = control.getSymbolTable().addReference((SceneGraphObject)images[i]);
                    ++i;
                }
                ++face;
            }
        }
    }

    @Override
    public void addSubReference() {
        int face = 0;
        while (face < 6) {
            int i = 0;
            while (i < this.ic[face].length) {
                this.control.getSymbolTable().incNodeComponentRefCount(this.ic[face][i]);
                ++i;
            }
            ++face;
        }
    }

    @Override
    public void buildGraph() {
        TextureCubeMap tcm = (TextureCubeMap)this.node;
        int face = 0;
        while (face < 6) {
            int i = 0;
            while (i < this.ic[face].length) {
                tcm.setImage(i, face, (ImageComponent2D)this.control.getSymbolTable().getJ3dNode(this.ic[face][i]));
                ++i;
            }
            ++face;
        }
        super.buildGraph();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        return this.createNode(j3dClass, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(this.mipMapMode), new Integer(this.format), new Integer(this.width), new Integer(this.boundaryWidth)});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new TextureCubeMap(this.mipMapMode, this.format, this.width, this.boundaryWidth);
    }
}

