kernel void panoramicIndirection(global const uchar4 *srcDepthBuffer, global const uchar4 *srcNormalBuffer, global const uchar4 *srcImgBuffer_RGB, 
								 global float *srcMtx, global float *srcMtx_invert, global float *destMtx, global float *destMtx_invert,
                                 __global float4 *indirectionBuffer, __global int4 *indirectionImgBuffer,
                                 int W, int srcImageMargin, int srcImageWidthIncludingMargin, int srcNormalW,
                                 int destDepthW, int destImageMargin, int destImageWidthIncludingMargin)
{
   int H = W/2;
   int gx = get_global_id(0);
   int gy = get_global_id(1);
   if (gy>=H)
   {
      return;
   }
   int srcNormalH = (int)(srcNormalW/2);

   int2 ColRowInSrcNormalBuffer = srcColRow2destColRow_Panoramic(gx, gy, 0, W, 0, srcNormalW);

   uchar4 srcDepthBufferInfo = srcDepthBuffer[W*gy+gx];
   float3 localCoords = getDepthBufferLocalCoordinates(srcDepthBufferInfo, gx, gy, W, H);
   float4 localNormalInfo = getNormalInfo(srcNormalBuffer, ColRowInSrcNormalBuffer.x, ColRowInSrcNormalBuffer.y, srcNormalW, srcNormalH);
   if ( ((localCoords.x==0.f)&&(localCoords.y==0.f)&&(localCoords.z==0.f)) || (localNormalInfo.w==255) )
   {
      indirectionBuffer[W*gy+gx] = (float4)(0.f, 0.f, 0.f, -1.f);
      indirectionImgBuffer[W*gy+gx] = (int4)(0, 0, 0, -1);
      return;
   }
   
   float3 globalNormal = transformVector_arrayVersion(srcMtx, localNormalInfo.xyz);
   float3 globalCoords = transformPoint_arrayVersion(srcMtx, localCoords);
   float3 destCenter = transformPoint_arrayVersion(destMtx, (float3)(0.f, 0.f, 0.f));
 
   float3 dir = (float3)(globalCoords.x-destCenter.x, globalCoords.y-destCenter.y, globalCoords.z-destCenter.z);
   float scal = dot(dir, globalNormal);

   if (scal>0.f)
   {
      indirectionBuffer[W*gy+gx] = (float4)(0.f, 0.f, 0.f, -1.f);
      indirectionImgBuffer[W*gy+gx] = (int4)(0, 0, 0, -1);
      return;
   }
   int2 ColRowInSrcImageBuffer = srcColRow2destColRow_Panoramic(gx, gy, 0, W, srcImageMargin, srcImageWidthIncludingMargin);
   int iColInSrcImg = (int)ColRowInSrcImageBuffer.x;
   int iRowInSrcImg = (int)ColRowInSrcImageBuffer.y;
   uchar4 srcImgRGB = srcImgBuffer_RGB[iRowInSrcImg*srcImageWidthIncludingMargin+iColInSrcImg];

   float3 localCoordsInDestBuffer = transformPoint_arrayVersion(desMtx_invert, globalCoords);
   float xloc = localCoordsInDestBuffer.x;
   float yloc = localCoordsInDestBuffer.y;
   float zloc = localCoordsInDestBuffer.z;
   float2 destDepthCoords = getDepthBufferCoordinates(xloc, yloc, zloc, destDepthW, (int)(destDepthW/2));
   float d = sqrt(xloc*xloc + yloc*yloc + zloc*zloc);
   int iColInDestDepth = (int)(destDepthCoords.x);
   int iRowInDestDepth = (int)(destDepthCoords.y);
   int indexInDestDepth = iRowInDestDepth*destDepthW+iColInDestDepth;
   indirectionBuffer[W*gy+gx] = (float4)(d, destDepthCoords.x, destDepthCoords.y, (float)indexInDestDepth);

   int2 ColRowInDestImageBuffer = srcColRow2destColRow_Panoramic(iColInDestDepth, iRowInDestDepth, 0, destDepthW, destImageMargin, destImageWidthIncludingMargin);
   int iColInDestImg = (int)ColRowInDestImageBuffer.x;
   int iRowInDestImg = (int)ColRowInDestImageBuffer.y;
   int indexInDestImgBuffer = iRowInDestImg*destImageWidthIncludingMargin+iColInDestImg;
   indirectionImgBuffer[W*gy+gx] = (int4)(srcImgRGB.z, srcImgRGB.y, srcImgRGB.x, indexInDestImgBuffer);
}