/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.dock.station.toolbar.menu.AbstractCustomizationMenu;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DefaultCustomizationMenu
extends AbstractCustomizationMenu {
    private JDialog dialog;
    private boolean undecorated = true;
    private boolean closeOnFocusLost = true;

    public void setUndecorated(boolean bl) {
        this.undecorated = bl;
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setCloseOnFocusLost(boolean bl) {
        this.closeOnFocusLost = bl;
    }

    public boolean isCloseOnFocusLost() {
        return this.closeOnFocusLost;
    }

    @Override
    protected void doOpen(int n, int n2, Component component) {
        this.dialog = this.createDialog(this.getCallback().getParent());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                DefaultCustomizationMenu.this.closed();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DefaultCustomizationMenu.this.close();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomizationMenuCallback customizationMenuCallback = DefaultCustomizationMenu.this.getCallback();
                        if (DefaultCustomizationMenu.this.isCloseOnFocusLost() && (customizationMenuCallback == null || customizationMenuCallback.isAutoCloseAllowed())) {
                            DefaultCustomizationMenu.this.close();
                        }
                    }
                });
            }
        });
        this.dialog.setUndecorated(this.undecorated);
        this.dialog.add(component, "Center");
        this.dialog.pack();
        this.dialog.setLocation(n, n2);
        this.validateBounds();
        this.dialog.setVisible(true);
    }

    @Override
    protected void doClose() {
        this.dialog.dispose();
        this.dialog.getContentPane().removeAll();
        this.dialog = null;
    }

    private void validateBounds() {
        Rectangle rectangle = this.dialog.getBounds();
        Point point = this.dialog.getLocation();
        GraphicsConfiguration graphicsConfiguration = null;
        int n = 0;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
            int n2;
            GraphicsConfiguration graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle2 = graphicsConfiguration2.getBounds();
            if (rectangle2.contains(point)) {
                graphicsConfiguration = graphicsConfiguration2;
                n = 0;
                continue;
            }
            int n3 = rectangle2.x <= point.x && rectangle2.x + rectangle2.width >= point.x ? 0 : Math.min(Math.abs(rectangle2.x - point.x), Math.abs(rectangle2.x + rectangle2.width - point.x));
            int n4 = n3 + (n2 = rectangle2.y <= point.y && rectangle2.y + rectangle2.height >= point.y ? 0 : Math.min(Math.abs(rectangle2.y - point.y), Math.abs(rectangle2.y + rectangle2.height - point.y)));
            if (n4 >= n && graphicsConfiguration != null) continue;
            n = n4;
            graphicsConfiguration = graphicsConfiguration2;
        }
        if ((rectangle = this.validateBounds(rectangle, graphicsConfiguration)) != null) {
            this.dialog.setBounds(rectangle);
        }
    }

    protected Rectangle validateBounds(Rectangle rectangle, GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            return null;
        }
        Rectangle rectangle2 = graphicsConfiguration.getBounds();
        rectangle = new Rectangle(rectangle);
        rectangle.width = Math.min(rectangle.width, rectangle2.width);
        rectangle.height = Math.min(rectangle.height, rectangle2.height);
        rectangle.x = Math.min(Math.max(rectangle.x, rectangle2.x), rectangle2.x + rectangle2.width - rectangle.width);
        rectangle.y = Math.min(Math.max(rectangle.y, rectangle2.y), rectangle2.y + rectangle2.height - rectangle.height);
        return rectangle;
    }

    protected JDialog createDialog(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window instanceof Frame) {
            return new JDialog((Frame)window);
        }
        if (window instanceof Dialog) {
            return new JDialog((Dialog)window);
        }
        return new JDialog();
    }
}

