/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.toolbar.item;

import bibliothek.gui.DockController;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarItem;
import bibliothek.gui.dock.ToolbarItemDockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.UIListener;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

public class DockActionItem
implements ToolbarItem {
    public static final ViewTarget<BasicTitleViewItem<JComponent>> TOOLBAR = new ViewTarget("target TOOLBAR");
    private JPanel content = new JPanel(new GridLayout(1, 1));
    private DockAction action;
    private BasicTitleViewItem<JComponent> view;
    private Orientation orientation = Orientation.HORIZONTAL;
    private List<MouseInputListener> mouseListeners = new ArrayList<MouseInputListener>();
    private DockController controller;
    private Dockable dockable;
    private boolean bound = false;
    private UIListener uiListener = new UIListener(){

        @Override
        public void themeWillChange(DockController dockController, DockTheme dockTheme, DockTheme dockTheme2) {
        }

        @Override
        public void themeChanged(DockController dockController, DockTheme dockTheme, DockTheme dockTheme2) {
            DockActionItem.this.destroyView();
            DockActionItem.this.createView();
        }

        @Override
        public void updateUI(DockController dockController) {
            DockActionItem.this.destroyView();
            DockActionItem.this.createView();
        }
    };

    public DockActionItem(DockAction dockAction) {
        if (dockAction == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        this.action = dockAction;
    }

    @Override
    public void setDockable(ToolbarItemDockable toolbarItemDockable) {
        this.dockable = toolbarItemDockable;
    }

    @Override
    public void setController(DockController dockController) {
        if (this.bound) {
            if (this.controller != null) {
                this.controller.getThemeManager().removeUIListener(this.uiListener);
                this.destroyView();
            }
            this.controller = dockController;
            if (dockController != null) {
                this.createView();
                dockController.getThemeManager().addUIListener(this.uiListener);
            }
        } else {
            this.controller = dockController;
        }
    }

    @Override
    public void bind() {
        this.bound = true;
        this.createView();
    }

    @Override
    public void unbind() {
        this.bound = false;
        this.destroyView();
    }

    private void destroyView() {
        if (this.view != null) {
            JComponent jComponent = (JComponent)this.view.getItem();
            for (MouseInputListener mouseInputListener : this.mouseListeners) {
                jComponent.removeMouseListener(mouseInputListener);
                jComponent.removeMouseMotionListener(mouseInputListener);
            }
            this.view.unbind();
            this.view = null;
        }
        this.action.unbind(this.dockable);
        this.content.removeAll();
    }

    private void createView() {
        if (this.bound && this.controller != null) {
            if (this.dockable == null) {
                throw new IllegalStateException("trying to bind the item without knowing its dockable");
            }
            this.action.bind(this.dockable);
            this.view = this.action.createView(TOOLBAR, this.controller.getActionViewConverter(), this.dockable);
            if (this.view != null) {
                this.updateOrientation();
                this.view.bind();
                this.content.add((Component)this.view.getItem());
                JComponent jComponent = (JComponent)this.view.getItem();
                for (MouseInputListener mouseInputListener : this.mouseListeners) {
                    jComponent.addMouseListener(mouseInputListener);
                    jComponent.addMouseMotionListener(mouseInputListener);
                }
            }
        }
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseListeners.add(mouseInputListener);
        if (this.view != null) {
            ((JComponent)this.view.getItem()).addMouseListener(mouseInputListener);
            ((JComponent)this.view.getItem()).addMouseMotionListener(mouseInputListener);
        }
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseListeners.remove(mouseInputListener);
        if (this.view != null) {
            ((JComponent)this.view.getItem()).removeMouseListener(mouseInputListener);
            ((JComponent)this.view.getItem()).removeMouseMotionListener(mouseInputListener);
        }
    }

    @Override
    public Component getComponent() {
        return this.content;
    }

    @Override
    public void setSelected(boolean bl) {
    }

    @Override
    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    private void updateOrientation() {
        if (this.view != null) {
            if (this.orientation == Orientation.HORIZONTAL) {
                this.view.setOrientation(DockTitle.Orientation.FREE_HORIZONTAL);
            } else {
                this.view.setOrientation(DockTitle.Orientation.FREE_VERTICAL);
            }
        }
    }
}

