$(document).ready(function () {
	console.log("[FORM] Load form.js"); //DEBUG
	//empty file field if reset button is clicked
	$("#reset").click(function (e) {
		e.preventDefault();
		// document.location.reload();
		if(confirm("Etes-vous sur de reinitialiser ?")) {
			document.location.reload();
		}
	});

	$("#quit").click(function (e) {
		if (!window.javaMySurveyTicket) {
			alert("javaMySurveyTicket not present can't quit window");
			return;
		}
		window.javaMySurveyTicket.quit();
	});

	$(".toolbar_link").click(function (e) {
		let href = e.currentTarget.href;
		if (!window.javaMySurveyTicket) {
			console.log("No javaMySurveyTicket, opening link from html");
		} else {
			e.preventDefault();
			let href = e.currentTarget.href;
			window.javaMySurveyTicket.openLink(href);
		}
	});




	//post the ticket
	$("#bug_form").submit(function (e) {
		e.preventDefault(); // prevent form submission & page refreshing
		console.log(window.FILES_TO_LOAD)
		window.showModal();
		// prevent missclic
		if (!window.javaMySurveyTicket) {
			alert("javaMySurveyTicket not present, can't send ticket");
			return;
		}
		if (!confirm("Etes-vous sur d'envoyer le ticket ?")) {
			window.closeModal();
			return;
		}

		const fdata = new Map();
		// required fields
		fdata.set("email", $("#email").val());
		fdata.set("subject", $("#subject").val());
		fdata.set("type", $("#ticket_type").val());
		fdata.set("description", $("#description").val());
		fdata.set("priority", $("#priority").val());

		// fixed fields
		fdata.set("custom_fields[cf_test]", "MySurvey"); // "logiciel" field
		fdata.set("status", "2"); // fixed value, 2 correspond to a open ticket
		fdata.set("source", "100"); // source id = 100 corresponds to MySurvey
		
		// the name of the field accepted by feshdesk is 'group_id' but it's 'group' in the json file
		// set default value to "support" for group field
		fdata.set("group_id", "35000179816");

		// optional custom fields
		$(".cf:enabled").each(function () {
			// get all custom fields that are enabled
			if (this.value) {
				// check if value is not empty
				fdata.set("custom_fields[" + this.id + "]", this.value);
			}
		});

		// send data other that files to java
		for (let pair of fdata.entries()) {
			window.javaMySurveyTicket.addFieldValue(pair[0], pair[1]);
		}

		//Send email to java to save it in conf file
		window.javaMySurveyTicket.saveUserData("email", $("#email").val())
		
		// send manually selected file
		window.FILES_TO_LOAD.forEach(function (obj, i) {
			try {
				window.javaMySurveyTicket.addFileFromJS(obj.name, obj.content);
				console.log(obj.name, obj.content);
			} catch (error) {
				console.log(error)
			}
		});

		// if checkbox is checked
		if ($("#auto_screen").attr("src") != "") {
			window.javaMySurveyTicket.autoloadScreen();
		}

		let errorResponse = '';

		if ($("#auto_log").prop("checked")) {
			try {
				window.javaMySurveyTicket.autoloadLog();
			} catch (error) {
				console.log(error + '\n');
			}
		}
		

		// postResquest() return a empty string if success otherwise return the error message
		errorResponse += window.javaMySurveyTicket.postRequest();

		// For some reason, jquerie doesn't work anymore from there
		// console.log("Error response : " + errorResponse); //DEBUG : WebConsoleListener has to be set in BugReportBrowser.java

		// show request responses
		if (errorResponse) {
			document.getElementById("result").innerHTML = "Une erreur est survenue";
			document.getElementById("response").innerHTML = `<p>${errorResponse}</p>`;
			document.getElementById("ticket-body").style.display = "block";
			document.getElementById("ticket-header").style.backgroundColor = "red";
		} else {
			document.getElementById("result").innerHTML = "Ticket envoyé";
			document.getElementById("ticket-body").style.display = "none";
			document.getElementById("ticket-header").style.backgroundColor = "green";
		}
		window.ticketIsRunning = false;

		console.log("[FORM] Done");
	});
});
