#ifndef __OPENCL_VERSION__ //This should fail during an actual openCL compile, used only to trick Eclipse into syntax highlighting this file as "C" code.
#define __kernel
#define __global
#define kernel
#define global
#define constant
#define local
#define float2 float
#define int3 int
#define float3 float
#define float4 float
#define uchar4 char
#endif

float3 corner(int i, float3 bbmin, float3 bbmax) 
{
	float3 vertex = (float3)(0,0,0);
	if (i==0) 		vertex = (float3)(bbmin.x, bbmin.y, bbmin.z);
	else if (i==1) 	vertex = (float3)(bbmax.x, bbmin.y, bbmin.z);
	else if (i==2) 	vertex = (float3)(bbmax.x, bbmax.y, bbmin.z);
	else if (i==3) 	vertex = (float3)(bbmin.x, bbmax.y, bbmin.z);
	else if (i==4) 	vertex = (float3)(bbmin.x, bbmin.y, bbmax.z);
	else if (i==5) 	vertex = (float3)(bbmax.x, bbmin.y, bbmax.z);
	else if (i==6) 	vertex = (float3)(bbmax.x, bbmax.y, bbmax.z);
	else if (i==7) 	vertex = (float3)(bbmin.x, bbmax.y, bbmax.z);
	return vertex;
}
bool getRayCastedSurfaceElementOnRectangle(
		float3 eye, float3 dir, bool bKeepOnlyIfTowards,
		float3 orig, float3 u, float3 v, float3 n, float lengthU, float lengthV,
		float3* point, float3* normal)
{
	float3 inter = (float3)(0,0,0);
	float fNormalDist = INFINITY; 
	bool bIsOnNormalSide = false;
	bool bIntersect = intersectPlaneLine(orig, n, eye, dir, false, &inter, &fNormalDist, &bIsOnNormalSide);
	if (!bIntersect)
		return false;
	float scalu = (inter.x-orig.x)*u.x+(inter.y-orig.y)*u.y+(inter.z-orig.z)*u.z;
	if (fabs(scalu)>0.5f*lengthU)
		return false;
	float scalv = (inter.x-orig.x)*v.x+(inter.y-orig.y)*v.y+(inter.z-orig.z)*v.z;
	if (fabs(scalv)>0.5f*lengthV)
		return false;
	if (bKeepOnlyIfTowards)
	{
		float3 EI = (float3)(inter.x-eye.x, inter.y-eye.y, inter.z-eye.z);
		if (dot(EI, dir)<0)
			return false;
	}
	(*point).x = inter.x;
	(*point).y = inter.y;
	(*point).z = inter.z;
	(*normal).x = n.x;
	(*normal).y = n.y;
	(*normal).z = n.z;
	return true;
}

bool getRayCastedSurfaceElementOnSide(float3 eye, float3 dir, float3 u, float3 v, float3 n, int4 indices,
	float3 bbmin, float3 bbmax, float3* point, float3* normal)
{
	float3 P1 = corner(indices.x, bbmin, bbmax);
	float3 P3 = corner(indices.z, bbmin, bbmax);
	float3 diag = (float3)(P3.x-P1.x, P3.y-P1.y, P3.z-P1.z);
	float halfLu = 0.5f*fabs(dot(diag, u));
	float halfLv = 0.5f*fabs(dot(diag, v));
	float3 C = (float3)(0.5f*(P1.x+P3.x), 0.5f*(P1.y+P3.y), 0.5f*(P1.z+P3.z));
	return getRayCastedSurfaceElementOnRectangle(eye, dir, true, C, u, v, n, 2*halfLu, 2*halfLv, point, normal);
}

bool updateClosestRayCastedSurfaceElementWithSide(float3 eye, float3 dir, float3 u, float3 v, float3 n, int4 indices, float3 bbmin, float3 bbmax, float* closestD, float3* point, float3* normal)
{
	float3 pointSide = (float3)(0,0,0);
	float3 normalSide = (float3)(0,0,0);
	if (!getRayCastedSurfaceElementOnSide(eye, dir, u, v, n, indices, bbmin, bbmax, &pointSide, &normalSide))
		return false;
	
	float d = sqrt((pointSide.x-eye.x)*(pointSide.x-eye.x) + (pointSide.y-eye.y)*(pointSide.y-eye.y) + (pointSide.z-eye.z)*(pointSide.z-eye.z));
	if (d>*closestD)
		return false;

	*closestD = d;
	(*point).x = pointSide.x;
	(*point).y = pointSide.y;
	(*point).z = pointSide.z;
	(*normal).x = normalSide.x;
	(*normal).y = normalSide.y;
	(*normal).z = normalSide.z;
	return true;	
}
bool getRayCastedSurfaceElementAABB(float3 eye, float3 dir, float3 bbmin, float3 bbmax, float3* point, float3* normal)
{
	//On raycast sur chaque face, et on prend le point d'intersection le plus proche
	float closestD = INFINITY;

	//On traite chaque face
	float3 u;
	float3 v;
	float3 n;
	int4 indices;
	bool bOk = false;

	indices = (int4)(3,2,1,0);
	u = (float3)(1,0,0);
	v = (float3)(0,-1,0);
	n = (float3)(0,0,-1);
	if (updateClosestRayCastedSurfaceElementWithSide(eye, dir, u, v, n, indices, bbmin, bbmax, &closestD, point, normal))
		bOk = true;

	indices = (int4)(4,5,6,7);
	u = (float3)(1,0,0);
	v = (float3)(0,1,0);
	n = (float3)(0,0,1);
	if (updateClosestRayCastedSurfaceElementWithSide(eye, dir, u, v, n, indices, bbmin, bbmax, &closestD, point, normal))
		bOk = true;

	indices = (int4)(0,1,5,4);
	u = (float3)(1,0,0);
	v = (float3)(0,0,1);
	n = (float3)(0,-1,0);
	if (updateClosestRayCastedSurfaceElementWithSide(eye, dir, u, v, n, indices, bbmin, bbmax, &closestD, point, normal))
		bOk = true;

	indices = (int4)(1,2,6,5);
	u = (float3)(0,1,0);
	v = (float3)(0,0,1);
	n = (float3)(1,0,0);
	if (updateClosestRayCastedSurfaceElementWithSide(eye, dir, u, v, n, indices, bbmin, bbmax, &closestD, point, normal))
		bOk = true;

	indices = (int4)(2,3,7,6);
	u = (float3)(-1,0,0);
	v = (float3)(0,0,1);
	n = (float3)(0,1,0);
	if (updateClosestRayCastedSurfaceElementWithSide(eye, dir, u, v, n, indices, bbmin, bbmax, &closestD, point, normal))
		bOk = true;

	indices = (int4)(3,0,4,7);
	u = (float3)(0,-1,0);
	v = (float3)(0,0,1);
	n = (float3)(-1,0,0);
	if (updateClosestRayCastedSurfaceElementWithSide(eye, dir, u, v, n, indices, bbmin, bbmax, &closestD, point, normal))
		bOk = true;

	return bOk;
}