/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategy;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupSpanStrategy;
import bibliothek.gui.dock.station.toolbar.layout.DockablePlaceholderToolbarGrid;
import bibliothek.gui.dock.station.toolbar.layout.ToolbarGridLayoutManagerListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class ToolbarGridLayoutManager<P extends PlaceholderListItem<Dockable>>
implements LayoutManager2 {
    private final DockablePlaceholderToolbarGrid<P> grid;
    private final Orientation orientation;
    private Container parent;
    private ToolbarGroupSpanStrategy<P> spans;
    private boolean useScrollbars = true;
    private Wrapper[][] cachedComponents;
    private List<ToolbarGridLayoutManagerListener> listeners = new ArrayList<ToolbarGridLayoutManagerListener>();

    public ToolbarGridLayoutManager(Container container, Orientation orientation, DockablePlaceholderToolbarGrid<P> dockablePlaceholderToolbarGrid, ToolbarGroupDockStation toolbarGroupDockStation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (dockablePlaceholderToolbarGrid == null) {
            throw new IllegalArgumentException("grid must not be null");
        }
        if (container == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        this.orientation = orientation;
        this.grid = dockablePlaceholderToolbarGrid;
        this.parent = container;
        this.spans = new ToolbarGroupSpanStrategy<P>(dockablePlaceholderToolbarGrid, toolbarGroupDockStation){

            @Override
            protected void handleResized() {
                Container container = ToolbarGridLayoutManager.this.parent;
                if (container instanceof JComponent) {
                    ((JComponent)container).revalidate();
                }
            }
        };
    }

    public void setController(DockController dockController) {
        this.spans.setController(dockController);
    }

    public void setDividerStrategy(ToolbarGroupDividerStrategy toolbarGroupDividerStrategy) {
        this.spans.setDividers(toolbarGroupDividerStrategy);
    }

    public void mutate() {
        this.mutate(-1);
    }

    public void mutate(int n) {
        this.spans.mutate(n);
    }

    public void mutate(int n, int n2) {
        this.spans.mutate(n, n2);
    }

    protected abstract Component toComponent(P var1);

    protected abstract void setShowScrollbar(int var1, boolean var2);

    protected abstract int getScrollbarValue(int var1, int var2, int var3);

    protected abstract Component getScrollbar(int var1);

    protected Wrapper[][] layout() {
        int n;
        if (this.cachedComponents != null) {
            if (this.cachedComponents.length != this.grid.getColumnCount()) {
                this.cachedComponents = null;
            } else {
                n = this.cachedComponents.length;
                for (int i = 0; i < n && this.cachedComponents != null; ++i) {
                    if (this.cachedComponents[i].length == this.grid.getColumn(i).dockables().size()) continue;
                    this.cachedComponents = null;
                }
            }
        }
        if (this.cachedComponents == null) {
            Wrapper[][] wrapperArrayArray = new Wrapper[this.grid.getColumnCount()][];
            for (n = 0; n < wrapperArrayArray.length; ++n) {
                ArrayList<Wrapper> arrayList = new ArrayList<Wrapper>();
                Iterator iterator = this.grid.getColumnContent(n);
                while (iterator.hasNext()) {
                    arrayList.add(new Wrapper(this.toComponent((PlaceholderListItem)iterator.next())));
                }
                wrapperArrayArray[n] = arrayList.toArray(new Wrapper[arrayList.size()]);
            }
            this.cachedComponents = wrapperArrayArray;
        }
        return this.cachedComponents;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.cachedComponents = null;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.cachedComponents = null;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this.cachedComponents = null;
    }

    public int getColumnAt(int n) {
        int n2 = 0;
        int n3 = this.grid.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            Rectangle rectangle = this.getBounds(i);
            if (this.orientation == Orientation.VERTICAL ? rectangle.x + rectangle.width > n : rectangle.y + rectangle.height > n) break;
        }
        return n2;
    }

    public boolean isColumnAt(int n) {
        int n2 = this.grid.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Rectangle rectangle = this.getBounds(i);
            if (!(this.orientation == Orientation.VERTICAL ? rectangle.x <= n && rectangle.x + rectangle.width > n : rectangle.y <= n && rectangle.y + rectangle.height > n)) continue;
            return true;
        }
        return false;
    }

    public int getInsertionLineAt(int n, int n2) {
        int n3 = this.grid.getLineCount(n);
        for (int i = 0; i < n3; ++i) {
            Rectangle rectangle = this.getBounds(n, i);
            if (!(this.orientation == Orientation.HORIZONTAL ? rectangle.x + rectangle.width / 2 >= n2 : rectangle.y + rectangle.height / 2 >= n2)) continue;
            return i;
        }
        return n3;
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.layoutSize(container, this.layout(), Size.MAXIMUM);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.layoutSize(container, this.layout(), Size.PREFERRED);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.layoutSize(container, this.layout(), Size.MINIMUM);
    }

    private Dimension layoutSize(Container container, Wrapper[][] wrapperArray, Size size) {
        int n;
        int n2;
        block8: {
            int n3;
            block7: {
                int n4;
                this.spans.reset(false);
                n2 = 0;
                n = 0;
                if (this.orientation != Orientation.HORIZONTAL) break block7;
                int n5 = 0;
                for (Wrapper[] wrapperArray2 : wrapperArray) {
                    Dimension dimension = this.layoutSize(n5++, wrapperArray2, size);
                    n2 = Math.max(n2, dimension.width);
                    n += dimension.height;
                }
                for (n4 = 0; n4 <= wrapperArray.length; ++n4) {
                    n += this.spans.getColumn(n4);
                }
                if (!this.useScrollbars) break block8;
                for (n4 = 0; n4 < wrapperArray.length; ++n4) {
                    Component component = this.getScrollbar(n4);
                    if (component == null) continue;
                    n += size.get((Component)component).height;
                }
                break block8;
            }
            int n6 = 0;
            for (Wrapper[] wrapperArray3 : wrapperArray) {
                Dimension dimension = this.layoutSize(n6++, wrapperArray3, size);
                n = Math.max(n, dimension.height);
                n2 += dimension.width;
            }
            for (n3 = 0; n3 <= wrapperArray.length; ++n3) {
                n2 += this.spans.getColumn(n3);
            }
            if (this.useScrollbars) {
                for (n3 = 0; n3 < wrapperArray.length; ++n3) {
                    Component component = this.getScrollbar(n3);
                    if (component == null) continue;
                    n2 += size.get((Component)component).width;
                }
            }
        }
        return new Dimension(n2, n);
    }

    private Dimension layoutSize(int n, Wrapper[] wrapperArray, Size size) {
        int n2 = 0;
        int n3 = 0;
        if (this.orientation == Orientation.HORIZONTAL) {
            for (Wrapper wrapper : wrapperArray) {
                wrapper.reset(size);
                Dimension dimension = wrapper.required;
                n2 += dimension.width;
                n3 = Math.max(dimension.height, n3);
            }
            for (int i = 0; i <= wrapperArray.length; ++i) {
                n2 += this.spans.getLine(n, i);
            }
        } else {
            for (Wrapper wrapper : wrapperArray) {
                wrapper.reset(size);
                Dimension dimension = wrapper.required;
                n3 += dimension.height;
                n2 = Math.max(dimension.width, n2);
            }
            for (int i = 0; i <= wrapperArray.length; ++i) {
                n3 += this.spans.getLine(n, i);
            }
        }
        return new Dimension(n2, n3);
    }

    public void addListener(ToolbarGridLayoutManagerListener toolbarGridLayoutManagerListener) {
        this.listeners.add(toolbarGridLayoutManagerListener);
    }

    public void removeListener(ToolbarGridLayoutManagerListener toolbarGridLayoutManagerListener) {
        this.listeners.remove(toolbarGridLayoutManagerListener);
    }

    @Override
    public void layoutContainer(Container container) {
        Wrapper[][] wrapperArray = this.layout();
        Dimension dimension = container.getSize();
        Dimension dimension2 = this.layoutSize(container, wrapperArray, Size.PREFERRED);
        if (dimension2.width <= dimension.width && dimension2.height <= dimension.height) {
            this.layout(container, wrapperArray, dimension2, dimension, Size.PREFERRED);
        } else {
            this.layout(container, wrapperArray, this.layoutSize(container, wrapperArray, Size.MINIMUM), dimension, Size.MINIMUM);
        }
        for (ToolbarGridLayoutManagerListener toolbarGridLayoutManagerListener : this.listeners) {
            toolbarGridLayoutManagerListener.didLayout(container);
        }
    }

    protected void layout(Container container, Wrapper[][] wrapperArray, Dimension dimension, Dimension dimension2, Size size) {
        if (wrapperArray.length == 0 || dimension2.width < 1 || dimension2.height < 1) {
            return;
        }
        Dimension[] dimensionArray = new Dimension[wrapperArray.length];
        for (int i = 0; i < dimensionArray.length; ++i) {
            dimensionArray[i] = this.layoutSize(i, wrapperArray[i], size);
        }
        if (this.orientation == Orientation.HORIZONTAL) {
            int n;
            int n2;
            double d = (double)dimension2.height / (double)dimension.height;
            if (d < 1.0) {
                n2 = 0;
                int n3 = dimensionArray.length - 1;
                for (n = 0; n < n3; ++n) {
                    dimensionArray[n].height = (int)(d * (double)dimensionArray[n].height);
                    n2 += dimensionArray[n].height;
                    n2 += (int)(d * (double)this.spans.getColumn(n));
                }
                dimensionArray[dimensionArray.length - 1].height = Math.min(dimension2.height - (n2 += (int)(d * (double)this.spans.getColumn(dimensionArray.length))), dimensionArray[dimensionArray.length - 1].height);
            } else {
                d = 1.0;
            }
            n2 = 0;
            for (n = 0; n < dimensionArray.length; ++n) {
                n2 = (int)((double)n2 + (double)this.spans.getColumn(n) * d);
                this.layout(wrapperArray[n], n, dimensionArray[n], dimension2, n2);
                n2 += dimensionArray[n].height;
                Component component = this.getScrollbar(n);
                if (component == null) continue;
                int n4 = (int)((double)size.get((Component)component).height * d);
                component.setBounds(0, n2, dimension2.width, n4);
                n2 += n4;
            }
        } else {
            int n;
            int n5;
            double d = (double)dimension2.width / (double)dimension.width;
            if (d < 1.0) {
                n5 = 0;
                int n6 = dimensionArray.length - 1;
                for (n = 0; n < n6; ++n) {
                    dimensionArray[n].width = (int)(d * (double)dimensionArray[n].width);
                    n5 += dimensionArray[n].width;
                    n5 += (int)(d * (double)this.spans.getColumn(n));
                }
                dimensionArray[dimensionArray.length - 1].width = Math.min(dimension2.width - (n5 += (int)(d * (double)this.spans.getColumn(dimensionArray.length))), dimensionArray[dimensionArray.length - 1].width);
            } else {
                d = 1.0;
            }
            n5 = 0;
            for (n = 0; n < dimensionArray.length; ++n) {
                n5 = (int)((double)n5 + (double)this.spans.getColumn(n) * d);
                this.layout(wrapperArray[n], n, dimensionArray[n], dimension2, n5);
                n5 += dimensionArray[n].width;
                Component component = this.getScrollbar(n);
                if (component == null) continue;
                int n7 = (int)((double)size.get((Component)component).width * d);
                component.setBounds(n5, 0, n7, dimension2.height);
                n5 += n7;
            }
        }
    }

    private void layout(Wrapper[] wrapperArray, int n, Dimension dimension, Dimension dimension2, int n2) {
        if (this.orientation == Orientation.HORIZONTAL) {
            int n3;
            int n4;
            int n5;
            double d = (double)dimension2.width / (double)dimension.width;
            if (d < 1.0) {
                if (this.useScrollbars) {
                    d = 1.0;
                    this.setShowScrollbar(n, true);
                } else {
                    n5 = 0;
                    n4 = wrapperArray.length - 1;
                    for (n3 = 0; n3 < n4; ++n3) {
                        Dimension dimension3 = wrapperArray[n3].required;
                        dimension3.width = (int)((double)dimension3.width * d);
                        n5 += dimension3.width;
                    }
                    wrapperArray[wrapperArray.length - 1].required.width = dimension2.width - n5;
                }
            } else {
                d = 1.0;
                if (this.useScrollbars) {
                    this.setShowScrollbar(n, false);
                }
            }
            n5 = -this.getScrollbarValue(n, dimension.width, dimension2.width);
            n3 = n2;
            for (n4 = 0; n4 < wrapperArray.length; ++n4) {
                n5 = (int)((double)n5 + (double)this.spans.getLine(n, n4) * d);
                wrapperArray[n4].component.setBounds(n5, n3, wrapperArray[n4].required.width, dimension.height);
                n5 += wrapperArray[n4].required.width;
            }
        } else {
            int n6;
            int n7;
            int n8;
            double d = (double)dimension2.height / (double)dimension.height;
            if (d < 1.0) {
                if (this.useScrollbars) {
                    d = 1.0;
                    this.setShowScrollbar(n, true);
                } else {
                    n8 = 0;
                    n7 = wrapperArray.length - 1;
                    for (n6 = 0; n6 < n7; ++n6) {
                        Dimension dimension4 = wrapperArray[n6].required;
                        dimension4.height = (int)((double)dimension4.height * d);
                        n8 += dimension4.height;
                    }
                    wrapperArray[wrapperArray.length - 1].required.height = dimension2.height - n8;
                }
            } else {
                d = 1.0;
                if (this.useScrollbars) {
                    this.setShowScrollbar(n, false);
                }
            }
            n8 = n2;
            n6 = -this.getScrollbarValue(n, dimension.height, dimension2.height);
            for (n7 = 0; n7 < wrapperArray.length; ++n7) {
                n6 = (int)((double)n6 + (double)this.spans.getLine(n, n7) * d);
                wrapperArray[n7].component.setBounds(n8, n6, dimension.width, wrapperArray[n7].required.height);
                n6 += wrapperArray[n7].required.height;
            }
        }
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
        this.cachedComponents = null;
    }

    public Rectangle getBounds(int n, int n2) {
        Wrapper[][] wrapperArray = this.layout();
        if (n < 0 || n >= wrapperArray.length) {
            throw new IllegalArgumentException("column out of bounds: " + n);
        }
        if (n2 < 0 || n2 >= wrapperArray[n].length) {
            throw new IllegalArgumentException("line out of bounds: " + n2);
        }
        return wrapperArray[n][n2].getBounds();
    }

    public Rectangle getScreenBounds(int n, int n2) {
        Wrapper[][] wrapperArray = this.layout();
        if (n < 0 || n >= wrapperArray.length) {
            throw new IllegalArgumentException("column out of bounds: " + n);
        }
        if (n2 < 0 || n2 >= wrapperArray[n].length) {
            throw new IllegalArgumentException("line out of bounds: " + n2);
        }
        return wrapperArray[n][n2].getScreenBounds();
    }

    public Rectangle getBounds(int n) {
        Wrapper[][] wrapperArray = this.layout();
        return this.getBounds(n, wrapperArray);
    }

    public Rectangle getScreenBounds(int n) {
        Wrapper[][] wrapperArray = this.layout();
        return this.getScreenBounds(n, wrapperArray);
    }

    private Rectangle getBounds(int n, Wrapper[][] wrapperArray) {
        if (n < 0 || n >= wrapperArray.length) {
            throw new IllegalArgumentException("column out of bounds: " + n);
        }
        Rectangle rectangle = null;
        for (Wrapper wrapper : wrapperArray[n]) {
            rectangle = rectangle == null ? wrapper.getBounds() : rectangle.union(wrapper.getBounds());
        }
        int n2 = this.spans.getLine(n, 0);
        if (this.orientation == Orientation.HORIZONTAL) {
            rectangle.x -= n2;
            rectangle.width += n2;
        } else {
            rectangle.y -= n2;
            rectangle.height += n2;
        }
        int n3 = wrapperArray[n].length;
        if (n3 > 0) {
            int n4 = this.spans.getLine(n, n3);
            if (this.orientation == Orientation.HORIZONTAL) {
                rectangle.width += n4;
            } else {
                rectangle.height += n4;
            }
        }
        return rectangle;
    }

    private Rectangle getScreenBounds(int n, Wrapper[][] wrapperArray) {
        if (n < 0 || n >= wrapperArray.length) {
            throw new IllegalArgumentException("column out of bounds: " + n);
        }
        Rectangle rectangle = null;
        for (Wrapper wrapper : wrapperArray[n]) {
            rectangle = rectangle == null ? wrapper.getScreenBounds() : rectangle.union(wrapper.getScreenBounds());
        }
        return rectangle;
    }

    public Rectangle getGapBounds(int n, boolean bl) {
        Component component;
        Wrapper[][] wrapperArray = this.layout();
        Rectangle rectangle = n == 0 ? new Rectangle(0, 0, 0, 0) : this.getBounds(n - 1, wrapperArray);
        Rectangle rectangle2 = null;
        if (n == wrapperArray.length) {
            rectangle2 = new Rectangle(0, 0, 0, 0);
            if (this.orientation == Orientation.HORIZONTAL) {
                rectangle2.y = this.parent.getHeight();
            } else {
                rectangle2.x = this.parent.getWidth();
            }
        } else {
            rectangle2 = this.getBounds(n, wrapperArray);
        }
        if (rectangle == null || rectangle2 == null) {
            return null;
        }
        if (this.orientation == Orientation.HORIZONTAL) {
            Component component2;
            int n2 = Math.min(rectangle.x, rectangle2.x);
            int n3 = rectangle.y + rectangle.height;
            int n4 = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width) - n2;
            int n5 = rectangle2.y - n3;
            if (!bl && n > 0 && (component2 = this.getScrollbar(n - 1)) != null) {
                n2 += component2.getWidth();
                n4 -= component2.getWidth();
            }
            return new Rectangle(n2, n3, n4, n5);
        }
        int n6 = rectangle.x + rectangle.width;
        int n7 = Math.min(rectangle.y, rectangle2.y);
        int n8 = rectangle2.x - n6;
        int n9 = Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - n7;
        if (!bl && n > 0 && (component = this.getScrollbar(n - 1)) != null) {
            n6 += component.getWidth();
            n8 -= component.getWidth();
        }
        return new Rectangle(n6, n7, n8, n9);
    }

    public Rectangle getGapBounds(int n, int n2) {
        Wrapper[][] wrapperArray = this.layout();
        int n3 = this.spans.getLine(n, n2);
        if (this.orientation == Orientation.HORIZONTAL) {
            int n4 = Integer.MAX_VALUE;
            int n5 = 0;
            for (Wrapper wrapper : wrapperArray[n]) {
                Rectangle rectangle = wrapper.getBounds();
                n4 = Math.min(n4, rectangle.y);
                n5 = Math.max(n5, n4 - rectangle.y + rectangle.height);
            }
            if (n2 == 0) {
                return new Rectangle(wrapperArray[n][n2].getBounds().x - n3, n4, n3, n5);
            }
            Rectangle object = wrapperArray[n][n2 - 1].getBounds();
            return new Rectangle(object.x + object.width, n4, n3, n5);
        }
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        for (Wrapper wrapper : wrapperArray[n]) {
            Rectangle rectangle = wrapper.getBounds();
            n6 = Math.min(n6, rectangle.x);
            n7 = Math.max(n7, n6 - rectangle.x + rectangle.width);
        }
        if (n2 == 0) {
            return new Rectangle(n6, wrapperArray[n][n2].getBounds().y - n3, n7, n3);
        }
        Rectangle rectangle = wrapperArray[n][n2 - 1].getBounds();
        return new Rectangle(n6, rectangle.y + rectangle.height, n7, n3);
    }

    protected class Wrapper {
        public Component component;
        public Dimension required;
        private Size size;

        public Wrapper(Component component) {
            this.component = component;
        }

        public void reset(Size size) {
            if (this.size != size) {
                this.size = size;
                this.required = new Dimension(size.get(this.component));
            }
        }

        public Rectangle getBounds() {
            return this.component.getBounds();
        }

        public Rectangle getScreenBounds() {
            Rectangle rectangle = this.component.getBounds();
            Point point = rectangle.getLocation();
            SwingUtilities.convertPointToScreen(point, this.component);
            Rectangle rectangle2 = new Rectangle(point, new Dimension(rectangle.width, rectangle.height));
            return rectangle2;
        }
    }

    private static enum Size {
        MAXIMUM,
        MINIMUM,
        PREFERRED;


        public Dimension get(Component component) {
            switch (this) {
                case MAXIMUM: {
                    return component.getMaximumSize();
                }
                case MINIMUM: {
                    return component.getMinimumSize();
                }
                case PREFERRED: {
                    return component.getPreferredSize();
                }
            }
            throw new IllegalStateException();
        }
    }
}

