/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.Dockable;
import bibliothek.gui.ToolbarExtension;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSource;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockTitle;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class ToolbarGroupTitle
extends ColumnDockTitle {
    public static final DockTitleFactory FACTORY = new DockTitleFactory(){

        @Override
        public void uninstall(DockTitleRequest dockTitleRequest) {
        }

        @Override
        public void request(DockTitleRequest dockTitleRequest) {
            dockTitleRequest.answer(new ToolbarGroupTitle(dockTitleRequest.getTarget(), dockTitleRequest.getVersion()));
        }

        @Override
        public void install(DockTitleRequest dockTitleRequest) {
        }
    };
    protected TitleColor color;

    public ToolbarGroupTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        super(dockable, dockTitleVersion);
        this.setTransparency(Transparency.DEFAULT);
        this.color = new TitleColor("extension.toolbar.group.title", (DockTitle)this, new Color(80, 80, 80)){

            @Override
            protected void changed(Color color, Color color2) {
                ToolbarGroupTitle.this.repaint();
            }
        };
        this.addColor(this.color);
    }

    @Override
    protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(dockAction, ToolbarExtension.TOOLBAR_TITLE, dockable);
    }

    @Override
    protected Insets getInnerInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    protected ColumnDockActionSource getSourceFor(Dockable dockable) {
        if (dockable instanceof ToolbarGroupDockStation) {
            return ((ToolbarGroupDockStation)dockable).getExpandActionSource();
        }
        return null;
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        this.repaint();
    }

    @Override
    public void paintBackground(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.color.color());
        if (this.getOrientation().isHorizontal()) {
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight() * 2, 8.0, 8.0);
            graphics2D.fill(double_);
        } else {
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() * 2, this.getHeight(), 8.0, 8.0);
            graphics2D.fill(double_);
        }
        graphics2D.dispose();
    }
}

