/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnListener;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModelListener;
import bibliothek.gui.dock.station.toolbar.layout.PlaceholderToolbarGrid;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ModeledPlaceholderToolbarGrid<D, S, P extends PlaceholderListItem<D>>
extends PlaceholderToolbarGrid<D, S, P> {
    private Model model = new Model();

    public ToolbarColumnModel<D, P> getModel() {
        return this.model;
    }

    @Override
    protected void onInserted(PlaceholderList<D, S, P> placeholderList, int n, P p, int n2) {
        this.model.getColumn(n).onInserted(p, n2);
    }

    @Override
    protected void onRemoved(PlaceholderList<D, S, P> placeholderList, int n, P p, int n2) {
        this.model.getColumn(n).onRemoved(p, n2);
    }

    @Override
    protected void onInserted(PlaceholderList<D, S, P> placeholderList, int n) {
        this.model.onInserted(n);
    }

    @Override
    protected void onRemoved(PlaceholderList<D, S, P> placeholderList, int n) {
        for (int i = placeholderList.dockables().size() - 1; i >= 0; --i) {
            this.model.getColumn(n).onRemoved((PlaceholderListItem)placeholderList.dockables().get(i), i);
        }
        this.model.onRemoved(n);
    }

    @Override
    protected void onInserted() {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.model.onInserted(i);
            int n2 = 0;
            Iterator iterator = this.getColumnContent(i);
            while (iterator.hasNext()) {
                this.model.getColumn(i).onInserted((PlaceholderListItem)iterator.next(), n2++);
            }
        }
    }

    @Override
    protected void onRemoved() {
        for (int i = this.model.getColumnCount() - 1; i >= 0; ++i) {
            Column column = this.model.getColumn(i);
            for (int j = column.getDockableCount() - 1; j >= 0; --j) {
                this.model.getColumn(i).onRemoved(column.getItem(j), j);
            }
            this.model.onRemoved(i);
        }
    }

    private class Column
    implements ToolbarColumn<D, P> {
        private List<P> items = new ArrayList();
        private List<ToolbarColumnListener<D, P>> listeners = new ArrayList();

        private Column() {
        }

        public void onInserted(P p, int n) {
            this.items.add(n, p);
            for (ToolbarColumnListener toolbarColumnListener : this.listeners()) {
                toolbarColumnListener.inserted(this, p, p.asDockable(), n);
            }
        }

        public void onRemoved(P p, int n) {
            this.items.remove(n);
            for (ToolbarColumnListener toolbarColumnListener : this.listeners()) {
                toolbarColumnListener.removed(this, p, p.asDockable(), n);
            }
        }

        public boolean contains(D d) {
            for (PlaceholderListItem placeholderListItem : this.items) {
                if (placeholderListItem.asDockable() != d) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getColumnIndex() {
            return ModeledPlaceholderToolbarGrid.this.model.columns.indexOf(this);
        }

        @Override
        public int getDockableCount() {
            return this.items.size();
        }

        @Override
        public D getDockable(int n) {
            return ((PlaceholderListItem)this.items.get(n)).asDockable();
        }

        @Override
        public int indexOf(Dockable dockable) {
            int n = this.getDockableCount();
            for (int i = 0; i < n; ++i) {
                if (this.getDockable(i) != dockable) continue;
                return i;
            }
            return -1;
        }

        @Override
        public P getItem(int n) {
            return (PlaceholderListItem)this.items.get(n);
        }

        private ToolbarColumnListener<D, P>[] listeners() {
            return this.listeners.toArray(new ToolbarColumnListener[this.listeners.size()]);
        }

        @Override
        public void addListener(ToolbarColumnListener<D, P> toolbarColumnListener) {
            if (toolbarColumnListener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            this.listeners.add(toolbarColumnListener);
        }

        @Override
        public void removeListener(ToolbarColumnListener<D, P> toolbarColumnListener) {
            this.listeners.remove(toolbarColumnListener);
        }
    }

    private class Model
    implements ToolbarColumnModel<D, P> {
        private List<ToolbarColumnModelListener<D, P>> modelListeners = new ArrayList();
        private List<Column> columns = new ArrayList<Column>();

        private Model() {
        }

        @Override
        public void addListener(ToolbarColumnModelListener<D, P> toolbarColumnModelListener) {
            if (toolbarColumnModelListener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            this.modelListeners.add(toolbarColumnModelListener);
        }

        @Override
        public void removeListener(ToolbarColumnModelListener<D, P> toolbarColumnModelListener) {
            this.modelListeners.remove(toolbarColumnModelListener);
        }

        protected ToolbarColumnModelListener<D, P>[] listeners() {
            return this.modelListeners.toArray(new ToolbarColumnModelListener[this.modelListeners.size()]);
        }

        public Column getColumn(int n) {
            return this.columns.get(n);
        }

        public Column getColumn(D d) {
            for (Column column : this.columns) {
                if (!column.contains(d)) continue;
                return column;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return this.columns.size();
        }

        public void onInserted(int n) {
            Column column = new Column();
            this.columns.add(n, column);
            for (ToolbarColumnModelListener toolbarColumnModelListener : this.listeners()) {
                toolbarColumnModelListener.inserted(this, column, n);
            }
        }

        public void onRemoved(int n) {
            Column column = this.columns.remove(n);
            for (ToolbarColumnModelListener toolbarColumnModelListener : this.listeners()) {
                toolbarColumnModelListener.removed(this, column, n);
            }
        }
    }
}

