/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.layout.DockableGridPlaceholderList;
import bibliothek.gui.dock.station.toolbar.layout.GridPlaceholderList;
import bibliothek.gui.dock.station.toolbar.layout.ModeledPlaceholderToolbarGrid;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DockablePlaceholderToolbarGrid<P extends PlaceholderListItem<Dockable>>
extends ModeledPlaceholderToolbarGrid<Dockable, DockStation, P> {
    public DockablePlaceholderToolbarGrid() {
        this.init();
    }

    @Override
    protected PlaceholderList<Dockable, DockStation, P> createColumn() {
        return new DockablePlaceholderList();
    }

    @Override
    protected GridPlaceholderList<Dockable, DockStation, P> createGrid() {
        return new DockableGridPlaceholderList();
    }

    @Override
    protected Set<Path> getPlaceholders(Dockable dockable) {
        final PlaceholderStrategy placeholderStrategy = this.getStrategy();
        if (placeholderStrategy == null) {
            return Collections.emptySet();
        }
        final HashSet<Path> hashSet = new HashSet<Path>();
        DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

            @Override
            public void handleDockable(Dockable dockable) {
                Path path = placeholderStrategy.getPlaceholderFor(dockable);
                if (path != null) {
                    hashSet.add(path);
                }
            }

            @Override
            public void handleDockStation(DockStation dockStation) {
                PlaceholderMap placeholderMap = dockStation.getPlaceholders();
                if (placeholderMap != null) {
                    for (PlaceholderMap.Key key : placeholderMap.getPlaceholders()) {
                        for (Path path : key.getPlaceholders()) {
                            hashSet.add(path);
                        }
                    }
                }
            }
        });
        return hashSet;
    }

    @Override
    protected void fill(Dockable dockable, ConvertedPlaceholderListItem convertedPlaceholderListItem) {
        Object object;
        PlaceholderStrategy placeholderStrategy = this.getStrategy();
        if (placeholderStrategy != null && (object = placeholderStrategy.getPlaceholderFor(dockable)) != null) {
            convertedPlaceholderListItem.putString("placeholder", ((Path)object).toString());
            convertedPlaceholderListItem.setPlaceholder((Path)object);
        }
        if ((object = dockable.asDockStation()) != null) {
            convertedPlaceholderListItem.setPlaceholderMap(object.getPlaceholders());
        }
    }
}

