/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.control.relocator.Inserter;
import bibliothek.gui.dock.control.relocator.InserterSource;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.station.OrientedDockStation;
import bibliothek.gui.dock.station.OrientingDockStation;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Dimension;

public class ScreenToolbarInserter
implements Inserter {
    private final DockController controller;

    public ScreenToolbarInserter(DockController dockController) {
        this.controller = dockController;
    }

    @Override
    public StationDropOperation before(InserterSource inserterSource) {
        return null;
    }

    protected ToolbarStrategy getStrategy() {
        return this.controller.getProperties().get(ToolbarStrategy.STRATEGY);
    }

    @Override
    public StationDropOperation after(InserterSource inserterSource) {
        Dockable dockable;
        if (inserterSource.getOperation() != null || !(inserterSource.getParent() instanceof ScreenDockStation)) {
            return null;
        }
        ToolbarStrategy toolbarStrategy = this.getStrategy();
        if (!toolbarStrategy.isToolbarPart(dockable = inserterSource.getItem().getDockable())) {
            return null;
        }
        boolean bl = DockUtilities.acceptable(inserterSource.getParent(), dockable);
        if (!bl) {
            return null;
        }
        return new Operation(inserterSource);
    }

    protected void execute(InserterSource inserterSource, Orientation orientation) {
        ToolbarStrategy toolbarStrategy = this.getStrategy();
        Dockable dockable = inserterSource.getItem().getDockable();
        Dockable dockable2 = toolbarStrategy.ensureToolbarLayer(inserterSource.getParent(), dockable);
        if (dockable2 != dockable) {
            dockable2.setController(this.controller);
            dockable2.asDockStation().drop(dockable);
            dockable2.setController(null);
        }
        if (orientation != null && dockable2.asDockStation() instanceof OrientedDockStation) {
            ((OrientedDockStation)((Object)dockable2)).setOrientation(orientation);
        }
        ScreenDockStation screenDockStation = (ScreenDockStation)inserterSource.getParent();
        dockable2.getComponent().validate();
        Dimension dimension = dockable2.getComponent().getPreferredSize();
        ScreenDockProperty screenDockProperty = new ScreenDockProperty(inserterSource.getItem().getTitleX(), inserterSource.getItem().getTitleY(), dimension.width, dimension.height);
        screenDockStation.drop(dockable2, screenDockProperty, false);
    }

    private class Operation
    implements StationDropOperation {
        private final InserterSource source;
        private Orientation orientation;

        public Operation(InserterSource inserterSource) {
            this.source = inserterSource;
            Dockable dockable = inserterSource.getItem().getDockable();
            DockStation dockStation = dockable.getDockParent();
            this.orientation = null;
            if (dockStation instanceof OrientingDockStation) {
                this.orientation = ((OrientingDockStation)dockStation).getOrientationOf(dockable);
            } else if (dockable.asDockStation() instanceof OrientedDockStation) {
                this.orientation = ((OrientedDockStation)dockable.asDockStation()).getOrientation();
            }
        }

        @Override
        public void draw() {
        }

        @Override
        public void destroy(StationDropOperation stationDropOperation) {
        }

        @Override
        public boolean isMove() {
            return false;
        }

        @Override
        public void execute() {
            ScreenToolbarInserter.this.execute(this.source, this.orientation);
        }

        @Override
        public DockStation getTarget() {
            return this.source.getParent();
        }

        @Override
        public Dockable getItem() {
            return this.source.getItem().getDockable();
        }

        @Override
        public CombinerTarget getCombination() {
            return null;
        }

        @Override
        public DisplayerCombinerTarget getDisplayerCombination() {
            return null;
        }
    }
}

