/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanMode;
import bibliothek.gui.dock.station.span.SpanUsage;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategy;
import bibliothek.gui.dock.station.toolbar.layout.DockablePlaceholderToolbarGrid;
import bibliothek.gui.dock.themes.StationSpanFactoryValue;

public abstract class ToolbarGroupSpanStrategy<P extends PlaceholderListItem<Dockable>> {
    private DockablePlaceholderToolbarGrid<P> grid;
    private Span[] columnSpans = new Span[0];
    private Span[][] lineSpans = new Span[0][];
    private StationSpanFactoryValue factory;
    private ToolbarGroupDockStation station;
    private ToolbarGroupDividerStrategy dividers = ToolbarGroupDividerStrategy.NULL;
    private int currentColumn = -1;
    private int currentLine = -1;

    public ToolbarGroupSpanStrategy(DockablePlaceholderToolbarGrid<P> dockablePlaceholderToolbarGrid, ToolbarGroupDockStation toolbarGroupDockStation) {
        this.grid = dockablePlaceholderToolbarGrid;
        this.station = toolbarGroupDockStation;
        this.factory = new StationSpanFactoryValue("dock.spanFactory.toolbar.group", toolbarGroupDockStation){

            @Override
            protected void changed() {
                ToolbarGroupSpanStrategy.this.reset(true);
            }
        };
    }

    public void setDividers(ToolbarGroupDividerStrategy toolbarGroupDividerStrategy) {
        if (toolbarGroupDividerStrategy == null) {
            toolbarGroupDividerStrategy = ToolbarGroupDividerStrategy.NULL;
        }
        this.dividers = toolbarGroupDividerStrategy;
        this.handleResized();
    }

    protected abstract void handleResized();

    public void setController(DockController dockController) {
        this.factory.setController(dockController);
    }

    public void reset(boolean bl) {
        if (bl || this.isOutdated()) {
            int n;
            this.columnSpans = new Span[this.grid.getColumnCount() + 1];
            for (n = 0; n < this.columnSpans.length; ++n) {
                this.columnSpans[n] = this.createSpan(true);
            }
            this.lineSpans = new Span[this.grid.getColumnCount()][];
            for (n = 0; n < this.lineSpans.length; ++n) {
                this.lineSpans[n] = new Span[this.grid.getLineCount(n) + 1];
                for (int i = 0; i < this.lineSpans[n].length; ++i) {
                    this.lineSpans[n][i] = this.createSpan(false);
                }
            }
            this.currentColumn = -1;
            this.currentLine = -1;
        }
    }

    private boolean isOutdated() {
        if (this.columnSpans.length != this.grid.getColumnCount() + 1) {
            return true;
        }
        for (int i = 0; i < this.lineSpans.length; ++i) {
            if (this.lineSpans[i].length == this.grid.getLineCount(i) + 1) continue;
            return true;
        }
        return false;
    }

    private Span createSpan(final boolean bl) {
        return this.factory.create(new SpanCallback(){

            @Override
            public void resized() {
                ToolbarGroupSpanStrategy.this.handleResized();
            }

            @Override
            public boolean isVertical() {
                return ToolbarGroupSpanStrategy.this.station.getOrientation() == Orientation.HORIZONTAL ^ bl;
            }

            @Override
            public boolean isHorizontal() {
                return ToolbarGroupSpanStrategy.this.station.getOrientation() == Orientation.VERTICAL ^ bl;
            }

            @Override
            public SpanUsage getUsage() {
                return SpanUsage.INSERTING;
            }

            @Override
            public DockStation getStation() {
                return ToolbarGroupSpanStrategy.this.station;
            }
        });
    }

    public int getColumn(int n) {
        return Math.max(this.columnSpans[n].getSize(), this.dividers.getColumn(n));
    }

    public int getLine(int n, int n2) {
        return Math.max(this.lineSpans[n][n2].getSize(), this.dividers.getLine(n, n2));
    }

    public void mutate(int n) {
        this.mutate(n, -1);
    }

    public void mutate(int n, int n2) {
        block10: {
            if (this.currentColumn == n && this.currentLine == n2) break block10;
            this.currentColumn = n;
            this.currentLine = n2;
            if (n2 == -1) {
                for (int i = 0; i < this.columnSpans.length; ++i) {
                    if (i == n) {
                        this.columnSpans[i].mutate(SpanMode.OPEN);
                        continue;
                    }
                    this.columnSpans[i].mutate(SpanMode.OFF);
                }
                Span[][] spanArray = this.lineSpans;
                int n3 = spanArray.length;
                for (int i = 0; i < n3; ++i) {
                    Span[] spanArray2;
                    for (Span span : spanArray2 = spanArray[i]) {
                        span.mutate(SpanMode.OFF);
                    }
                }
            } else {
                Span[] spanArray = this.columnSpans;
                int n4 = spanArray.length;
                for (int i = 0; i < n4; ++i) {
                    Span span = spanArray[i];
                    span.mutate(SpanMode.OFF);
                }
                for (int i = 0; i < this.lineSpans.length; ++i) {
                    for (n4 = 0; n4 < this.lineSpans[i].length; ++n4) {
                        if (i == n && n4 == n2) {
                            this.lineSpans[i][n4].mutate(SpanMode.OPEN);
                            continue;
                        }
                        this.lineSpans[i][n4].mutate(SpanMode.OFF);
                    }
                }
            }
        }
    }
}

