/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.window.AbstractScreenWindowShape;
import bibliothek.gui.dock.station.screen.window.ScreenWindowShapeCallback;
import bibliothek.gui.dock.station.toolbar.layout.ToolbarGridLayoutManagerListener;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.SwingUtilities;

public class ToolbarScreenWindowShape
extends AbstractScreenWindowShape {
    private ToolbarGroupDockStation station;
    private boolean reshapePending = false;
    private ToolbarGridLayoutManagerListener listener = new ToolbarGridLayoutManagerListener(){

        @Override
        public void didLayout(Container container) {
            ToolbarScreenWindowShape.this.reshape();
        }
    };

    @Override
    public void setCallback(ScreenWindowShapeCallback screenWindowShapeCallback) {
        this.uninstall();
        super.setCallback(screenWindowShapeCallback);
    }

    private void uninstall() {
        if (this.station != null) {
            this.station.getLayoutManager().removeListener(this.listener);
            this.station = null;
        }
    }

    private void install(ToolbarGroupDockStation toolbarGroupDockStation) {
        this.station = toolbarGroupDockStation;
        toolbarGroupDockStation.getLayoutManager().addListener(this.listener);
    }

    @Override
    protected Shape getShape() {
        Object object;
        if (this.station == null && (object = this.getCallback().getWindow().getDockable()) instanceof ToolbarGroupDockStation) {
            this.install((ToolbarGroupDockStation)object);
        }
        if (this.station == null) {
            return null;
        }
        object = new Area();
        this.addBorder((Area)object);
        this.addChildren((Area)object);
        this.addExpanded((Area)object);
        return object;
    }

    private void addBorder(Area area) {
        ScreenDockWindow screenDockWindow = this.getCallback().getWindow();
        Insets insets = screenDockWindow.getDockableInsets();
        Dimension dimension = screenDockWindow.getWindowBounds().getSize();
        if (insets.top > 0) {
            area.add(new Area(new Rectangle(0, 0, dimension.width, insets.top)));
        }
        if (insets.bottom > 0) {
            area.add(new Area(new Rectangle(0, dimension.height - insets.bottom - 1, dimension.width, insets.bottom)));
        }
        if (insets.left > 0) {
            area.add(new Area(new Rectangle(0, 0, insets.left, dimension.height)));
        }
        if (insets.right > 0) {
            area.add(new Area(new Rectangle(dimension.width - insets.right - 1, 0, insets.right, dimension.height)));
        }
    }

    private void addChildren(Area area) {
        ScreenDockWindow screenDockWindow = this.getCallback().getWindow();
        Insets insets = screenDockWindow.getDockableInsets();
        int n = this.station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable dockable = this.station.getDockable(i);
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(dockable.getComponent(), point, this.station.getComponent());
            point.x += insets.left;
            point.y += insets.top;
            Dimension dimension = dockable.getComponent().getSize();
            area.add(new Area(new Rectangle(point.x - 1, point.y - 1, dimension.width + 2, dimension.height + 2)));
            for (DockTitle dockTitle : dockable.listBoundTitles()) {
                if (!SwingUtilities.isDescendingFrom(dockTitle.getComponent(), this.station.getComponent())) continue;
                Point point2 = new Point(0, 0);
                point2 = SwingUtilities.convertPoint(dockTitle.getComponent(), point2, dockable.getComponent());
                point2.x += point.x;
                point2.y += point.y;
                dimension = dockTitle.getComponent().getSize();
                area.add(new Area(new Rectangle(point2.x - 1, point2.y - 1, dimension.width + 2, dimension.height + 2)));
            }
        }
    }

    private void addExpanded(Area area) {
        Rectangle rectangle = this.station.getDropGapBoundaries();
        if (rectangle != null) {
            ScreenDockWindow screenDockWindow = this.getCallback().getWindow();
            Insets insets = screenDockWindow.getDockableInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            area.add(new Area(rectangle));
        }
    }

    @Override
    public void reshape() {
        this.reshapePending = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ToolbarScreenWindowShape.this.reshapePending) {
                    ToolbarScreenWindowShape.this.reshapePending = false;
                    ToolbarScreenWindowShape.super.reshape();
                }
            }
        });
    }
}

