/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Rect;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.RgbToBgr;
import org.jcodec.scale.Transform;

public class AWTUtil {
    public static BufferedImage toBufferedImage(Picture src) {
        if (src.getColor() != ColorSpace.BGR) {
            Picture bgr = Picture.createCropped((int)src.getWidth(), (int)src.getHeight(), (ColorSpace)ColorSpace.BGR, (Rect)src.getCrop());
            if (src.getColor() == ColorSpace.RGB) {
                new RgbToBgr().transform(src, bgr);
            } else {
                Transform transform = ColorUtil.getTransform((ColorSpace)src.getColor(), (ColorSpace)ColorSpace.RGB);
                transform.transform(src, bgr);
                new RgbToBgr().transform(bgr, bgr);
            }
            src = bgr;
        }
        BufferedImage dst = new BufferedImage(src.getCroppedWidth(), src.getCroppedHeight(), 5);
        if (src.getCrop() == null) {
            AWTUtil.toBufferedImage(src, dst);
        } else {
            AWTUtil.toBufferedImageCropped(src, dst);
        }
        return dst;
    }

    public static BufferedImage toBufferedImage(Picture src, DemuxerTrackMeta.Orientation orientation) {
        if (src.getColor() != ColorSpace.BGR) {
            Picture bgr = Picture.createCropped((int)src.getWidth(), (int)src.getHeight(), (ColorSpace)ColorSpace.BGR, (Rect)src.getCrop());
            if (src.getColor() == ColorSpace.RGB) {
                new RgbToBgr().transform(src, bgr);
            } else {
                Transform transform = ColorUtil.getTransform((ColorSpace)src.getColor(), (ColorSpace)ColorSpace.RGB);
                transform.transform(src, bgr);
                new RgbToBgr().transform(bgr, bgr);
            }
            src = bgr;
        }
        BufferedImage dst = new BufferedImage(src.getCroppedWidth(), src.getCroppedHeight(), 5);
        if (src.getCrop() == null) {
            AWTUtil.toBufferedImage(src, dst);
        } else {
            AWTUtil.toBufferedImageCropped(src, dst);
        }
        if (orientation.equals((Object)DemuxerTrackMeta.Orientation.D_90)) {
            return AWTUtil.rotate90ToRight(dst);
        }
        if (orientation.equals((Object)DemuxerTrackMeta.Orientation.D_180)) {
            return AWTUtil.rotate180(dst);
        }
        if (orientation.equals((Object)DemuxerTrackMeta.Orientation.D_270)) {
            return AWTUtil.rotate90ToLeft(dst);
        }
        return dst;
    }

    public static BufferedImage rotate90ToRight(BufferedImage inputImage) {
        int width = inputImage.getWidth();
        int height = inputImage.getHeight();
        BufferedImage returnImage = new BufferedImage(height, width, inputImage.getType());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                returnImage.setRGB(height - y - 1, x, inputImage.getRGB(x, y));
            }
        }
        return returnImage;
    }

    public static BufferedImage rotate180(BufferedImage inputImage) {
        int width = inputImage.getWidth();
        int height = inputImage.getHeight();
        BufferedImage returnImage = new BufferedImage(width, height, inputImage.getType());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                returnImage.setRGB(width - x - 1, height - y - 1, inputImage.getRGB(x, y));
            }
        }
        return returnImage;
    }

    public static BufferedImage rotate90ToLeft(BufferedImage inputImage) {
        int width = inputImage.getWidth();
        int height = inputImage.getHeight();
        BufferedImage returnImage = new BufferedImage(height, width, inputImage.getType());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                returnImage.setRGB(y, width - x - 1, inputImage.getRGB(x, y));
            }
        }
        return returnImage;
    }

    private static void toBufferedImageCropped(Picture src, BufferedImage dst) {
        byte[] data = ((DataBufferByte)dst.getRaster().getDataBuffer()).getData();
        byte[] srcData = src.getPlaneData(0);
        int dstStride = dst.getWidth() * 3;
        int srcStride = src.getWidth() * 3;
        int srcOff = 0;
        int dstOff = 0;
        for (int line = 0; line < dst.getHeight(); ++line) {
            int id = dstOff;
            int is = srcOff;
            while (id < dstOff + dstStride) {
                data[id] = (byte)(srcData[is] + 128);
                data[id + 1] = (byte)(srcData[is + 1] + 128);
                data[id + 2] = (byte)(srcData[is + 2] + 128);
                id += 3;
                is += 3;
            }
            srcOff += srcStride;
            dstOff += dstStride;
        }
    }

    public static void toBufferedImage(Picture src, BufferedImage dst) {
        byte[] data = ((DataBufferByte)dst.getRaster().getDataBuffer()).getData();
        byte[] srcData = src.getPlaneData(0);
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(srcData[i] + 128);
        }
    }

    public static Picture fromBufferedImage(BufferedImage src, ColorSpace tgtColor) {
        Picture rgb = AWTUtil.fromBufferedImageRGB(src);
        Transform tr = ColorUtil.getTransform((ColorSpace)rgb.getColor(), (ColorSpace)tgtColor);
        Picture res = Picture.create((int)rgb.getWidth(), (int)rgb.getHeight(), (ColorSpace)tgtColor);
        tr.transform(rgb, res);
        return res;
    }

    public static Picture fromBufferedImageRGB(BufferedImage src) {
        Picture dst = Picture.create((int)src.getWidth(), (int)src.getHeight(), (ColorSpace)ColorSpace.RGB);
        AWTUtil.fromBufferedImage(src, dst);
        return dst;
    }

    public static void fromBufferedImage(BufferedImage src, Picture dst) {
        byte[] dstData = dst.getPlaneData(0);
        int off = 0;
        for (int i = 0; i < src.getHeight(); ++i) {
            for (int j = 0; j < src.getWidth(); ++j) {
                int rgb1 = src.getRGB(j, i);
                dstData[off++] = (byte)((rgb1 >> 16 & 0xFF) - 128);
                dstData[off++] = (byte)((rgb1 >> 8 & 0xFF) - 128);
                dstData[off++] = (byte)((rgb1 & 0xFF) - 128);
            }
        }
    }

    public static void savePicture(Picture pic, String format, File file) throws IOException {
        ImageIO.write((RenderedImage)AWTUtil.toBufferedImage(pic), format, file);
    }
}

