/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.toolbar.ListDockableStationPerspective;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockStationLayout;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerProperty;
import bibliothek.util.Path;
import java.util.Map;

public class ToolbarContainerDockPerspective
extends ListDockableStationPerspective {
    public ToolbarContainerDockPerspective() {
        this.setDockables(new PerspectivePlaceholderList<PerspectiveDockable>());
    }

    public ToolbarContainerDockPerspective(ToolbarContainerDockStationLayout toolbarContainerDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        this.read(toolbarContainerDockStationLayout, map);
    }

    public void read(ToolbarContainerDockStationLayout toolbarContainerDockStationLayout, final Map<Integer, PerspectiveDockable> map) {
        PlaceholderMap placeholderMap = toolbarContainerDockStationLayout.getPlaceholders();
        if (!placeholderMap.getFormat().equals(new Path("dock.ToolbarContainerStation"))) {
            throw new IllegalArgumentException("unknown format: " + placeholderMap.getFormat());
        }
        if (placeholderMap.getVersion() != 0) {
            throw new IllegalArgumentException("unknown version: " + placeholderMap.getVersion());
        }
        PlaceholderMap placeholderMap2 = placeholderMap.getMap(placeholderMap.newKey("content", new Path[0]), "list");
        PerspectivePlaceholderList<PerspectiveDockable> perspectivePlaceholderList = new PerspectivePlaceholderList<PerspectiveDockable>();
        perspectivePlaceholderList.read(placeholderMap2, new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            @Override
            public PerspectiveDockable convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                if (map == null) {
                    return null;
                }
                int n = convertedPlaceholderListItem.getInt("id");
                PerspectiveDockable perspectiveDockable = (PerspectiveDockable)map.get(n);
                perspectiveDockable.setParent(ToolbarContainerDockPerspective.this);
                return perspectiveDockable;
            }
        });
        this.setDockables(perspectivePlaceholderList);
    }

    @Override
    public String getFactoryID() {
        return "ToolbarContainerDockStationFactory";
    }

    @Override
    protected DockableProperty getDockableProperty(int n, Path path, PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        return new ToolbarContainerProperty(n, path);
    }
}

