/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layer;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class SideSnapDropLayer
implements DockStationDropLayer {
    private final ToolbarGroupDockStation station;
    private LayerPriority priority = LayerPriority.OUTSIDE_LOW;

    public SideSnapDropLayer(ToolbarGroupDockStation toolbarGroupDockStation) {
        this.station = toolbarGroupDockStation;
    }

    @Override
    public LayerPriority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(LayerPriority layerPriority) {
        this.priority = layerPriority;
    }

    @Override
    public boolean canCompare(DockStationDropLayer dockStationDropLayer) {
        return false;
    }

    @Override
    public int compare(DockStationDropLayer dockStationDropLayer) {
        return 0;
    }

    @Override
    public Component getComponent() {
        return this.station.getComponent();
    }

    @Override
    public DockStation getStation() {
        return this.station;
    }

    @Override
    public DockStationDropLayer modify(DockStationDropLayer dockStationDropLayer) {
        return dockStationDropLayer;
    }

    @Override
    public boolean contains(int n, int n2) {
        if (!this.station.isAllowSideSnap()) {
            return false;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.getComponent());
        Rectangle rectangle = this.getComponent().getBounds();
        if (rectangle.contains(point)) {
            return false;
        }
        int n3 = this.station.getBorderSideSnapSize();
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setBounds(rectangle.x - n3, rectangle.y - n3, rectangle.width + n3 * 2, rectangle.height + n3 * 2);
        return rectangle2.contains(point);
    }
}

