/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.FilteredDockActionSource;
import bibliothek.gui.dock.station.stack.action.DockActionDistributor;
import bibliothek.gui.dock.station.stack.action.InfoDockAction;
import bibliothek.gui.dock.station.stack.action.TabDockAction;
import bibliothek.gui.dock.station.stack.action.TitleDockAction;

public class DefaultDockActionDistributor
implements DockActionDistributor {
    public DockActionSource createSource(Dockable dockable, DockActionDistributor.Target target) {
        if (target == DockActionDistributor.Target.TAB) {
            return this.createTabSource(dockable.getGlobalActionOffers());
        }
        if (target == DockActionDistributor.Target.TITLE) {
            return this.createTitleSource(dockable.getGlobalActionOffers());
        }
        if (target == DockActionDistributor.Target.INFO_COMPONENT) {
            return this.createInfoSource(dockable.getGlobalActionOffers());
        }
        throw new IllegalArgumentException("unkown target: " + target);
    }

    protected DockActionSource createTabSource(DockActionSource source) {
        return new FilteredDockActionSource(source){

            protected boolean include(DockAction action) {
                return action.getClass().getAnnotation(TabDockAction.class) != null;
            }
        };
    }

    protected DockActionSource createInfoSource(DockActionSource source) {
        return new FilteredDockActionSource(source){

            protected boolean include(DockAction action) {
                return action.getClass().getAnnotation(InfoDockAction.class) != null;
            }
        };
    }

    protected DockActionSource createTitleSource(DockActionSource source) {
        return new FilteredDockActionSource(source){

            protected boolean include(DockAction action) {
                Class<?> clazz = action.getClass();
                if (clazz.getAnnotation(TitleDockAction.class) != null) {
                    return true;
                }
                return clazz.getAnnotation(TabDockAction.class) == null && clazz.getAnnotation(InfoDockAction.class) == null;
            }
        };
    }
}

