/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.AbstractToolbarDockStation;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.component.DefaultDockStationComponentRootHandler;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.DockableShowingManager;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListMapping;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.SpanToolbarLayoutManager;
import bibliothek.gui.dock.station.toolbar.ToolbarDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarDropInfo;
import bibliothek.gui.dock.station.toolbar.ToolbarProperty;
import bibliothek.gui.dock.station.toolbar.layer.ToolbarSlimDropLayer;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.basic.BasicDockTitleFactory;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ToolbarDockStation
extends AbstractToolbarDockStation {
    public static final String TITLE_ID = "toolbar";
    public static final String DISPLAYER_ID = "toolbar";
    public static final PropertyKey<Integer> GAP = new PropertyKey<Integer>("dock.toolbar.gap", new ConstantPropertyFactory<Integer>(2), true);
    public static final PropertyKey<Integer> SIDE_GAP = new PropertyKey<Integer>("dock.toolbar.sidegap", new ConstantPropertyFactory<Integer>(4), true);
    protected DockablePlaceholderList<StationChildHandle> dockables = new DockablePlaceholderList();
    private OverpaintablePanelBase mainPanel;
    private int lateralNodropZoneSize = 2;
    private final PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy placeholderStrategy, PlaceholderStrategy placeholderStrategy2) {
            ToolbarDockStation.this.dockables.setStrategy(placeholderStrategy2);
        }
    };
    private DockableShowingManager visibility;
    private VisibleListener visibleListener;
    private SpanToolbarLayoutManager layoutManager;
    private DropInfo dropInfo;
    private PropertyValue<Integer> gap = new PropertyValue<Integer>(GAP){

        @Override
        protected void valueChanged(Integer n, Integer n2) {
            ToolbarDockStation.this.layoutManager.setGap(n2);
        }
    };
    private PropertyValue<Integer> sideGap = new PropertyValue<Integer>(SIDE_GAP){

        @Override
        protected void valueChanged(Integer n, Integer n2) {
            ToolbarDockStation.this.layoutManager.setSideGap(n2);
        }
    };

    public ToolbarDockStation() {
        this.init();
    }

    protected void init() {
        super.init("dock.background.station.toolbar");
        this.mainPanel = this.createMainPanel();
        this.mainPanel.setupLayout();
        this.paint = new DefaultStationPaintValue("dock.paint.toolbar", this);
        this.setOrientation(this.getOrientation());
        this.displayerFactory = this.createDisplayerFactory();
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory, this.getDisplayerId());
        this.displayers.addDockableDisplayerListener(new DockableDisplayerListener(){

            @Override
            public void discard(DockableDisplayer dockableDisplayer) {
                ToolbarDockStation.this.discard(dockableDisplayer);
            }

            @Override
            public void moveableElementChanged(DockableDisplayer dockableDisplayer) {
            }
        });
        this.setTitleIcon(null);
        this.visibility = new DockableShowingManager(this.listeners);
        this.visibleListener = new VisibleListener();
        this.getComponent().addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                    if (ToolbarDockStation.this.getDockParent() == null) {
                        ToolbarDockStation.this.getDockableStateListeners().checkShowing();
                    }
                    ToolbarDockStation.this.visibility.fire();
                }
            }
        });
    }

    @Override
    protected DockComponentRootHandler createRootHandler() {
        return new DefaultDockStationComponentRootHandler(this, this.displayers);
    }

    @Override
    public Component getComponent() {
        return this.mainPanel;
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints dockableDisplayerHints) {
        super.configureDisplayerHints(dockableDisplayerHints);
        if (dockableDisplayerHints != null && dockableDisplayerHints.getStation() instanceof ScreenDockStation) {
            dockableDisplayerHints.setShowBorderHint(Boolean.TRUE);
        }
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    @Override
    public Dockable getDockable(int n) {
        return ((StationChildHandle)this.dockables.dockables().get(n)).getDockable();
    }

    @Override
    public String getFactoryID() {
        return "ToolbarDockStationFactory";
    }

    public void setLateralNodropZoneSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("borderSideSnapeSize must not be less than 0");
        }
        this.lateralNodropZoneSize = n;
    }

    public int getLateralNodropZoneSize() {
        return this.lateralNodropZoneSize;
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        DockStation dockStation2 = this.getDockParent();
        if (dockStation2 != null) {
            dockStation2.removeDockStationListener(this.visibleListener);
        }
        super.setDockParent(dockStation);
        if (dockStation != null) {
            dockStation.addDockStationListener(this.visibleListener);
        }
        this.visibility.fire();
    }

    @Override
    public void setController(DockController dockController) {
        if (this.getController() != dockController) {
            if (this.getController() != null) {
                this.dockables.unbind();
            }
            for (StationChildHandle stationChildHandle : this.dockables.dockables()) {
                stationChildHandle.setTitleRequest(null);
            }
            super.setController(dockController);
            this.title = dockController == null ? null : this.registerTitle(dockController);
            this.paint.setController(dockController);
            this.placeholderStrategy.setProperties(dockController);
            this.displayerFactory.setController(dockController);
            this.displayers.setController(dockController);
            this.mainPanel.setController(dockController);
            this.layoutManager.setController(dockController);
            this.gap.setProperties(dockController);
            this.sideGap.setProperties(dockController);
            if (dockController != null) {
                this.dockables.bind();
            }
            for (StationChildHandle stationChildHandle : this.dockables.dockables()) {
                stationChildHandle.setTitleRequest(this.title, true);
            }
            this.visibility.fire();
        }
    }

    @Override
    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.fireOrientingEvent();
        this.mainPanel.revalidate();
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        return new DockStationDropLayer[]{new ToolbarSlimDropLayer(this)};
    }

    @Override
    public boolean accept(Dockable dockable) {
        return this.getToolbarStrategy().isToolbarPart(dockable);
    }

    @Override
    public boolean accept(DockStation dockStation) {
        return this.getToolbarStrategy().isToolbarGroupPartParent(dockStation, this, false);
    }

    @Override
    public boolean accept(DockStation dockStation, Dockable dockable) {
        return false;
    }

    @Override
    public StationDropOperation prepareDrop(StationDropItem stationDropItem) {
        DockController dockController = this.getController();
        if (this.getExpandedState() == ExpandedState.EXPANDED) {
            return null;
        }
        Dockable dockable = stationDropItem.getDockable();
        if (this.accept(dockable) && dockable.accept(this)) {
            if (dockController != null && !dockController.getAcceptance().accept(this, dockable)) {
                return null;
            }
            Point point = new Point(stationDropItem.getMouseX(), stationDropItem.getMouseY());
            SwingUtilities.convertPointFromScreen(point, this.mainPanel.getDockablePane());
            int n = this.layoutManager.getInsertionIndex(point.x, point.y);
            DropInfo dropInfo = new DropInfo(dockable, n);
            if (dropInfo.hasNoEffect()) {
                return null;
            }
            return dropInfo;
        }
        return null;
    }

    @Override
    public void drop(Dockable dockable) {
        this.drop(dockable, this.getDockableCount(), true);
    }

    public boolean drop(Dockable dockable, int n) {
        return this.drop(dockable, n, false);
    }

    protected boolean drop(Dockable dockable, int n, boolean bl) {
        if (bl || this.accept(dockable)) {
            if (!bl) {
                Dockable dockable2 = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
                if (dockable2 == null) {
                    return false;
                }
                if (dockable2 != dockable) {
                    dockable2.asDockStation().drop(dockable);
                    dockable = dockable2;
                }
            }
            this.add(dockable, n);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void move(Dockable dockable, int n) {
        DockController dockController = this.getController();
        try {
            int n2;
            if (dockController != null) {
                dockController.freezeLayout();
            }
            if ((n2 = this.indexOf(dockable)) == -1) {
                throw new IllegalArgumentException("dockable is not known to this station");
            }
            if (n2 < n) {
                --n;
            }
            if (n2 != n) {
                this.add(dockable, n);
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    protected void add(Dockable dockable, int n) {
        this.add(dockable, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Dockable dockable, int n, Path path) {
        DockUtilities.ensureTreeValidity(this, dockable);
        DockUtilities.checkLayoutLocked();
        Dockable dockable2 = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
        if (dockable2 != dockable) {
            dockable2.asDockStation().drop(dockable);
            dockable = dockable2;
        }
        if (this.getExpandedState() == ExpandedState.EXPANDED && this.getDockableCount() == 1) {
            DockStation dockStation = this.getDockable(0).asDockStation();
            dockStation.drop(dockable, new StackDockProperty(n, path));
        } else {
            DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking(this, dockable);
            try {
                this.listeners.fireDockableAdding(dockable);
                int n2 = -1;
                StationChildHandle stationChildHandle = new StationChildHandle(this, this.displayers, dockable, this.title);
                stationChildHandle.updateDisplayer();
                if (path != null && this.dockables.getDockableAt(path) == null) {
                    n2 = this.dockables.put(path, stationChildHandle);
                } else if (path != null) {
                    n = this.dockables.getDockableIndex(path);
                }
                if (n2 == -1) {
                    this.getDockables().add(n, stationChildHandle);
                } else {
                    n = n2;
                }
                this.insertAt(stationChildHandle, n);
                this.listeners.fireDockableAdded(dockable);
                this.fireDockablesRepositioned(n + 1);
            }
            finally {
                token.release();
            }
        }
    }

    protected void insertAt(StationChildHandle stationChildHandle, int n) {
        Dockable dockable = stationChildHandle.getDockable();
        dockable.setDockParent(this);
        this.mainPanel.getDockablePane().add(stationChildHandle.getDisplayer().getComponent(), n);
        this.mainPanel.getDockablePane().invalidate();
        this.mainPanel.revalidate();
        this.mainPanel.getContentPane().repaint();
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable cannot be dragged, it is not child of this station.");
        }
        this.remove(dockable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void remove(Dockable dockable) {
        DockUtilities.checkLayoutLocked();
        int n = this.indexOf(dockable);
        StationChildHandle stationChildHandle = (StationChildHandle)this.dockables.dockables().get(n);
        if (this.getFrontDockable() == dockable) {
            this.setFrontDockable(null);
        }
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, dockable);
        try {
            this.listeners.fireDockableRemoving(dockable);
            dockable.setDockParent(null);
            this.dockables.remove(n);
            this.mainPanel.getDockablePane().remove(stationChildHandle.getDisplayer().getComponent());
            this.mainPanel.doLayout();
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
            stationChildHandle.destroy();
            this.listeners.fireDockableRemoved(dockable);
            this.fireDockablesRepositioned(n);
        }
        finally {
            token.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int n) {
        DockUtilities.checkLayoutLocked();
        StationChildHandle stationChildHandle = (StationChildHandle)this.dockables.dockables().get(n);
        Dockable dockable = this.getDockable(n);
        if (this.getFrontDockable() == dockable) {
            this.setFrontDockable(null);
        }
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, dockable);
        try {
            this.listeners.fireDockableRemoving(dockable);
            dockable.setDockParent(null);
            this.dockables.remove(n);
            this.mainPanel.getDockablePane().remove(stationChildHandle.getDisplayer().getComponent());
            this.mainPanel.doLayout();
            this.mainPanel.getContentPane().revalidate();
            this.mainPanel.getContentPane().repaint();
            stationChildHandle.destroy();
            this.listeners.fireDockableRemoved(dockable);
            this.fireDockablesRepositioned(n);
        }
        finally {
            token.release();
        }
    }

    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        DockUtilities.checkLayoutLocked();
        DockController dockController = this.getController();
        if (dockController != null) {
            dockController.freezeLayout();
        }
        int n = this.indexOf(dockable);
        this.remove(dockable);
        this.add(dockable2, n);
        dockController.meltLayout();
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new ToolbarDockStationFactory());
    }

    @Override
    protected DefaultDisplayerFactoryValue createDisplayerFactory() {
        return new DefaultDisplayerFactoryValue("dock.displayer.toolbar", this);
    }

    protected String getDisplayerId() {
        return "toolbar";
    }

    @Override
    protected DockTitleVersion registerTitle(DockController dockController) {
        return dockController.getDockTitleManager().getVersion("toolbar", BasicDockTitleFactory.FACTORY);
    }

    @Override
    protected void discard(DockableDisplayer dockableDisplayer) {
        Dockable dockable = dockableDisplayer.getDockable();
        int n = this.indexOf(dockable);
        if (n < 0) {
            throw new IllegalArgumentException("displayer is not a child of this station: " + dockableDisplayer);
        }
        StationChildHandle stationChildHandle = (StationChildHandle)this.dockables.dockables().get(n);
        this.mainPanel.getDockablePane().remove(stationChildHandle.getDisplayer().getComponent());
        stationChildHandle.updateDisplayer();
        this.insertAt(stationChildHandle, n);
    }

    protected OverpaintablePanelBase createMainPanel() {
        return new OverpaintablePanelBase();
    }

    @Override
    protected JPanel createBackgroundPanel() {
        return new SizeFixedPanel();
    }

    protected DockableProperty getDockableProperty(Dockable dockable, Dockable dockable2, int n, Path path) {
        return new ToolbarProperty(n, path);
    }

    protected boolean isValidProperty(DockableProperty dockableProperty) {
        return dockableProperty instanceof ToolbarProperty;
    }

    protected int getIndex(DockableProperty dockableProperty) {
        return ((ToolbarProperty)dockableProperty).getIndex();
    }

    protected Path getPlaceholder(DockableProperty dockableProperty) {
        return ((ToolbarProperty)dockableProperty).getPlaceholder();
    }

    protected PlaceholderList.Filter<StationChildHandle> getDockables() {
        return this.dockables.dockables();
    }

    public PlaceholderMap getPlaceholders(final Map<Dockable, Integer> map) {
        final PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        return this.dockables.toMap(new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, StationChildHandle stationChildHandle) {
                Path path;
                Dockable dockable = stationChildHandle.getDockable();
                Integer n2 = (Integer)map.get(dockable);
                if (n2 == null) {
                    return null;
                }
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                convertedPlaceholderListItem.putInt("id", n2);
                convertedPlaceholderListItem.putInt("index", n);
                if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockable)) != null) {
                    convertedPlaceholderListItem.putString("placeholder", path.toString());
                    convertedPlaceholderListItem.setPlaceholder(path);
                }
                return convertedPlaceholderListItem;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaceholders(PlaceholderMap placeholderMap, final Map<Integer, Dockable> map) {
        DockUtilities.checkLayoutLocked();
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("must not have any children");
        }
        DockController dockController = this.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            DockablePlaceholderList<StationChildHandle> dockablePlaceholderList = new DockablePlaceholderList<StationChildHandle>();
            if (this.getController() != null) {
                this.dockables.setStrategy(null);
                this.dockables.unbind();
                this.dockables = dockablePlaceholderList;
            } else {
                this.dockables = dockablePlaceholderList;
            }
            dockablePlaceholderList.read(placeholderMap, new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){
                private DockHierarchyLock.Token token;
                private int index = 0;

                @Override
                public StationChildHandle convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                    int n = convertedPlaceholderListItem.getInt("id");
                    Dockable dockable = (Dockable)map.get(n);
                    if (dockable != null) {
                        DockUtilities.ensureTreeValidity(ToolbarDockStation.this, dockable);
                        this.token = DockHierarchyLock.acquireLinking(ToolbarDockStation.this, dockable);
                        ToolbarDockStation.this.listeners.fireDockableAdding(dockable);
                        return new StationChildHandle(ToolbarDockStation.this, ToolbarDockStation.this.displayers, dockable, ToolbarDockStation.this.title);
                    }
                    return null;
                }

                @Override
                public void added(StationChildHandle stationChildHandle) {
                    try {
                        stationChildHandle.updateDisplayer();
                        ToolbarDockStation.this.insertAt(stationChildHandle, this.index++);
                        ToolbarDockStation.this.listeners.fireDockableAdded(stationChildHandle.getDockable());
                    }
                    finally {
                        this.token.release();
                    }
                }
            });
            if (this.getController() != null) {
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    @Override
    public PlaceholderMapping getPlaceholderMapping() {
        return new PlaceholderListMapping(this, this.dockables){

            @Override
            public DockableProperty getLocationAt(Path path) {
                int n = ToolbarDockStation.this.dockables.getDockableIndex(path);
                return new ToolbarProperty(n, path);
            }
        };
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("only allowed if there are not children present");
        }
        try {
            DockablePlaceholderList dockablePlaceholderList = new DockablePlaceholderList(placeholderMap);
            if (this.getController() != null) {
                this.dockables.setStrategy(null);
                this.dockables.unbind();
                this.dockables = dockablePlaceholderList;
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            } else {
                this.dockables = dockablePlaceholderList;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        this.placeholderStrategy.setValue(placeholderStrategy);
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable dockable2) {
        int n = this.indexOf(dockable);
        Path path = null;
        PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockable2 == null ? dockable : dockable2)) != null) {
            this.dockables.dockables().addPlaceholder(n, path);
        }
        return this.getDockableProperty(dockable, dockable2, n, path);
    }

    @Override
    public void aside(AsideRequest asideRequest) {
        DockableProperty dockableProperty;
        Object object;
        Object object2;
        int n = -1;
        int n2 = -1;
        if (this.getExpandedState() == ExpandedState.EXPANDED && this.getDockableCount() == 1) {
            object2 = this.getDockable(0).asDockStation();
            object = asideRequest.forward((DockStation)object2);
            if (object.isCanceled()) {
                return;
            }
            dockableProperty = object.getLocation();
            if (dockableProperty instanceof StackDockProperty) {
                n2 = ((StackDockProperty)dockableProperty).getIndex();
            }
        }
        object2 = asideRequest.getLocation();
        object = asideRequest.getPlaceholder();
        if (object2 instanceof ToolbarProperty) {
            dockableProperty = (ToolbarProperty)object2;
            n = this.dockables.getNextListIndex(dockableProperty.getIndex(), dockableProperty.getPlaceholder());
            if (object != null) {
                this.dockables.list().insertPlaceholder(n, (Path)object);
            }
        } else {
            n = this.dockables.dockables().size();
            if (object != null) {
                this.dockables.dockables().insertPlaceholder(n, (Path)object);
            }
        }
        if (n2 == -1) {
            n2 = n;
        }
        asideRequest.answer(new ToolbarProperty(n, (Path)object));
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (this.isValidProperty(dockableProperty)) {
            DockStation dockStation;
            Object object;
            boolean bl = this.acceptable(dockable);
            boolean bl2 = false;
            int n = Math.min(this.getDockableCount(), this.getIndex(dockableProperty));
            Path path = this.getPlaceholder(dockableProperty);
            if (path != null && dockableProperty.getSuccessor() != null && (object = (StationChildHandle)this.dockables.getDockableAt(path)) != null && (dockStation = ((StationChildHandle)object).getDockable().asDockStation()) != null && dockStation.drop(dockable, dockableProperty.getSuccessor())) {
                this.dockables.removeAll(path);
                bl2 = true;
            }
            if (!bl2 && path != null && bl && this.dockables.hasPlaceholder(path)) {
                this.add(dockable, n, path);
                bl2 = true;
            }
            if (!bl2 && this.dockables.dockables().size() == 0 && bl) {
                this.drop(dockable);
                bl2 = true;
            }
            if (!bl2 && n < this.dockables.dockables().size() && dockableProperty.getSuccessor() != null && (object = this.getDockable(n).asDockStation()) != null) {
                bl2 = object.drop(dockable, dockableProperty.getSuccessor());
            }
            if (!bl2 && bl) {
                bl2 = this.drop(dockable, n);
            }
            return bl2;
        }
        return false;
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
    }

    private class VisibleListener
    extends DockStationAdapter {
        private VisibleListener() {
        }

        @Override
        public void dockableShowingChanged(DockStation dockStation, Dockable dockable, boolean bl) {
            if (dockable == ToolbarDockStation.this) {
                ToolbarDockStation.this.visibility.fire();
            }
        }
    }

    protected class OverpaintablePanelBase
    extends SecureContainer {
        private static final long serialVersionUID = -4399008463139189130L;
        private JComponent dockablePane;

        public OverpaintablePanelBase() {
            this.setSolid(false);
        }

        public void setupLayout() {
            this.setDockablePane(ToolbarDockStation.this.createBackgroundPanel());
            this.setBasePane(this.dockablePane);
        }

        public void setDockablePane(JComponent jComponent) {
            if (this.dockablePane != null) {
                throw new IllegalStateException("dockablePane is already set");
            }
            this.dockablePane = jComponent;
            ToolbarDockStation.this.layoutManager = new SpanToolbarLayoutManager(ToolbarDockStation.this, this.dockablePane){

                @Override
                protected void revalidate() {
                    OverpaintablePanelBase.this.dockablePane.revalidate();
                }
            };
            this.dockablePane.setLayout(ToolbarDockStation.this.layoutManager);
        }

        public JComponent getDockablePane() {
            return this.dockablePane;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getBasePane().getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        private Insets subtractComponent(JComponent jComponent, Insets insets) {
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(jComponent, point, this);
            insets.left += point.x;
            insets.top += point.y;
            insets.right += this.getWidth() - jComponent.getWidth() - point.x;
            insets.bottom += this.getHeight() - jComponent.getHeight() - point.y;
            return insets;
        }

        @Override
        protected void paintOverlay(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.paintRemoval(graphics);
            if (ToolbarDockStation.this.dropInfo != null) {
                int n;
                int n2;
                int n3;
                int n4;
                Insets insets = this.dockablePane.getInsets();
                if (insets == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                insets = this.subtractComponent(this.dockablePane, insets);
                int n5 = ToolbarDockStation.this.dropInfo.getIndex();
                if (ToolbarDockStation.this.getOrientation() == Orientation.HORIZONTAL) {
                    n4 = n5 == 0 ? insets.left : this.dockablePane.getComponent(n5 - 1).getX() + this.dockablePane.getComponent(n5 - 1).getWidth();
                    n3 = n5 == this.dockablePane.getComponentCount() ? this.getWidth() - n4 - insets.right : this.dockablePane.getComponent(n5).getX() - n4;
                    n2 = insets.top;
                    n = this.getHeight() - insets.top - insets.bottom;
                } else {
                    n2 = n5 == 0 ? insets.top : this.dockablePane.getComponent(n5 - 1).getY() + this.dockablePane.getComponent(n5 - 1).getHeight();
                    n = n5 == this.dockablePane.getComponentCount() ? this.getHeight() - n2 - insets.top : this.dockablePane.getComponent(n5).getY() - n2;
                    n4 = insets.left;
                    n3 = this.getWidth() - insets.left - insets.right;
                }
                if (n3 > 0 && n > 0) {
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    ToolbarDockStation.this.paint.drawInsertion(graphics2D, rectangle, new Rectangle(n4, n2, n3, n));
                }
            }
        }

        private void paintRemoval(Graphics graphics) {
            Dockable dockable = ToolbarDockStation.this.getRemoval();
            if (dockable != null) {
                for (StationChildHandle stationChildHandle : ToolbarDockStation.this.dockables.dockables()) {
                    if (stationChildHandle.getDockable() != dockable) continue;
                    Dimension dimension = stationChildHandle.getDisplayer().getComponent().getSize();
                    Point point = new Point(0, 0);
                    point = SwingUtilities.convertPoint(stationChildHandle.getDisplayer().getComponent(), point, this);
                    Rectangle rectangle = new Rectangle(point, dimension);
                    ToolbarDockStation.this.paint.drawRemoval(graphics, rectangle, rectangle);
                    break;
                }
            }
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
        }
    }

    protected class SizeFixedPanel
    extends ConfiguredBackgroundPanel {
        public SizeFixedPanel() {
            super(Transparency.SOLID);
            this.setBackground(ToolbarDockStation.this.getBackgroundAlgorithm());
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return dimension;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    private class DropInfo
    extends ToolbarDropInfo {
        public DropInfo(Dockable dockable, int n) {
            super(dockable, ToolbarDockStation.this, n);
        }

        @Override
        public void execute() {
            ToolbarDockStation.this.dropInfo = null;
            ToolbarDockStation.this.layoutManager.setExpandedSpan(-1, false);
            if (this.isMove()) {
                ToolbarDockStation.this.move(this.getItem(), this.getIndex());
            } else {
                ToolbarDockStation.this.drop(this.getItem(), this.getIndex());
            }
        }

        @Override
        public void destroy(StationDropOperation stationDropOperation) {
            if (ToolbarDockStation.this.dropInfo == this) {
                ToolbarDockStation.this.dropInfo = null;
            }
            if (stationDropOperation == null || stationDropOperation.getTarget() != this.getTarget()) {
                ToolbarDockStation.this.layoutManager.setExpandedSpan(-1, true);
            }
            ToolbarDockStation.this.mainPanel.repaint();
        }

        @Override
        public void draw() {
            ToolbarDockStation.this.dropInfo = this;
            ToolbarDockStation.this.layoutManager.setSpanSize(this.getItem());
            ToolbarDockStation.this.layoutManager.setExpandedSpan(this.getIndex(), true);
            ToolbarDockStation.this.mainPanel.repaint();
        }
    }
}

