/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockPerspective;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationLayout;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupProperty;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class ToolbarGroupDockStationFactory
implements DockFactory<ToolbarGroupDockStation, ToolbarGroupDockPerspective, ToolbarGroupDockStationLayout> {
    public static final String ID = "ToolbarGroupDockStationFactory";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public ToolbarGroupDockStationLayout getLayout(ToolbarGroupDockStation toolbarGroupDockStation, Map<Dockable, Integer> map) {
        PlaceholderMap placeholderMap = toolbarGroupDockStation.getPlaceholders(map);
        return new ToolbarGroupDockStationLayout(placeholderMap, toolbarGroupDockStation.getExpandedState());
    }

    @Override
    public ToolbarGroupDockStationLayout getPerspectiveLayout(ToolbarGroupDockPerspective toolbarGroupDockPerspective, Map<PerspectiveDockable, Integer> map) {
        return new ToolbarGroupDockStationLayout(toolbarGroupDockPerspective.toMap(map), toolbarGroupDockPerspective.getExpandedState());
    }

    @Override
    public void setLayout(ToolbarGroupDockStation toolbarGroupDockStation, ToolbarGroupDockStationLayout toolbarGroupDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        toolbarGroupDockStation.setExpandedState(toolbarGroupDockStationLayout.getState(), false);
        toolbarGroupDockStation.setPlaceholders(toolbarGroupDockStationLayout.getPlaceholders(), map);
    }

    @Override
    public void setLayout(ToolbarGroupDockStation toolbarGroupDockStation, ToolbarGroupDockStationLayout toolbarGroupDockStationLayout, PlaceholderStrategy placeholderStrategy) {
        toolbarGroupDockStation.setExpandedState(toolbarGroupDockStationLayout.getState(), false);
    }

    @Override
    public void write(ToolbarGroupDockStationLayout toolbarGroupDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_1_1);
        toolbarGroupDockStationLayout.getPlaceholders().write(dataOutputStream);
        dataOutputStream.writeUTF(toolbarGroupDockStationLayout.getState().name());
    }

    @Override
    public void write(ToolbarGroupDockStationLayout toolbarGroupDockStationLayout, XElement xElement) {
        XElement xElement2 = xElement.addElement("placeholders");
        toolbarGroupDockStationLayout.getPlaceholders().write(xElement2);
        xElement.addElement("expanded").setString(toolbarGroupDockStationLayout.getState().name());
    }

    @Override
    public ToolbarGroupDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        PlaceholderMap placeholderMap = new PlaceholderMap(dataInputStream, placeholderStrategy);
        placeholderMap.setPlaceholderStrategy(null);
        ExpandedState expandedState = ExpandedState.valueOf(dataInputStream.readUTF());
        return new ToolbarGroupDockStationLayout(placeholderMap, expandedState);
    }

    @Override
    public ToolbarGroupDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        XElement xElement2 = xElement.getElement("placeholders");
        XElement xElement3 = xElement.getElement("expanded");
        PlaceholderMap placeholderMap = new PlaceholderMap(xElement2, placeholderStrategy);
        placeholderMap.setPlaceholderStrategy(null);
        ExpandedState expandedState = ExpandedState.SHRUNK;
        if (xElement3 != null) {
            expandedState = ExpandedState.valueOf(xElement3.getString());
        }
        return new ToolbarGroupDockStationLayout(placeholderMap, expandedState);
    }

    @Override
    public void estimateLocations(ToolbarGroupDockStationLayout toolbarGroupDockStationLayout, final LocationEstimationMap locationEstimationMap) {
        DockablePlaceholderList.simulatedRead(toolbarGroupDockStationLayout.getPlaceholders(), new PlaceholderListItemAdapter<Dockable, Dockable>(){

            @Override
            public Dockable convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                final int n = convertedPlaceholderListItem.getInt("index");
                DockablePlaceholderList.simulatedRead(convertedPlaceholderListItem.getPlaceholderMap(), new PlaceholderListItemAdapter<Dockable, Dockable>(){

                    @Override
                    public Dockable convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                        int n4 = convertedPlaceholderListItem.getInt("id");
                        int n2 = convertedPlaceholderListItem.getInt("index");
                        Path path = null;
                        if (convertedPlaceholderListItem.contains("placeholder")) {
                            path = new Path(convertedPlaceholderListItem.getString("placeholder"));
                        }
                        locationEstimationMap.setLocation(n4, new ToolbarGroupProperty(n, n2, path));
                        int n3 = locationEstimationMap.getSubChildCount(n4);
                        for (int i = 0; i < n3; ++i) {
                            DockLayoutInfo dockLayoutInfo = locationEstimationMap.getSubChild(n4, i);
                            dockLayoutInfo.setLocation(new ToolbarGroupProperty(n, n2, dockLayoutInfo.getPlaceholder()));
                        }
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public ToolbarGroupDockStation layout(ToolbarGroupDockStationLayout toolbarGroupDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        ToolbarGroupDockStation toolbarGroupDockStation = this.createStation();
        this.setLayout(toolbarGroupDockStation, toolbarGroupDockStationLayout, map, placeholderStrategy);
        return toolbarGroupDockStation;
    }

    @Override
    public ToolbarGroupDockStation layout(ToolbarGroupDockStationLayout toolbarGroupDockStationLayout, PlaceholderStrategy placeholderStrategy) {
        ToolbarGroupDockStation toolbarGroupDockStation = this.createStation();
        this.setLayout(toolbarGroupDockStation, toolbarGroupDockStationLayout, placeholderStrategy);
        return toolbarGroupDockStation;
    }

    @Override
    public ToolbarGroupDockPerspective layoutPerspective(ToolbarGroupDockStationLayout toolbarGroupDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        return new ToolbarGroupDockPerspective(toolbarGroupDockStationLayout, map);
    }

    @Override
    public void layoutPerspective(ToolbarGroupDockPerspective toolbarGroupDockPerspective, ToolbarGroupDockStationLayout toolbarGroupDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        toolbarGroupDockPerspective.read(toolbarGroupDockStationLayout, map);
    }

    protected ToolbarGroupDockStation createStation() {
        return new ToolbarGroupDockStation();
    }
}

