/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.title;

import bibliothek.gui.Dockable;
import bibliothek.gui.ToolbarExtension;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class DefaultToolbarDockTitle
extends AbstractDockTitle {
    private final Color color;
    private final DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;

    public static DockTitleFactory createFactory(final Color color) {
        return new DockTitleFactory(){

            @Override
            public void uninstall(DockTitleRequest dockTitleRequest) {
            }

            @Override
            public void request(DockTitleRequest dockTitleRequest) {
                dockTitleRequest.answer(new DefaultToolbarDockTitle(dockTitleRequest.getVersion(), dockTitleRequest.getTarget(), color));
            }

            @Override
            public void install(DockTitleRequest dockTitleRequest) {
            }
        };
    }

    public DefaultToolbarDockTitle(DockTitleVersion dockTitleVersion, Dockable dockable, Color color) {
        super(dockable, dockTitleVersion, true);
        this.color = color;
    }

    @Override
    protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(dockAction, ToolbarExtension.TOOLBAR_TITLE, dockable);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(5, dimension.width), Math.max(5, dimension.height));
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        this.repaint();
    }

    @Override
    public void paintBackground(Graphics graphics, JComponent jComponent) {
        graphics.setColor(this.color);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.isActive()) {
            graphics.setColor(Color.RED);
            if (this.orientation.isHorizontal()) {
                graphics.drawLine(1, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2);
            } else {
                graphics.drawLine(this.getWidth() / 2, 1, this.getWidth() / 2, this.getHeight() - 1);
            }
        }
    }
}

