/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.toolbar.expand;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.magnet.MagnetizedOperation;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;

public class ExpandManager {
    private final PropertyValue<ExpandableToolbarItemStrategy> strategy = new PropertyValue<ExpandableToolbarItemStrategy>(ExpandableToolbarItemStrategy.STRATEGY){

        @Override
        protected void valueChanged(ExpandableToolbarItemStrategy expandableToolbarItemStrategy, ExpandableToolbarItemStrategy expandableToolbarItemStrategy2) {
            if (expandableToolbarItemStrategy != null) {
                expandableToolbarItemStrategy.removeExpandedListener(ExpandManager.this.listener);
            }
            if (expandableToolbarItemStrategy2 != null) {
                expandableToolbarItemStrategy2.addExpandedListener(ExpandManager.this.listener);
            }
        }
    };
    private final ExpandableToolbarItemStrategyListener listener = new ExpandableToolbarItemStrategyListener(){

        @Override
        public void stretched(Dockable dockable) {
            ExpandManager.this.updateLater(dockable);
        }

        @Override
        public void shrunk(Dockable dockable) {
            ExpandManager.this.updateLater(dockable);
        }

        @Override
        public void expanded(Dockable dockable) {
            ExpandManager.this.updateLater(dockable);
        }

        @Override
        public void enablementChanged(Dockable dockable, ExpandedState expandedState, boolean bl) {
        }
    };

    public ExpandManager(DockController dockController) {
        this.strategy.setProperties(dockController);
    }

    private void updateLater(final Dockable dockable) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExpandManager.this.update(dockable);
            }
        });
    }

    public void update(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            if (dockStation instanceof ScreenDockStation) {
                this.update((ScreenDockStation)dockStation, dockable);
            }
            if ((dockable = dockStation.asDockable()) == null) {
                dockStation = null;
                continue;
            }
            dockStation = dockable.getDockParent();
        }
    }

    protected void update(ScreenDockStation screenDockStation, Dockable dockable) {
        ScreenDockWindow screenDockWindow = screenDockStation.getWindow(dockable);
        Insets insets = screenDockWindow.getDockableInsets();
        Dimension dimension = dockable.getComponent().getPreferredSize();
        int n = insets.left + insets.right + dimension.width;
        int n2 = insets.top + insets.bottom + dimension.height;
        Rectangle rectangle = screenDockWindow.getNormalBounds();
        if (rectangle == null) {
            rectangle = screenDockWindow.getWindowBounds();
        }
        rectangle = new Rectangle(rectangle.x, rectangle.y, n, n2);
        MagnetizedOperation magnetizedOperation = screenDockStation.getMagnetController().start(screenDockWindow);
        Rectangle rectangle2 = screenDockStation.getBoundaryRestriction().check(screenDockWindow, rectangle);
        if (rectangle2 != null) {
            rectangle = rectangle2;
        }
        rectangle = magnetizedOperation.attract(rectangle);
        magnetizedOperation.stop();
        if (screenDockWindow.isFullscreen()) {
            screenDockWindow.setNormalBounds(rectangle);
        } else {
            screenDockWindow.setWindowBounds(rectangle);
        }
    }
}

