/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.screen.ScreenDockStationExtension;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;

public class ToolbarScreenDockStationExtension
implements ScreenDockStationExtension {
    private DockController controller;
    private Dockable pending;

    public ToolbarScreenDockStationExtension(DockController dockController) {
        this.controller = dockController;
    }

    @Override
    public boolean canReplace(ScreenDockStation screenDockStation, Dockable dockable, Dockable dockable2) {
        ToolbarStrategy toolbarStrategy = this.controller.getProperties().get(ToolbarStrategy.STRATEGY);
        return toolbarStrategy.isToolbarGroupPartParent(screenDockStation, dockable2, true);
    }

    @Override
    public void drop(ScreenDockStation screenDockStation, ScreenDockStationExtension.DropArguments dropArguments) {
        if (dropArguments.getWindow() == null) {
            Dockable dockable;
            ToolbarStrategy toolbarStrategy = this.controller.getProperties().get(ToolbarStrategy.STRATEGY);
            if (toolbarStrategy.isToolbarPart(dockable = dropArguments.getDockable())) {
                Dockable dockable2 = toolbarStrategy.ensureToolbarLayer(screenDockStation, dockable);
                this.pending = dockable2 != dockable ? dockable : null;
                dropArguments.setDockable(dockable2);
            }
        } else {
            this.pending = null;
        }
    }

    @Override
    public void dropped(ScreenDockStation screenDockStation, ScreenDockStationExtension.DropArguments dropArguments, boolean bl) {
        if (this.pending != null && bl) {
            DockStation dockStation = dropArguments.getDockable().asDockStation();
            DockableProperty dockableProperty = dropArguments.getProperty().getSuccessor();
            if (dockableProperty == null || !dockStation.drop(this.pending, dockableProperty)) {
                dockStation.drop(this.pending);
            }
        }
        this.pending = null;
    }
}

