/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.Point;

public class ToolbarMovingImageFactory
implements DockableMovingImageFactory {
    private DockableMovingImageFactory delegate;

    public ToolbarMovingImageFactory(DockableMovingImageFactory dockableMovingImageFactory) {
        this.delegate = dockableMovingImageFactory;
    }

    @Override
    public MovingImage create(DockController dockController, DockTitle dockTitle) {
        ToolbarStrategy toolbarStrategy = dockController.getProperties().get(ToolbarStrategy.STRATEGY);
        MovingImage movingImage = null;
        if (toolbarStrategy.isToolbarPart(dockTitle.getDockable())) {
            movingImage = this.delegate.create(dockController, dockTitle);
        }
        if (movingImage == null) {
            return null;
        }
        return new OffsetWrapper(movingImage);
    }

    @Override
    public MovingImage create(DockController dockController, Dockable dockable) {
        ToolbarStrategy toolbarStrategy = dockController.getProperties().get(ToolbarStrategy.STRATEGY);
        MovingImage movingImage = null;
        if (toolbarStrategy.isToolbarPart(dockable)) {
            movingImage = this.delegate.create(dockController, dockable);
        }
        if (movingImage == null) {
            return null;
        }
        return new OffsetWrapper(movingImage);
    }

    private class OffsetWrapper
    implements MovingImage {
        private MovingImage image;

        public OffsetWrapper(MovingImage movingImage) {
            this.image = movingImage;
        }

        @Override
        public Point getOffset(Point point) {
            return new Point(-point.x, -point.y);
        }

        @Override
        public void bind(boolean bl) {
            this.image.bind(bl);
        }

        @Override
        public void unbind() {
            this.image.unbind();
        }

        @Override
        public Component getComponent() {
            return this.image.getComponent();
        }
    }
}

