/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.toolbar.expand;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItem;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyValue;

public class ExpandableStateController {
    private final ExpandableToolbarItem item;
    private DockController controller;
    private final PropertyValue<ExpandableToolbarItemStrategy> strategy = new PropertyValue<ExpandableToolbarItemStrategy>(ExpandableToolbarItemStrategy.STRATEGY){

        @Override
        protected void valueChanged(ExpandableToolbarItemStrategy expandableToolbarItemStrategy, ExpandableToolbarItemStrategy expandableToolbarItemStrategy2) {
            if (expandableToolbarItemStrategy != null) {
                expandableToolbarItemStrategy.removeExpandedListener(ExpandableStateController.this.strategyListener);
            }
            if (expandableToolbarItemStrategy2 != null && ExpandableStateController.this.controller != null) {
                expandableToolbarItemStrategy2.addExpandedListener(ExpandableStateController.this.strategyListener);
            }
            ExpandableStateController.this.refresh();
        }
    };
    private final ExpandableToolbarItemStrategyListener strategyListener = new ExpandableToolbarItemStrategyListener(){

        @Override
        public void stretched(Dockable dockable) {
            if (DockUtilities.isAncestor(dockable, ExpandableStateController.this.getItem())) {
                ExpandableStateController.this.refresh();
            }
        }

        @Override
        public void shrunk(Dockable dockable) {
            if (DockUtilities.isAncestor(dockable, ExpandableStateController.this.getItem())) {
                ExpandableStateController.this.refresh();
            }
        }

        @Override
        public void expanded(Dockable dockable) {
            if (DockUtilities.isAncestor(dockable, ExpandableStateController.this.getItem())) {
                ExpandableStateController.this.refresh();
            }
        }

        @Override
        public void enablementChanged(Dockable dockable, ExpandedState expandedState, boolean bl) {
        }
    };

    public ExpandableStateController(ExpandableToolbarItem expandableToolbarItem) {
        if (expandableToolbarItem == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        this.item = expandableToolbarItem;
        expandableToolbarItem.addDockHierarchyListener(new DockHierarchyListener(){

            @Override
            public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
                ExpandableStateController.this.refresh();
            }

            @Override
            public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
                ExpandableStateController.this.controller = ExpandableStateController.this.getItem().getController();
                ExpandableStateController.this.strategy.setProperties(ExpandableStateController.this.controller);
            }
        });
        this.strategy.setProperties(this.getItem().getController());
        this.refresh();
    }

    public ExpandableToolbarItem getItem() {
        return this.item;
    }

    public void refresh() {
        DockStation dockStation;
        if (this.item != null && (dockStation = this.item.getDockParent()) != null) {
            Dockable dockable = dockStation.asDockable();
            ExpandableToolbarItemStrategy expandableToolbarItemStrategy = this.strategy.getValue();
            if (expandableToolbarItemStrategy != null) {
                while (dockable != null) {
                    ExpandedState expandedState = expandableToolbarItemStrategy.getState(dockable);
                    if (expandedState != null) {
                        this.item.setExpandedState(expandedState);
                        return;
                    }
                    dockStation = dockable.getDockParent();
                    if (dockStation != null) {
                        dockable = dockStation.asDockable();
                        continue;
                    }
                    dockable = null;
                }
            }
        }
    }
}

