 kernel void testFunction(	global const float4* listPoints, global int* arePointsInside, const int numPoints, 
    						global const float3* polygonPerfect, const int nbVertices, 
    						global const float* polygonInnerFields,
    						global const float* longueursAretesPerfect, global const float3* aretesNormaliseesPerfect) 
{
        // get index into global data array
        int iGID = get_global_id(0);
        int trueR = 1;
        int falseR = 0;

        // bound check (equivalent to the limit on a 'for' loop for standard/serial C code
        if (iGID >= numPoints)  
        {
            return;
        }

		float3 lePoint = listPoints[iGID].xyz;

		float epsilon = 0.000000001;
		const float tolerance = 0.0001;
		
		int nbIntersections = 0;
		float3 areteNormalisee;
		float longueurArete;
		int i1;
		int i2;
		
		float3 O = (float3)(polygonInnerFields[0], polygonInnerFields[1], polygonInnerFields[2]);
		float3 U = (float3)(polygonInnerFields[3], polygonInnerFields[4], polygonInnerFields[5]);
		float3 V = (float3)(polygonInnerFields[6], polygonInnerFields[7], polygonInnerFields[8]);
		float3 N = (float3)(polygonInnerFields[9], polygonInnerFields[10], polygonInnerFields[11]);
		float uMin = polygonInnerFields[12];
		float vMin = polygonInnerFields[13];
		float uMax = polygonInnerFields[14];
		float vMax = polygonInnerFields[15];

		float3 OP = lePoint-O;

		float scalU = dot(OP, U);
		float scalV = dot(OP, V);
		float scalN = dot(OP, N);

		if ((scalU<uMin)||(scalU>uMax)||(scalV<vMin)||(scalV>vMax)||(fabs(scalN)<tolerance))
		{
			arePointsInside[iGID] = 0;
            return;
        }
		
		for (int i=0; i<nbVertices; i++)
		{
			//-----------------------------------------------------------
			//CALCUL POUR UNE ARETE
			//-----------------------------------------------------------
			i1 = i;
			//i2 = (i+1) % nbVertices;
	
			areteNormalisee = aretesNormaliseesPerfect[i];
			longueurArete = longueursAretesPerfect[i];
			
			//-----------------------------------------------------------
			//TEST D'INTERSECTION AVEC UN SEGMENT
			//-----------------------------------------------------------
			//Par défaut on considère qu'il y a intersection
			bool bIntersectSegment = true;
			
			float scal = dot(U, areteNormalisee);
			float scalAbs = fabs(scal);
			
			float3 crossProd = cross(U, areteNormalisee);
			float norm = length(crossProd);
	
			crossProd /= norm;
			
			float3 w = cross(U, crossProd);
			float3 PP1 = polygonPerfect[i1] - lePoint;
			
			float dist = dot(PP1, crossProd);
			float dotWithW = dot(areteNormalisee, w);
			float dotWithU = dot(areteNormalisee, U);
			
			float lambda = -dot(PP1, w)/dotWithW;
			float mu = dot(PP1, U) + lambda*dotWithU;
			
			//TRUE si :
			//fabs(scalAbs-1.0)>epsilon
			//lambda>=0
			//lambda<=longueurArete
			//mu>=0
			//fabs(dist)<=tolerance
			
			int scalHigherThanEpsilon = (int) (fabs(scalAbs-1.0)>epsilon);
			int lambdaUnderArrete = (int) (lambda<=longueurArete);
			int lambdaOK = (int) (lambda>=0.0);					
			int aboveTolerance = (int) (fabs(dist)<=tolerance);
			int muOK = (int) (mu>=0.0);		
			
			
			//int scalHigherThanEpsilon = 0;
			//int lambdaUnderArrete = 0;
			//int lambdaOK = 0;					
			//int aboveTolerance = 0;
			//int muOK = 0;		
			
			
			int iIntersects = scalHigherThanEpsilon * lambdaUnderArrete * lambdaOK * aboveTolerance * muOK;

			//attention, iIntersects DOIT être 1/0
			nbIntersections += iIntersects;	
		}
		
		//-----------------------------------------------------------
		//LE POINT APPARTIENT AU POLYGONE SI LE NOMBRE D'INTERSECTIONS EST IMPAIR
		//-----------------------------------------------------------
		arePointsInside[iGID] = (int)((nbIntersections % 2!=0));
	}
 }
