/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.CompileState;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.AxisAngle4d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Tuple4d;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;
import org.jogamp.vecmath.Vector4d;

class OrientedShape3DRetained
extends Shape3DRetained {
    static final int ALIGNMENT_CHANGED = 32;
    static final int AXIS_CHANGED = 64;
    static final int ROTATION_CHANGED = 128;
    static final int CONSTANT_SCALE_CHANGED = 256;
    static final int SCALE_FACTOR_CHANGED = 512;
    int mode = 0;
    Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
    Point3f rotationPoint = new Point3f(0.0f, 0.0f, 1.0f);
    private Vector3d nAxis = new Vector3d(0.0, 1.0, 0.0);
    private Point3d viewPosition = new Point3d();
    private Point3d yUpPoint = new Point3d();
    private Vector3d eyeVec = new Vector3d();
    private Vector3d yUp = new Vector3d();
    private Vector3d zAxis = new Vector3d();
    private Vector3d yAxis = new Vector3d();
    private Vector3d vector = new Vector3d();
    private AxisAngle4d aa = new AxisAngle4d();
    private Transform3D xform = new Transform3D();
    private Transform3D zRotate = new Transform3D();
    boolean constantScale = false;
    double scaleFactor = 1.0;
    private Transform3D left_xform = new Transform3D();
    private Transform3D right_xform = new Transform3D();
    Transform3D scaleXform = new Transform3D();
    private Vector4d[] im_vec = new Vector4d[]{new Vector4d(), new Vector4d()};
    private Vector4d lvec = new Vector4d();
    boolean orientedTransformDirty = true;
    private final Object transformLock = new Object();
    private Transform3D[] orientedTransforms = new Transform3D[1];
    static final double EPSILON = 1.0E-6;

    public OrientedShape3DRetained() {
        this.nodeType = 28;
    }

    void initAlignmentMode(int mode) {
        this.mode = mode;
    }

    void setAlignmentMode(int mode) {
        if (this.mode != mode) {
            this.initAlignmentMode(mode);
            this.sendChangedMessage(32, new Integer(mode));
        }
    }

    int getAlignmentMode() {
        return this.mode;
    }

    void initAlignmentAxis(Vector3f axis) {
        this.initAlignmentAxis(axis.x, axis.y, axis.z);
    }

    void initAlignmentAxis(float x, float y, float z) {
        this.axis.set(x, y, z);
        double invMag = 1.0 / Math.sqrt(this.axis.x * this.axis.x + this.axis.y * this.axis.y + this.axis.z * this.axis.z);
        this.nAxis.x = (double)this.axis.x * invMag;
        this.nAxis.y = (double)this.axis.y * invMag;
        this.nAxis.z = (double)this.axis.z * invMag;
    }

    void setAlignmentAxis(Vector3f axis) {
        this.setAlignmentAxis(axis.x, axis.y, axis.z);
    }

    void setAlignmentAxis(float x, float y, float z) {
        this.initAlignmentAxis(x, y, z);
        if (this.mode == 0) {
            this.sendChangedMessage(64, new Vector3f(x, y, z));
        }
    }

    void getAlignmentAxis(Vector3f axis) {
        axis.set((Tuple3f)this.axis);
    }

    void initRotationPoint(Point3f point) {
        this.rotationPoint.set((Tuple3f)point);
    }

    void initRotationPoint(float x, float y, float z) {
        this.rotationPoint.set(x, y, z);
    }

    void setRotationPoint(Point3f point) {
        this.setRotationPoint(point.x, point.y, point.z);
    }

    void setRotationPoint(float x, float y, float z) {
        this.initRotationPoint(x, y, z);
        if (this.mode == 1) {
            this.sendChangedMessage(128, new Point3f(x, y, z));
        }
    }

    void getRotationPoint(Point3f point) {
        point.set((Tuple3f)this.rotationPoint);
    }

    void setConstantScaleEnable(boolean enable) {
        if (this.constantScale != enable) {
            this.initConstantScaleEnable(enable);
            this.sendChangedMessage(256, new Boolean(enable));
        }
    }

    boolean getConstantScaleEnable() {
        return this.constantScale;
    }

    void initConstantScaleEnable(boolean cons_scale) {
        this.constantScale = cons_scale;
    }

    void setScale(double scale) {
        this.initScale(scale);
        if (this.constantScale) {
            this.sendChangedMessage(512, new Double(scale));
        }
    }

    void initScale(double scale) {
        this.scaleFactor = scale;
    }

    double getScale() {
        return this.scaleFactor;
    }

    void sendChangedMessage(int component, Object attr) {
        J3dMessage changeMessage = new J3dMessage();
        changeMessage.type = 46;
        changeMessage.threads = 4224;
        changeMessage.universe = this.universe;
        changeMessage.args[0] = OrientedShape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
        changeMessage.args[1] = new Integer(component);
        changeMessage.args[2] = attr;
        OrientedShape3DRetained[] o3dArr = new OrientedShape3DRetained[this.mirrorShape3D.size()];
        this.mirrorShape3D.toArray(o3dArr);
        changeMessage.args[3] = o3dArr;
        changeMessage.args[4] = this;
        VirtualUniverse.mc.processMessage(changeMessage);
    }

    @Override
    void updateImmediateMirrorObject(Object[] args) {
        int component = (Integer)args[1];
        if ((component & 0x3E0) != 0) {
            OrientedShape3DRetained[] msArr = (OrientedShape3DRetained[])args[3];
            Object obj = args[2];
            if ((component & 0x20) != 0) {
                int mode = (Integer)obj;
                for (int i = 0; i < msArr.length; ++i) {
                    msArr[i].initAlignmentMode(mode);
                }
            } else if ((component & 0x40) != 0) {
                Vector3f axis = (Vector3f)obj;
                for (int i = 0; i < msArr.length; ++i) {
                    msArr[i].initAlignmentAxis(axis);
                }
            } else if ((component & 0x80) != 0) {
                Point3f point = (Point3f)obj;
                for (int i = 0; i < msArr.length; ++i) {
                    msArr[i].initRotationPoint(point);
                }
            } else if ((component & 0x100) != 0) {
                boolean bool = (Boolean)obj;
                for (int i = 0; i < msArr.length; ++i) {
                    msArr[i].initConstantScaleEnable(bool);
                }
            } else if ((component & 0x200) != 0) {
                double scale = (Double)obj;
                for (int i = 0; i < msArr.length; ++i) {
                    msArr[i].initScale(scale);
                }
            }
        } else {
            super.updateImmediateMirrorObject(args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Transform3D getOrientedTransform(int viewIndex) {
        Object object = this.transformLock;
        synchronized (object) {
            if (viewIndex >= this.orientedTransforms.length) {
                Transform3D[] newList = new Transform3D[viewIndex + 1];
                System.arraycopy(this.orientedTransforms, 0, newList, 0, this.orientedTransforms.length);
                this.orientedTransforms = newList;
            }
            if (this.orientedTransforms[viewIndex] == null) {
                this.orientedTransforms[viewIndex] = new Transform3D();
            }
            return this.orientedTransforms[viewIndex];
        }
    }

    synchronized void updateOrientedTransform(Canvas3D canvas, int viewIndex) {
        double angle = 0.0;
        Transform3D orientedxform = this.getOrientedTransform(viewIndex);
        if (this.mode == 0) {
            canvas.getCenterEyeInImagePlate(this.viewPosition);
            canvas.getImagePlateToVworld(this.xform);
            this.xform.transform(this.viewPosition);
            this.xform.set(this.getCurrentLocalToVworld());
            this.xform.invert();
            this.xform.transform(this.viewPosition);
            this.eyeVec.set((Tuple3d)this.viewPosition);
            this.eyeVec.normalize();
            boolean status = this.projectToPlane(this.eyeVec, this.nAxis);
            if (status) {
                this.zAxis.x = 0.0;
                this.zAxis.y = 0.0;
                this.zAxis.z = 1.0;
                status = this.projectToPlane(this.zAxis, this.nAxis);
            }
            if (status) {
                this.vector.cross(this.eyeVec, this.zAxis);
                double sign = this.vector.dot(this.nAxis) > 0.0 ? 1.0 : -1.0;
                double dot = this.eyeVec.dot(this.zAxis);
                if (dot > 1.0) {
                    dot = 1.0;
                } else if (dot < -1.0) {
                    dot = -1.0;
                }
                angle = sign * Math.acos(dot);
                this.aa.x = this.nAxis.x;
                this.aa.y = this.nAxis.y;
                this.aa.z = this.nAxis.z;
                this.aa.angle = -angle;
                orientedxform.set(this.aa);
            } else {
                orientedxform.setIdentity();
            }
        } else if (this.mode == 1) {
            double dot;
            canvas.getCenterEyeInImagePlate(this.viewPosition);
            this.yUpPoint.set((Tuple3d)this.viewPosition);
            this.yUpPoint.y += 0.01;
            canvas.getImagePlateToVworld(this.xform);
            this.xform.transform(this.viewPosition);
            this.xform.transform(this.yUpPoint);
            this.xform.set(this.getCurrentLocalToVworld());
            this.xform.invert();
            this.xform.transform(this.viewPosition);
            this.xform.transform(this.yUpPoint);
            this.eyeVec.set((Tuple3d)this.viewPosition);
            this.eyeVec.normalize();
            this.yUp.set((Tuple3d)this.yUpPoint);
            this.yUp.sub((Tuple3d)this.viewPosition);
            this.yUp.normalize();
            this.zAxis.x = 0.0;
            this.zAxis.y = 0.0;
            this.zAxis.z = 1.0;
            this.vector.cross(this.eyeVec, this.zAxis);
            double length = this.vector.length();
            if (length > 1.0E-4) {
                dot = this.eyeVec.dot(this.zAxis);
                if (dot > 1.0) {
                    dot = 1.0;
                } else if (dot < -1.0) {
                    dot = -1.0;
                }
                angle = Math.acos(dot);
                this.aa.x = this.vector.x;
                this.aa.y = this.vector.y;
                this.aa.z = this.vector.z;
                this.aa.angle = -angle;
                this.zRotate.set(this.aa);
            } else {
                this.zRotate.set(1.0);
            }
            this.yAxis.x = 0.0;
            this.yAxis.y = 1.0;
            this.yAxis.z = 0.0;
            this.zRotate.transform(this.yAxis);
            boolean status = this.projectToPlane(this.yAxis, this.eyeVec);
            if (status) {
                status = this.projectToPlane(this.yUp, this.eyeVec);
            }
            if (status) {
                dot = this.yUp.dot(this.yAxis);
                if (dot > 1.0) {
                    dot = 1.0;
                } else if (dot < -1.0) {
                    dot = -1.0;
                }
                angle = Math.acos(dot);
                this.vector.cross(this.yUp, this.yAxis);
                if (this.eyeVec.dot(this.vector) < 0.0) {
                    angle *= -1.0;
                }
                this.aa.x = this.eyeVec.x;
                this.aa.y = this.eyeVec.y;
                this.aa.z = this.eyeVec.z;
                this.aa.angle = -angle;
                this.xform.set(this.aa);
                this.vector.x = this.rotationPoint.x;
                this.vector.y = this.rotationPoint.y;
                this.vector.z = this.rotationPoint.z;
                orientedxform.set(this.vector);
                orientedxform.mul(this.xform);
                orientedxform.mul(this.zRotate);
                this.vector.scale(-1.0);
                this.xform.set(this.vector);
                orientedxform.mul(this.xform);
            } else {
                orientedxform.setIdentity();
            }
        }
        if (this.constantScale) {
            canvas.getInverseVworldProjection(this.left_xform, this.right_xform);
            this.im_vec[0].set(0.0, 0.0, 0.0, 1.0);
            this.im_vec[1].set(1.0, 0.0, 0.0, 1.0);
            this.left_xform.transform(this.im_vec[0]);
            this.left_xform.transform(this.im_vec[1]);
            this.left_xform.set(this.getCurrentLocalToVworld());
            this.left_xform.invert();
            this.left_xform.transform(this.im_vec[0]);
            this.left_xform.transform(this.im_vec[1]);
            this.lvec.set((Tuple4d)this.im_vec[1]);
            this.lvec.sub((Tuple4d)this.im_vec[0]);
            this.lvec.normalize();
            this.im_vec[0].set(0.0, 0.0, 0.0, 1.0);
            this.im_vec[1].set((Tuple4d)this.lvec);
            this.im_vec[1].w = 1.0;
            this.left_xform.set(this.getCurrentLocalToVworld());
            this.left_xform.transform(this.im_vec[0]);
            this.left_xform.transform(this.im_vec[1]);
            canvas.getVworldProjection(this.left_xform, this.right_xform);
            this.left_xform.transform(this.im_vec[0]);
            this.left_xform.transform(this.im_vec[1]);
            this.im_vec[0].x /= this.im_vec[0].w;
            this.im_vec[0].y /= this.im_vec[0].w;
            this.im_vec[0].z /= this.im_vec[0].w;
            this.im_vec[1].x /= this.im_vec[1].w;
            this.im_vec[1].y /= this.im_vec[1].w;
            this.im_vec[1].z /= this.im_vec[1].w;
            this.lvec.set((Tuple4d)this.im_vec[1]);
            this.lvec.sub((Tuple4d)this.im_vec[0]);
            double scale = 1.0 / this.lvec.length();
            this.scaleXform.setScale(scale *= this.scaleFactor * canvas.getPhysicalWidth() / 2.0);
            orientedxform.mul(this.scaleXform);
        }
    }

    private boolean projectToPlane(Vector3d projVec, Vector3d planeVec) {
        double dis = planeVec.dot(projVec);
        projVec.x -= planeVec.x * dis;
        projVec.y -= planeVec.y * dis;
        projVec.z -= planeVec.z * dis;
        double length = projVec.length();
        if (length < 1.0E-6) {
            return false;
        }
        projVec.scale(1.0 / length);
        return true;
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        this.mergeFlag = 0;
        compState.keepTG = true;
    }

    @Override
    void searchGeometryAtoms(UnorderList list) {
        list.add(OrientedShape3DRetained.getGeomAtom(this.getMirrorShape(this.key)));
    }
}

