/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.util.ByteArray;

public class ChecksumOperation
implements Loggable {
    private byte checksumAlgo;
    private long checksumValue;
    private int dataLength;
    private Checksum checksum;
    public static final byte CRC32_ALGORITHM = 1;
    private static final int formatLength = FormatIdUtil.getFormatIdByteLength(453);

    public void init() {
        this.checksumAlgo = 1;
        this.initializeChecksumAlgo();
        this.dataLength = 0;
    }

    protected void update(byte[] byArray, int n, int n2) {
        this.checksum.update(byArray, n, n2);
        this.dataLength += n2;
    }

    protected void reset() {
        this.checksum.reset();
        this.dataLength = 0;
    }

    private void initializeChecksumAlgo() {
        if (this.checksumAlgo == 1) {
            this.checksum = new CRC32();
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.checksumValue = this.checksum.getValue();
        objectOutput.writeByte(this.checksumAlgo);
        objectOutput.writeInt(this.dataLength);
        objectOutput.writeLong(this.checksumValue);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.checksumAlgo = (byte)objectInput.readUnsignedByte();
        this.dataLength = objectInput.readInt();
        this.checksumValue = objectInput.readLong();
        this.initializeChecksumAlgo();
    }

    public int getStoredSize() {
        return formatLength + 1 + 4 + 8;
    }

    @Override
    public int getTypeFormatId() {
        return 453;
    }

    @Override
    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
    }

    @Override
    public ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public boolean needsRedo(Transaction transaction) {
        return false;
    }

    @Override
    public void releaseResource(Transaction transaction) {
    }

    @Override
    public int group() {
        return 2304;
    }

    protected int getDataLength() {
        return this.dataLength;
    }

    protected boolean isChecksumValid(byte[] byArray, int n, int n2) {
        this.checksum.reset();
        this.checksum.update(byArray, n, n2);
        return this.checksum.getValue() == this.checksumValue;
    }

    public String toString() {
        return null;
    }
}

